/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.Authenticator;
import io.hawt.system.ConfigManager;
import io.hawt.web.auth.AuthenticationConfiguration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthSessionHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(AuthSessionHelpers.class);
    public static final String SESSION_TIMEOUT = "sessionTimeout";
    public static final String HAWTIO_SESSION_TIMEOUT = "hawtio.sessionTimeout";
    public static final int DEFAULT_SESSION_TIMEOUT = 1800;

    private AuthSessionHelpers() {
    }

    public static int getSessionTimeout(ServletContext context) {
        int timeout = 1800;
        ConfigManager configManager = (ConfigManager)context.getAttribute("ConfigManager");
        if (configManager == null) {
            return timeout;
        }
        String timeoutStr = configManager.get(SESSION_TIMEOUT).orElse(Integer.toString(1800));
        try {
            timeout = Integer.parseInt(timeoutStr);
            if (timeout == 0) {
                timeout = 1800;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    public static void clear(HttpServletRequest request, AuthenticationConfiguration authConfig, boolean authenticatorLogout) {
        HttpSession session = request.getSession(false);
        if (!AuthSessionHelpers.isAuthenticated(session)) {
            return;
        }
        Subject subject = (Subject)session.getAttribute("subject");
        LOG.info("Logging out existing user: {}", session.getAttribute("user"));
        if (authenticatorLogout) {
            Authenticator.logout(authConfig, subject);
        }
        session.invalidate();
    }

    public static void setup(HttpSession session, Subject subject, String username, int timeout) {
        session.setAttribute("subject", (Object)subject);
        session.setAttribute("user", (Object)username);
        session.setAttribute("loginTime", (Object)GregorianCalendar.getInstance().getTimeInMillis());
        session.setMaxInactiveInterval(timeout);
        LOG.debug("Http session timeout for user {} is {} sec.", (Object)username, (Object)session.getMaxInactiveInterval());
    }

    public static boolean validate(HttpServletRequest request, HttpSession session, Subject subject) {
        if (session == null || subject == null) {
            return false;
        }
        String sessionUser = (String)session.getAttribute("user");
        AtomicReference username = new AtomicReference();
        Authenticator.extractAuthHeader(request, (u, p) -> username.set(u));
        if (username.get() == null || ((String)username.get()).equals(sessionUser)) {
            LOG.debug("Session subject - {}", (Object)subject);
            return true;
        }
        LOG.debug("User differs, re-authenticating: {} (request) != {} (session)", username.get(), (Object)sessionUser);
        session.invalidate();
        return false;
    }

    public static boolean isAuthenticated(HttpSession session) {
        return session != null && session.getAttribute("subject") != null;
    }
}

