/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.osgi.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jolokia.server.core.osgi.security.Authenticator;
import org.jolokia.server.core.osgi.security.DefaultServletContextHelper;
import org.jolokia.server.core.osgi.util.LogHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceAuthenticationServletContextHelper
extends DefaultServletContextHelper {
    static final String AUTHMODE_SERVICE_ALL = "service-all";
    static final String AUTHMODE_SERVICE_ANY = "service-any";
    private final Set<Authenticator> authenticators = new HashSet<Authenticator>();
    private ServiceTracker<Authenticator, Authenticator> authenticatorServiceTracker;
    private final boolean checkModeAny;

    public ServiceAuthenticationServletContextHelper(BundleContext bundleContext, String authMode) {
        if (!ServiceAuthenticationServletContextHelper.shouldBeUsed(authMode)) {
            throw new IllegalArgumentException(String.format("Internal: Invalid authMode %s given", authMode));
        }
        this.checkModeAny = authMode.equalsIgnoreCase(AUTHMODE_SERVICE_ANY);
        this.authenticatorServiceTracker = new ServiceTracker(bundleContext, Authenticator.class.getName(), (ServiceTrackerCustomizer)new AuthenticatorServiceCustomizer(bundleContext));
        this.authenticatorServiceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Set<Authenticator> set = this.authenticators;
        synchronized (set) {
            if (this.authenticators.isEmpty()) {
                response.sendError(401);
                return false;
            }
            for (Authenticator authenticator : this.authenticators) {
                boolean authenticated = authenticator.authenticate(request);
                if (this.checkModeAny && authenticated) {
                    return true;
                }
                if (this.checkModeAny || authenticated) continue;
                response.sendError(401);
                return false;
            }
            return !this.checkModeAny;
        }
    }

    public void close() {
        if (this.authenticatorServiceTracker != null) {
            this.authenticatorServiceTracker.close();
            this.authenticatorServiceTracker = null;
        }
    }

    public static boolean shouldBeUsed(String authMode) {
        return authMode != null && (authMode.equalsIgnoreCase(AUTHMODE_SERVICE_ALL) || authMode.equalsIgnoreCase(AUTHMODE_SERVICE_ANY));
    }

    private class AuthenticatorServiceCustomizer
    implements ServiceTrackerCustomizer<Authenticator, Authenticator> {
        private final BundleContext bundleContext;

        AuthenticatorServiceCustomizer(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Authenticator addingService(ServiceReference<Authenticator> serviceReference) {
            Authenticator service = (Authenticator)this.bundleContext.getService(serviceReference);
            try {
                Set<Authenticator> set = ServiceAuthenticationServletContextHelper.this.authenticators;
                synchronized (set) {
                    ServiceAuthenticationServletContextHelper.this.authenticators.add(service);
                    return service;
                }
            }
            catch (ClassCastException e) {
                LogHelper.logError("Unable to use provided Authenticator", e);
                return null;
            }
        }

        public void modifiedService(ServiceReference<Authenticator> serviceReference, Authenticator service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<Authenticator> serviceReference, Authenticator service) {
            Set<Authenticator> set = ServiceAuthenticationServletContextHelper.this.authenticators;
            synchronized (set) {
                this.bundleContext.ungetService(serviceReference);
                ServiceAuthenticationServletContextHelper.this.authenticators.remove(service);
            }
        }
    }
}

