/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.management.impl.ManagementRemotingConnection;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.GuardInvocationHandler;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;

public class ArtemisRbacInvocationHandler
implements GuardInvocationHandler {
    private final List<String> mBeanServerCheckedMethods = List.of("invoke", "getAttribute", "getAttributes", "setAttribute", "setAttributes", "queryMBeans", "queryNames");
    private final List<String> uncheckedDomains = List.of("hawtio");
    private final MBeanServer delegate;
    private volatile ActiveMQServer activeMQServer;
    String brokerDomain;
    Pattern viewPermissionMatcher;
    SimpleString rbacPrefix;
    SimpleString mBeanServerRbacAddressPrefix;
    private final SecurityAuth delegateToAccessController = new SecurityAuth(){
        final ManagementRemotingConnection managementRemotingConnection = new ManagementRemotingConnection(){

            @Override
            public Subject getSubject() {
                return SecurityManagerShim.currentSubject();
            }
        };

        @Override
        public String getUsername() {
            return null;
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public RemotingConnection getRemotingConnection() {
            return this.managementRemotingConnection;
        }

        @Override
        public String getSecurityDomain() {
            return null;
        }
    };

    ArtemisRbacInvocationHandler(MBeanServer mbeanServer) {
        this.delegate = mbeanServer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        this.initAuditLoggerContext();
        if (this.mBeanServerCheckedMethods.contains(method.getName())) {
            if (this.activeMQServer != null) {
                this.securityCheck(method, args);
            } else {
                if (method.getName().startsWith("query")) {
                    return null;
                }
                if (!this.isUncheckedDomain(args)) {
                    throw new IllegalStateException("initialisation pending");
                }
            }
        } else {
            this.initializeFromFirstServerMBeanRegistration(method, args);
        }
        try {
            result = method.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        if (method.getName().startsWith("query") && result instanceof Collection) {
            Collection collection = (Collection)result;
            collection.removeIf(this::viewPermissionCheckFails);
        }
        return result;
    }

    private boolean isUncheckedDomain(Object[] args) {
        ObjectName objectName = this.objectNameFrom(args);
        return this.isUncheckedDomain(objectName);
    }

    private boolean isUncheckedDomain(ObjectName objectName) {
        if (objectName != null) {
            return this.uncheckedDomains.contains(objectName.getDomain());
        }
        return false;
    }

    private ObjectName objectNameFrom(Object[] args) {
        ObjectName on;
        Object object;
        return args != null && args.length > 0 && (object = args[0]) instanceof ObjectName ? (on = (ObjectName)object) : null;
    }

    @Override
    public boolean canInvoke(String name, String operationName) {
        boolean okInvoke = false;
        try {
            ObjectName objectName = ObjectName.getInstance(name);
            if (!this.isUncheckedDomain(objectName)) {
                SimpleString rbacAddress = this.addressFrom(objectName, operationName);
                this.securityStoreCheck(rbacAddress, this.permissionFrom(operationName));
            }
            okInvoke = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return okInvoke;
    }

    private void initializeFromFirstServerMBeanRegistration(Method method, Object[] args) {
        Object object;
        if (this.activeMQServer == null && method.getName().equals("registerMBean") && args != null && (object = args[0]) instanceof ActiveMQServerControlImpl) {
            ActiveMQServerControlImpl serverControl = (ActiveMQServerControlImpl)object;
            this.activeMQServer = serverControl.getServer();
            this.brokerDomain = this.activeMQServer.getConfiguration().getJMXDomain();
            this.viewPermissionMatcher = Pattern.compile(this.activeMQServer.getConfiguration().getViewPermissionMethodMatchPattern());
            this.rbacPrefix = SimpleString.of((String)this.activeMQServer.getConfiguration().getManagementRbacPrefix());
            this.mBeanServerRbacAddressPrefix = this.rbacPrefix.concat(".mbeanserver.");
            serverControl.getServer().registerActivateCallback(new ActivateCallback(){

                @Override
                public void shutdown(ActiveMQServer server) {
                    try {
                        ArtemisRbacInvocationHandler.this.activeMQServer.getManagementService().unregisterHawtioSecurity();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArtemisRbacInvocationHandler.this.activeMQServer = null;
                }
            });
            try {
                this.activeMQServer.getManagementService().registerHawtioSecurity(this);
            }
            catch (Exception bestEffort) {
                bestEffort.printStackTrace();
            }
        }
    }

    private void initAuditLoggerContext() {
        if (AuditLogger.isAnyLoggingEnabled() && AuditLogger.getRemoteAddress() == null) {
            String url = "internal";
            String name = Thread.currentThread().getName();
            if (name.startsWith("RMI TCP Connection")) {
                url = name.substring(name.indexOf(45) + 1);
            }
            AuditLogger.setRemoteAddress((String)url);
        }
    }

    void securityCheck(Method method, Object[] args) {
        if (this.isUncheckedDomain(args)) {
            return;
        }
        try {
            String methodName = method.getName();
            if ("getAttribute".equals(methodName)) {
                this.handleGetAttribute(this.delegate, (ObjectName)args[0], (String)args[1]);
            } else if ("getAttributes".equals(methodName)) {
                this.handleGetAttributes(this.delegate, (ObjectName)args[0], (String[])args[1]);
            } else if ("setAttribute".equals(methodName)) {
                this.handleSetAttribute(this.delegate, (ObjectName)args[0], (Attribute)args[1]);
            } else if ("setAttributes".equals(methodName)) {
                this.handleSetAttributes(this.delegate, (ObjectName)args[0], (AttributeList)args[1]);
            } else if ("invoke".equals(methodName)) {
                this.handleInvoke((ObjectName)args[0], (String)args[1]);
            } else if (method.getName().startsWith("query")) {
                SimpleString rbacAddress = this.mBeanServerRbacAddressPrefix.concat(methodName);
                this.securityStoreCheck(rbacAddress, this.permissionFrom(methodName));
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
    }

    private void handleSetAttributes(MBeanServer delegate, ObjectName objectName, AttributeList attributeList) throws Exception {
        for (Attribute attributeName : attributeList.asList()) {
            this.handleSetAttribute(delegate, objectName, attributeName);
        }
    }

    private void handleSetAttribute(MBeanServer delegate, ObjectName objectName, Attribute attributeName) throws Exception {
        this.handleInvoke(objectName, "set" + String.valueOf(attributeName));
    }

    private void handleGetAttributes(MBeanServer delegate, ObjectName objectName, String[] attributes) throws Exception {
        for (String attribute : attributes) {
            this.handleGetAttribute(delegate, objectName, attribute);
        }
    }

    private void handleGetAttribute(MBeanServer delegate, ObjectName objectName, String attributeName) throws Exception {
        MBeanInfo info = delegate.getMBeanInfo(objectName);
        String prefix = "get";
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attributeName)) continue;
            prefix = attr.isIs() ? "is" : "get";
            break;
        }
        this.handleInvoke(objectName, prefix + attributeName);
    }

    private void handleInvoke(ObjectName objectName, String operationName) throws Exception {
        SimpleString rbacAddress = this.addressFrom(objectName, operationName);
        CheckType permission = this.permissionFrom(operationName);
        this.securityStoreCheck(rbacAddress, permission);
    }

    CheckType permissionFrom(String methodName) {
        if (methodName != null && this.viewPermissionMatcher.matcher(methodName).matches()) {
            return CheckType.VIEW;
        }
        return CheckType.EDIT;
    }

    String removeQuotes(String key) {
        if (key != null && key.endsWith("\"")) {
            return key.replace("\"", "");
        }
        return key;
    }

    SimpleString addressFrom(ObjectName objectName) {
        return this.addressFrom(objectName, null);
    }

    SimpleString addressFrom(ObjectName objectName, String methodName) {
        String name = this.removeQuotes(objectName.getKeyProperty("name"));
        String component = this.removeQuotes(objectName.getKeyProperty("component"));
        String type = null;
        SimpleString rbacAddress = this.rbacPrefix;
        if (this.brokerDomain.equals(objectName.getDomain())) {
            if (component != null) {
                if ("addresses".equals(component)) {
                    component = "address";
                    String subComponent = objectName.getKeyProperty("subcomponent");
                    if ("diverts".equals(subComponent)) {
                        component = "divert";
                    } else if ("queues".equals(subComponent)) {
                        component = "queue";
                    }
                    name = this.removeQuotes(objectName.getKeyProperty(component));
                }
            } else {
                String brokerName = this.removeQuotes(objectName.getKeyProperty("broker"));
                if (brokerName != null) {
                    component = "broker";
                }
            }
        } else {
            rbacAddress = rbacAddress.concat('.').concat(objectName.getDomain());
            type = this.removeQuotes(objectName.getKeyProperty("type"));
        }
        if (type != null) {
            rbacAddress = rbacAddress.concat('.').concat(type);
        }
        if (component != null) {
            rbacAddress = rbacAddress.concat('.').concat(component);
        }
        if (name != null) {
            rbacAddress = rbacAddress.concat('.').concat(name);
        }
        if (methodName != null) {
            rbacAddress = rbacAddress.concat('.').concat(methodName);
        }
        return rbacAddress;
    }

    private boolean viewPermissionCheckFails(Object candidate) {
        ObjectName objectName;
        boolean failed = false;
        if (candidate instanceof ObjectInstance) {
            ObjectInstance oi = (ObjectInstance)candidate;
            v0 = oi.getObjectName();
        } else {
            v0 = objectName = (ObjectName)candidate;
        }
        if (!this.isUncheckedDomain(objectName)) {
            try {
                SimpleString rbacAddress = this.addressFrom(objectName);
                this.securityStoreCheck(rbacAddress, CheckType.VIEW);
            }
            catch (Exception checkFailed) {
                failed = true;
            }
        }
        return failed;
    }

    private void securityStoreCheck(SimpleString rbacAddress, CheckType checkType) throws Exception {
        this.activeMQServer.getSecurityStore().check(rbacAddress, checkType, this.delegateToAccessController);
    }
}

