/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;

public class AMQPBridgeConfiguration {
    private final Map<String, Object> properties;
    private final AMQPConnectionContext connection;

    public AMQPBridgeConfiguration(AMQPConnectionContext connection, Map<String, Object> properties) {
        Objects.requireNonNull(connection, "Connection provided cannot be null");
        this.connection = connection;
        this.properties = properties != null && !properties.isEmpty() ? new HashMap<String, Object>(properties) : Collections.emptyMap();
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.connection.getAmqpCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.connection.getAmqpLowCredits();
    }

    public int getPullReceiverBatchSize() {
        Object property = this.properties.get("amqpPullConsumerCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 10;
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.connection.getProtocolManager().getAmqpMinLargeMessageSize();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 30;
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return true;
    }

    public boolean isIgnoreSubscriptionFilters() {
        Object property = this.properties.get("ignoreQueueConsumerFilters");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return false;
    }

    public boolean isIgnoreQueueFilters() {
        Object property = this.properties.get("ignoreQueueFilters");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return false;
    }

    public boolean isReceiverPriorityDisabled() {
        Object property = this.properties.get("disableReceiverPriority");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return false;
    }

    public boolean isReceiverDemandTrackingDisabled() {
        Object property = this.properties.get("disableReceiverDemandTracking");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return false;
    }

    public int getReceiverQuiesceTimeout() {
        Object property = this.properties.get("receiverQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 60000;
    }

    public int getAddressReceiverIdleTimeout() {
        Object property = this.properties.get("addressReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 5000;
    }

    public int getQueueReceiverIdleTimeout() {
        Object property = this.properties.get("queueReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return 60000;
    }

    public boolean isUsingPresettledSenders() {
        Object property = this.properties.get("presettle");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return false;
    }

    public int getMaxLinkRecoveryAttempts() {
        Object property = this.properties.get("maxLinkRecoveryAttempts");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return -1;
    }

    public long getLinkRecoveryInitialDelay() {
        Object property = this.properties.get("linkRecoveryInitialDelay");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 1000L;
    }

    public long getLinkRecoveryDelay() {
        Object property = this.properties.get("linkRecoveryDelay");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 60000L;
    }

    public boolean isAutoDeleteDurableSubscriptions() {
        Object property = this.properties.get("auto-delete-durable-subscription");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return false;
    }

    public long getAutoDeleteDurableSubscriptionMsgCount() {
        Object property = this.properties.get("auto-delete-durable-subscription-message-count");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 0L;
    }

    public long getAutoDeleteDurableSubscriptionDelay() {
        Object property = this.properties.get("auto-delete-durable-subscription-delay");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return 0L;
    }

    public boolean isPreferSharedDurableSubscriptions() {
        Object property = this.properties.get("preferSharedDurableSubscriptions");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return true;
    }

    public boolean isUseModifiedForTransientDeliveryErrors() {
        Object property = this.properties.get("amqpUseModifiedForTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    public boolean isDrainOnTransientDeliveryErrors() {
        Object property = this.properties.get("amqpDrainOnTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.connection.getProtocolManager().isDrainOnTransientDeliveryErrors();
    }

    public int getLinkQuiesceTimeout() {
        Object property = this.properties.get("amqpLinkQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.connection.getProtocolManager().getLinkQuiesceTimeout();
    }
}

