/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;
import org.hibernate.internal.util.NullnessUtil;

public class WildFlyStandAloneJtaPlatform
extends AbstractJtaPlatform {
    public static final @UnknownKeyFor @NonNull @Initialized String WILDFLY_TM_CLASS_NAME = "org.wildfly.transaction.client.ContextTransactionManager";
    public static final @UnknownKeyFor @NonNull @Initialized String WILDFLY_UT_CLASS_NAME = "org.wildfly.transaction.client.LocalUserTransaction";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager() {
        try {
            Class wildflyTmClass = NullnessUtil.castNonNull(this.serviceRegistry().getService(ClassLoaderService.class)).classForName(WILDFLY_TM_CLASS_NAME);
            return (TransactionManager)wildflyTmClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain WildFly Transaction Client transaction manager instance", e);
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction() {
        try {
            Class jbossUtClass = NullnessUtil.castNonNull(this.serviceRegistry().getService(ClassLoaderService.class)).classForName(WILDFLY_UT_CLASS_NAME);
            return (UserTransaction)jbossUtClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain WildFly Transaction Client user transaction instance", e);
        }
    }
}

