/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvRSAPublicKey
implements RSAPublicKey,
ProvKey<AsymmetricRSAPublicKey> {
    static final long serialVersionUID = 2675817738516720772L;
    private transient AsymmetricRSAPublicKey baseKey;

    ProvRSAPublicKey(Algorithm algorithm, RSAPublicKey rSAPublicKey) {
        this.baseKey = new AsymmetricRSAPublicKey(algorithm, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    ProvRSAPublicKey(Algorithm algorithm, RSAPublicKeySpec rSAPublicKeySpec) {
        this.baseKey = new AsymmetricRSAPublicKey(algorithm, rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
    }

    ProvRSAPublicKey(AsymmetricRSAPublicKey asymmetricRSAPublicKey) {
        this.baseKey = asymmetricRSAPublicKey;
    }

    @Override
    public AsymmetricRSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.baseKey.getPublicExponent();
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        if (object instanceof ProvRSAPublicKey) {
            ProvRSAPublicKey provRSAPublicKey = (ProvRSAPublicKey)object;
            return this.baseKey.equals(provRSAPublicKey.baseKey);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
        return Arrays.areEqual(this.getEncoded(), rSAPublicKey.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricRSAPublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("RSA Public Key [").append(KeyUtil.generateFingerPrint(this.getModulus())).append("]").append(",[").append(KeyUtil.generateExponentFingerprint(this.getPublicExponent())).append("]").append(string);
        stringBuilder.append("        modulus: ").append(this.getModulus().toString(16)).append(string);
        stringBuilder.append("public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        return stringBuilder.toString();
    }
}

