/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.bookkeeper.clients.utils.GrpcUtils;

public class RpcUtils {
    public static boolean isContainerNotFound(Throwable cause) {
        if (cause instanceof StatusRuntimeException) {
            return Status.NOT_FOUND == ((StatusRuntimeException)cause).getStatus();
        }
        if (cause instanceof StatusException) {
            return Status.NOT_FOUND == ((StatusException)cause).getStatus();
        }
        return false;
    }

    public static <T, ReqT, RespT, ServiceT> void processRpc(ServiceT service, final CompletableFuture<T> result, CreateRequestFunc<ReqT> createRequestFunc, ProcessRequestFunc<ReqT, RespT, ServiceT> processRequestFunc, final ProcessResponseFunc<RespT, T> processResponseFunc) {
        ReqT request = createRequestFunc.apply();
        ListenableFuture<RespT> resultFuture = processRequestFunc.process(service, request);
        Futures.addCallback(resultFuture, (FutureCallback)new FutureCallback<RespT>(){

            public void onSuccess(RespT resp) {
                processResponseFunc.process(resp, result);
            }

            public void onFailure(Throwable throwable) {
                GrpcUtils.processRpcException(throwable, result);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @FunctionalInterface
    public static interface ProcessResponseFunc<RespT, T> {
        public void process(RespT var1, CompletableFuture<T> var2);
    }

    @FunctionalInterface
    public static interface ProcessRequestFunc<ReqT, RespT, ServiceT> {
        public ListenableFuture<RespT> process(ServiceT var1, ReqT var2);
    }

    @FunctionalInterface
    public static interface CreateRequestFunc<ReqT> {
        public ReqT apply();
    }
}

