/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.zookeeper.common.SecretUtils;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SecretUtilsTest {
    @ParameterizedTest
    @ValueSource(strings={"test secret", ""})
    public void testReadSecret(String secretTxt) throws Exception {
        Path secretFile = SecretUtilsTest.createSecretFile(secretTxt);
        char[] secret = SecretUtils.readSecret((String)secretFile.toString());
        Assertions.assertEquals((Object)secretTxt, (Object)String.valueOf(secret));
    }

    @Test
    public void tesReadSecret_withLineSeparator() throws Exception {
        String secretTxt = "test secret  with line separator" + System.lineSeparator();
        Path secretFile = SecretUtilsTest.createSecretFile(secretTxt);
        char[] secret = SecretUtils.readSecret((String)secretFile.toString());
        Assertions.assertEquals((Object)secretTxt.substring(0, secretTxt.length() - 1), (Object)String.valueOf(secret));
    }

    @Test
    public void testReadSecret_fileNotExist() {
        String pathToFile = "NonExistingFile";
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> SecretUtils.readSecret((String)"NonExistingFile"));
        Assertions.assertEquals((Object)"Exception occurred while reading secret from file NonExistingFile", (Object)exception.getMessage());
    }

    public static Path createSecretFile(String secretTxt) throws IOException {
        Path path = Files.createTempFile("test_", ".secrete", new FileAttribute[0]);
        BufferedWriter writer = new BufferedWriter(new FileWriter(path.toString()));
        writer.append(secretTxt);
        writer.close();
        path.toFile().deleteOnExit();
        return path;
    }
}

