/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.metrics.MetricsContext;
import org.apache.zookeeper.metrics.MetricsProvider;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.util.QuotaMetricsUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuotaMetricsUtilsTest
extends ZKTestCase {
    @Test
    public void testQuotaMetrics_singleQuotaSubtree() throws Exception {
        String nameSuffix = UUID.randomUUID().toString();
        DataTree dt = new DataTree();
        this.registerQuotaMetrics(nameSuffix, dt);
        String ns = UUID.randomUUID().toString();
        long countLimit = 10L;
        long bytesLimit = 100L;
        long countHardLimit = 5L;
        long bytesHardLimit = 50L;
        long countUsage = 5L;
        long bytesUsage = 40L;
        StatsTrack limitTrack = this.buildLimitStatsTrack(10L, 100L, 5L, 50L);
        StatsTrack usageTrack = this.buildUsageStatsTrack(5L, 40L);
        this.buildDataTree("/" + ns, limitTrack, usageTrack, dt);
        this.validateQuotaMetrics(ns, 5L, 50L, 5L, 40L, nameSuffix);
    }

    @Test
    public void testQuotaMetrics_multipleQuotaSubtrees() throws Exception {
        String nameSuffix = UUID.randomUUID().toString();
        DataTree dt = new DataTree();
        this.registerQuotaMetrics(nameSuffix, dt);
        String ns = UUID.randomUUID().toString();
        long countLimit1 = 10L;
        long bytesLimit1 = 100L;
        long countHardLimit1 = 5L;
        long bytesHardLimit1 = 50L;
        long countUsage1 = 5L;
        long bytesUsage1 = 40L;
        StatsTrack limitTrack1 = this.buildLimitStatsTrack(10L, 100L, 5L, 50L);
        StatsTrack usageTrack1 = this.buildUsageStatsTrack(5L, 40L);
        this.buildDataTree("/" + ns + "/a/b", limitTrack1, usageTrack1, dt);
        this.validateQuotaMetrics(ns, 5L, 50L, 5L, 40L, nameSuffix);
        long countLimit2 = 20L;
        long bytesLimit2 = 200L;
        long countHardLimit2 = 10L;
        long bytesHardLimit2 = 100L;
        long countUsage2 = 9L;
        long bytesUsage2 = 80L;
        StatsTrack limitTrack2 = this.buildLimitStatsTrack(20L, 200L, 10L, 100L);
        StatsTrack usageTrack2 = this.buildUsageStatsTrack(9L, 80L);
        this.buildDataTree("/" + ns + "/a/c/d", limitTrack2, usageTrack2, dt);
        this.validateQuotaMetrics(ns, 15L, 150L, 14L, 120L, nameSuffix);
    }

    @Test
    public void testQuotaMetrics_noUsage() throws Exception {
        String nameSuffix = UUID.randomUUID().toString();
        DataTree dt = new DataTree();
        this.registerQuotaMetrics(nameSuffix, dt);
        String ns = UUID.randomUUID().toString();
        long countLimit = 20L;
        long bytesLimit = 200L;
        long countHardLimit = -1L;
        long bytesHardLimit = -1L;
        long countUsage = 1L;
        long bytesUsage = 0L;
        StatsTrack limitTrack = this.buildLimitStatsTrack(20L, 200L, -1L, -1L);
        StatsTrack usageTrack = this.buildUsageStatsTrack(1L, 0L);
        this.buildDataTree("/" + ns, limitTrack, usageTrack, dt);
        this.validateQuotaMetrics(ns, 20L, 200L, 1L, 0L, nameSuffix);
    }

    @Test
    public void testQuotaMetrics_nullDataTree() {
        String nameSuffix = UUID.randomUUID().toString();
        this.registerQuotaMetrics(nameSuffix, null);
        this.validateQuotaMetrics(UUID.randomUUID().toString(), null, null, null, null, nameSuffix);
    }

    @Test
    public void testQuotaMetrics_emptyDataTree() {
        String nameSuffix = UUID.randomUUID().toString();
        this.registerQuotaMetrics(nameSuffix, new DataTree());
        this.validateQuotaMetrics(UUID.randomUUID().toString(), null, null, null, null, nameSuffix);
    }

    @Test
    public void testShouldCollect_limitPath() {
        String limitPath = Quotas.quotaPath((String)"/ns1") + "/zookeeper_limits";
        Assertions.assertTrue((boolean)QuotaMetricsUtils.shouldCollect((String)limitPath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT));
        Assertions.assertTrue((boolean)QuotaMetricsUtils.shouldCollect((String)limitPath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)limitPath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)limitPath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE));
    }

    @Test
    public void testShouldCollect_usagePath() {
        String usagePath = Quotas.quotaPath((String)"/ns1") + "/zookeeper_stats";
        Assertions.assertTrue((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE));
        Assertions.assertTrue((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT));
    }

    @Test
    public void testShouldCollect_notLimitOrUsagePath() {
        String usagePath = Quotas.quotaPath((String)"/ns1") + "/notLimitOrUsage";
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT));
        Assertions.assertFalse((boolean)QuotaMetricsUtils.shouldCollect((String)usagePath, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT));
    }

    @Test
    public void testGetQuotaLimit() {
        Assertions.assertEquals((long)0L, (long)QuotaMetricsUtils.getQuotaLimit((long)0L, (long)-1L));
        Assertions.assertEquals((long)1L, (long)QuotaMetricsUtils.getQuotaLimit((long)-1L, (long)1L));
        Assertions.assertEquals((long)0L, (long)QuotaMetricsUtils.getQuotaLimit((long)-2L, (long)0L));
    }

    @Test
    public void testCollectQuotaMetrics_noData() {
        HashMap metricsMap = new HashMap();
        QuotaMetricsUtils.collectQuotaLimitOrUsage((String)(Quotas.quotaPath((String)"/ns1") + "/zookeeper_limits"), (DataNode)new DataNode(new byte[0], null, null), metricsMap, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT);
        Assertions.assertEquals((int)1, (int)metricsMap.size());
        Map.Entry entry = metricsMap.entrySet().iterator().next();
        Assertions.assertEquals((Object)"ns1", entry.getKey());
        Assertions.assertEquals((long)-1L, (long)((Number)entry.getValue()).longValue());
    }

    @Test
    public void testCollectQuotaMetrics_nullData() {
        HashMap metricsMap = new HashMap();
        QuotaMetricsUtils.collectQuotaLimitOrUsage((String)(Quotas.quotaPath((String)"/ns1") + "/zookeeper_limits"), (DataNode)new DataNode(null, null, null), metricsMap, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT);
        Assertions.assertEquals((int)0, (int)metricsMap.size());
    }

    @Test
    public void testCollectQuotaMetrics_noNamespace() {
        HashMap metricsMap = new HashMap();
        QuotaMetricsUtils.collectQuotaLimitOrUsage((String)"/zookeeper/quota", (DataNode)new DataNode(null, null, null), metricsMap, (QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE)QuotaMetricsUtils.QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE);
        Assertions.assertEquals((int)0, (int)metricsMap.size());
    }

    private void registerQuotaMetrics(String nameSuffix, DataTree dt) {
        MetricsProvider metricProvider = ServerMetrics.getMetrics().getMetricsProvider();
        MetricsContext rootContext = metricProvider.getRootContext();
        rootContext.registerGaugeSet("quota_count_limit_per_namespace" + nameSuffix, () -> QuotaMetricsUtils.getQuotaCountLimit((DataTree)dt));
        rootContext.registerGaugeSet("quota_bytes_limit_per_namespace" + nameSuffix, () -> QuotaMetricsUtils.getQuotaBytesLimit((DataTree)dt));
        rootContext.registerGaugeSet("quota_count_usage_per_namespace" + nameSuffix, () -> QuotaMetricsUtils.getQuotaCountUsage((DataTree)dt));
        rootContext.registerGaugeSet("quota_bytes_usage_per_namespace" + nameSuffix, () -> QuotaMetricsUtils.getQuotaBytesUsage((DataTree)dt));
    }

    private StatsTrack buildLimitStatsTrack(long countLimit, long bytesLimit, long countHardLimit, long bytesHardLimit) {
        StatsTrack limitTrack = new StatsTrack();
        limitTrack.setCount(countLimit);
        limitTrack.setBytes(bytesLimit);
        limitTrack.setCountHardLimit(countHardLimit);
        limitTrack.setByteHardLimit(bytesHardLimit);
        return limitTrack;
    }

    private StatsTrack buildUsageStatsTrack(long countUsage, long bytesUsage) {
        StatsTrack usageTrack = new StatsTrack();
        usageTrack.setCount(countUsage);
        usageTrack.setBytes(bytesUsage);
        return usageTrack;
    }

    private void buildDataTree(String path, StatsTrack limitTrack, StatsTrack usageTrack, DataTree dataTree) throws Exception {
        this.buildAncestors(path, dataTree);
        int childCount = (int)usageTrack.getCount() - 1;
        if (childCount > 0) {
            int dataBytes = (int)usageTrack.getBytes() / childCount;
            for (int i = 0; i < childCount; ++i) {
                dataTree.createNode(path + "/n_" + i, new byte[dataBytes], null, -1L, 1, 1L, 1L);
            }
        }
        this.buildAncestors(Quotas.quotaPath((String)path), dataTree);
        String limitPath = Quotas.limitPath((String)path);
        dataTree.createNode(limitPath, limitTrack.getStatsBytes(), null, -1L, 1, 1L, 1L);
        Assertions.assertEquals((Object)limitTrack, (Object)new StatsTrack(dataTree.getNode(limitPath).getData()));
        String usagePath = Quotas.statPath((String)path);
        dataTree.createNode(usagePath, usageTrack.getStatsBytes(), null, -1L, 1, 1L, 1L);
        Assertions.assertEquals((Object)usageTrack, (Object)new StatsTrack(dataTree.getNode(usagePath).getData()));
    }

    private void buildAncestors(String path, DataTree dataTree) throws Exception {
        String[] parts = path.split("/");
        String nodePath = "";
        for (int i = 1; i < parts.length; ++i) {
            nodePath = nodePath + "/" + parts[i];
            try {
                dataTree.createNode(nodePath, null, null, -1L, 1, 1L, 1L);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    private void validateQuotaMetrics(String namespace, Long countLimit, Long bytesLimit, Long countUsage, Long bytesUsage, String nameSuffix) {
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)countLimit, (Object)values.get(namespace + "_" + "quota_count_limit_per_namespace" + nameSuffix));
        Assertions.assertEquals((Object)bytesLimit, (Object)values.get(namespace + "_" + "quota_bytes_limit_per_namespace" + nameSuffix));
        Assertions.assertEquals((Object)countUsage, (Object)values.get(namespace + "_" + "quota_count_usage_per_namespace" + nameSuffix));
        Assertions.assertEquals((Object)bytesUsage, (Object)values.get(namespace + "_" + "quota_bytes_usage_per_namespace" + nameSuffix));
    }
}

