/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.ZKNamespaceWatcher;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestZKNamespaceWatcher
extends TestDistributedLogBase {
    private static final int zkSessionTimeoutMs = 2000;
    @Rule
    public TestName runtime = new TestName();
    protected final DistributedLogConfiguration baseConf = new DistributedLogConfiguration();
    protected ZooKeeperClient zkc;
    protected OrderedScheduler scheduler;

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createDLMURI("/")).sessionTimeoutMs(2000).build();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-zk-namespace-watcher").numThreads(1).build();
    }

    @Override
    @After
    public void teardown() throws Exception {
        if (null != this.zkc) {
            this.zkc.close();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    private void createLogInNamespace(URI uri, String logName) throws Exception {
        String logPath = uri.getPath() + "/" + logName;
        Utils.zkCreateFullPathOptimistic((ZooKeeperClient)this.zkc, (String)logPath, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
    }

    private void deleteLogInNamespace(URI uri, String logName) throws Exception {
        String logPath = uri.getPath() + "/" + logName;
        this.zkc.get().delete(logPath, -1);
    }

    @Test(timeout=60000L)
    public void testNamespaceListener() throws Exception {
        URI uri = this.createDLMURI("/" + this.runtime.getMethodName());
        this.zkc.get().create(uri.getPath(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration((Configuration)this.baseConf);
        ZKNamespaceWatcher watcher = new ZKNamespaceWatcher(conf, uri, this.zkc, this.scheduler);
        final CountDownLatch[] latches = new CountDownLatch[10];
        for (int i = 0; i < 10; ++i) {
            latches[i] = new CountDownLatch(1);
        }
        final AtomicInteger numUpdates = new AtomicInteger(0);
        final AtomicReference<Object> receivedLogs = new AtomicReference<Object>(null);
        watcher.registerListener(new NamespaceListener(){

            public void onStreamsChanged(Iterator<String> streams) {
                HashSet streamSet = Sets.newHashSet(streams);
                int updates = numUpdates.incrementAndGet();
                receivedLogs.set(streamSet);
                latches[updates - 1].countDown();
            }
        });
        HashSet expectedLogs = Sets.newHashSet();
        latches[0].await();
        this.validateReceivedLogs(expectedLogs, receivedLogs.get());
        expectedLogs.add("test1");
        this.createLogInNamespace(uri, "test1");
        latches[1].await();
        this.validateReceivedLogs(expectedLogs, receivedLogs.get());
        this.createLogInNamespace(uri, ".test1");
        latches[2].await();
        this.validateReceivedLogs(expectedLogs, receivedLogs.get());
        expectedLogs.add("test2");
        this.createLogInNamespace(uri, "test2");
        latches[3].await();
        this.validateReceivedLogs(expectedLogs, receivedLogs.get());
        expectedLogs.remove("test1");
        this.deleteLogInNamespace(uri, "test1");
        latches[4].await();
        this.validateReceivedLogs(expectedLogs, receivedLogs.get());
    }

    private void validateReceivedLogs(Set<String> expectedLogs, Set<String> receivedLogs) {
        Assert.assertTrue((boolean)Sets.difference(expectedLogs, receivedLogs).isEmpty());
    }

    @Test(timeout=60000L)
    public void testSessionExpired() throws Exception {
        URI uri = this.createDLMURI("/" + this.runtime.getMethodName());
        this.zkc.get().create(uri.getPath(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration((Configuration)this.baseConf);
        ZKNamespaceWatcher watcher = new ZKNamespaceWatcher(conf, uri, this.zkc, this.scheduler);
        final CountDownLatch[] latches = new CountDownLatch[10];
        for (int i = 0; i < 10; ++i) {
            latches[i] = new CountDownLatch(1);
        }
        final AtomicInteger numUpdates = new AtomicInteger(0);
        final AtomicReference<Object> receivedLogs = new AtomicReference<Object>(null);
        watcher.registerListener(new NamespaceListener(){

            public void onStreamsChanged(Iterator<String> streams) {
                HashSet streamSet = Sets.newHashSet(streams);
                int updates = numUpdates.incrementAndGet();
                receivedLogs.set(streamSet);
                latches[updates - 1].countDown();
            }
        });
        latches[0].await();
        this.createLogInNamespace(uri, "test1");
        latches[1].await();
        this.createLogInNamespace(uri, "test2");
        latches[2].await();
        Assert.assertEquals((long)2L, (long)((Set)receivedLogs.get()).size());
        ZooKeeperClientUtils.expireSession(this.zkc, BKNamespaceDriver.getZKServersFromDLUri((URI)uri), 2000);
        latches[3].await();
        Assert.assertEquals((long)2L, (long)((Set)receivedLogs.get()).size());
        this.createLogInNamespace(uri, "test3");
        latches[4].await();
        Assert.assertEquals((long)3L, (long)((Set)receivedLogs.get()).size());
    }
}

