/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package applyconfiguration

import (
	v1 "github.com/apache/camel-kamelets/crds/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-kamelets/crds/pkg/client/camel/applyconfiguration/camel/v1"
	internal "github.com/apache/camel-kamelets/crds/pkg/client/camel/applyconfiguration/internal"
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	testing "k8s.io/client-go/testing"
)

// ForKind returns an apply configuration type for the given GroupVersionKind, or nil if no
// apply configuration type exists for the given GroupVersionKind.
func ForKind(kind schema.GroupVersionKind) interface{} {
	switch kind {
	// Group=camel.apache.org, Version=v1
	case v1.SchemeGroupVersion.WithKind("DataSpec"):
		return &camelv1.DataSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("DataTypeSpec"):
		return &camelv1.DataTypeSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("DataTypesSpec"):
		return &camelv1.DataTypesSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("EventTypeSpec"):
		return &camelv1.EventTypeSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("ExternalDocumentation"):
		return &camelv1.ExternalDocumentationApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("HeaderSpec"):
		return &camelv1.HeaderSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("JSON"):
		return &camelv1.JSONApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("JSONSchemaProp"):
		return &camelv1.JSONSchemaPropApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("JSONSchemaProps"):
		return &camelv1.JSONSchemaPropsApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("Kamelet"):
		return &camelv1.KameletApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("KameletCondition"):
		return &camelv1.KameletConditionApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("KameletProperty"):
		return &camelv1.KameletPropertyApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("KameletSpec"):
		return &camelv1.KameletSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("KameletSpecBase"):
		return &camelv1.KameletSpecBaseApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("KameletStatus"):
		return &camelv1.KameletStatusApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("SourceSpec"):
		return &camelv1.SourceSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("Template"):
		return &camelv1.TemplateApplyConfiguration{}

	}
	return nil
}

func NewTypeConverter(scheme *runtime.Scheme) *testing.TypeConverter {
	return &testing.TypeConverter{Scheme: scheme, TypeResolver: internal.Parser()}
}
