/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import org.apache.cassandra.db.AbstractArrayClusteringPrefix;
import org.apache.cassandra.db.ArrayClustering;
import org.apache.cassandra.db.ArrayClusteringBound;
import org.apache.cassandra.db.ArrayClusteringBoundary;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.ArrayCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

class ByteArrayObjectFactory
implements ValueAccessor.ObjectFactory<byte[]> {
    private static final Clustering<byte[]> EMPTY_CLUSTERING = new ArrayClustering(AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY){

        @Override
        public String toString(TableMetadata metadata) {
            return "EMPTY";
        }
    };
    public static final Clustering<byte[]> STATIC_CLUSTERING = new ArrayClustering(AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY){

        @Override
        public ClusteringPrefix.Kind kind() {
            return ClusteringPrefix.Kind.STATIC_CLUSTERING;
        }

        public String toString() {
            return "STATIC";
        }

        @Override
        public String toString(TableMetadata metadata) {
            return this.toString();
        }
    };
    static final ValueAccessor.ObjectFactory<byte[]> instance = new ByteArrayObjectFactory();
    private static final ArrayClusteringBound BOTTOM_BOUND = new ArrayClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY);
    private static final ArrayClusteringBound TOP_BOUND = new ArrayClusteringBound(ClusteringPrefix.Kind.INCL_END_BOUND, AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY);
    private static final ArrayClusteringBound MAX_START_BOUND = new ArrayClusteringBound(ClusteringPrefix.Kind.EXCL_START_BOUND, AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY);
    private static final ArrayClusteringBound MIN_END_BOUND = new ArrayClusteringBound(ClusteringPrefix.Kind.EXCL_END_BOUND, AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY);

    private ByteArrayObjectFactory() {
    }

    @Override
    public Cell<byte[]> cell(ColumnMetadata column, long timestamp, int ttl, long localDeletionTime, byte[] value, CellPath path) {
        return new ArrayCell(column, timestamp, ttl, localDeletionTime, value, path);
    }

    public Clustering<byte[]> clustering(byte[] ... values) {
        return new ArrayClustering(values);
    }

    @Override
    public Clustering<byte[]> clustering() {
        return EMPTY_CLUSTERING;
    }

    @Override
    public Clustering<byte[]> staticClustering() {
        return STATIC_CLUSTERING;
    }

    public ClusteringBound<byte[]> bound(ClusteringPrefix.Kind kind, byte[] ... values) {
        return new ArrayClusteringBound(kind, values);
    }

    @Override
    public ClusteringBound<byte[]> bound(ClusteringPrefix.Kind kind) {
        switch (kind) {
            case EXCL_END_BOUND: {
                return MIN_END_BOUND;
            }
            case INCL_START_BOUND: {
                return BOTTOM_BOUND;
            }
            case INCL_END_BOUND: {
                return TOP_BOUND;
            }
            case EXCL_START_BOUND: {
                return MAX_START_BOUND;
            }
        }
        throw new AssertionError((Object)String.format("Unexpected kind %s for empty bound or boundary", new Object[]{kind}));
    }

    public ClusteringBoundary<byte[]> boundary(ClusteringPrefix.Kind kind, byte[] ... values) {
        return new ArrayClusteringBoundary(kind, values);
    }
}

