/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public class TriePathReconstructor
implements Trie.ResettingTransitionsReceiver {
    protected byte[] keyBytes = new byte[32];
    protected int keyPos = 0;

    @Override
    public void addPathByte(int nextByte) {
        if (this.keyPos >= this.keyBytes.length) {
            this.keyBytes = Arrays.copyOf(this.keyBytes, this.keyPos * 2);
        }
        this.keyBytes[this.keyPos++] = (byte)nextByte;
    }

    @Override
    public void addPathBytes(DirectBuffer buffer, int pos, int count) {
        int newPos = this.keyPos + count;
        if (newPos > this.keyBytes.length) {
            this.keyBytes = Arrays.copyOf(this.keyBytes, Math.max(newPos + 16, this.keyBytes.length * 2));
        }
        buffer.getBytes(pos, this.keyBytes, this.keyPos, count);
        this.keyPos = newPos;
    }

    @Override
    public void resetPathLength(int newLength) {
        this.keyPos = newLength;
    }

    static ByteComparable toByteComparable(byte[] bytes, int byteLength) {
        return ByteComparable.fixedLength(Arrays.copyOf(bytes, byteLength));
    }
}

