/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.v1;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.CountDownLatch;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaxosCallback<T>
implements RequestCallback<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPaxosCallback.class);
    protected final CountDownLatch latch;
    protected final int targets;
    private final ConsistencyLevel consistency;
    private final Dispatcher.RequestTime requestTime;

    public AbstractPaxosCallback(int targets, ConsistencyLevel consistency, Dispatcher.RequestTime requestTime) {
        this.targets = targets;
        this.consistency = consistency;
        this.latch = CountDownLatch.newCountDownLatch(targets);
        this.requestTime = requestTime;
    }

    public int getResponseCount() {
        return this.targets - this.latch.count();
    }

    public void await() throws WriteTimeoutException {
        try {
            long now = Clock.Global.nanoTime();
            long timeout = this.requestTime.computeTimeout(now, DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS));
            if (!this.latch.await(timeout, TimeUnit.NANOSECONDS)) {
                throw new WriteTimeoutException(WriteType.CAS, this.consistency, this.getResponseCount(), this.targets);
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        logger.debug("Received paxos propose/prepare failure response from {} reason {}", (Object)from, (Object)failureReason);
    }

    @Override
    public boolean invokeOnFailure() {
        return true;
    }
}

