/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="forcecompact", description="Force a (major) compaction on a table")
public class ForceCompact
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <table> <keys>]", description="The keyspace, table, and a list of partition keys ignoring the gc_grace_seconds")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() >= 3 ? 1 : 0) != 0, (Object)"forcecompact requires keyspace, table and keys args");
        String keyspaceName = this.args.get(0);
        String tableName = this.args.get(1);
        String[] partitionKeysIgnoreGcGrace = this.parsePartitionKeys(this.args);
        try {
            probe.forceCompactionKeysIgnoringGcGrace(keyspaceName, tableName, partitionKeysIgnoreGcGrace);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred during compaction keys", e);
        }
    }
}

