/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import com.datastax.driver.core.ResultSet;
import com.vdurmont.semver4j.Semver;
import io.vertx.junit5.VertxExtension;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.SparkTestUtils;
import org.apache.cassandra.analytics.SparkTestUtilsProvider;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.sidecar.testing.SharedClusterIntegrationTestBase;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={VertxExtension.class})
public abstract class SharedClusterSparkIntegrationTestBase
extends SharedClusterIntegrationTestBase {
    protected SparkConf sparkConf;
    protected SparkSession sparkSession;
    protected SparkTestUtils sparkTestUtils = SparkTestUtilsProvider.utils();
    protected CassandraBridge bridge;

    protected void beforeTestStart() {
        super.beforeTestStart();
        this.sparkTestUtils.initialize((ICluster<? extends IInstance>)this.cluster.delegate(), this.dnsResolver, this.server.actualPort(), this.mtlsTestHelper);
    }

    protected void afterClusterShutdown() {
        super.afterClusterShutdown();
        this.sparkTestUtils.tearDown();
    }

    protected DataFrameReader bulkReaderDataFrame(QualifiedName tableName) {
        return this.sparkTestUtils.defaultBulkReaderDataFrame(this.getOrCreateSparkConf(), this.getOrCreateSparkSession(), tableName, Collections.emptyMap());
    }

    protected DataFrameReader bulkReaderDataFrame(QualifiedName tableName, java.util.Map<String, String> additionalOptions) {
        return this.sparkTestUtils.defaultBulkReaderDataFrame(this.getOrCreateSparkConf(), this.getOrCreateSparkSession(), tableName, additionalOptions);
    }

    protected DataFrameWriter<Row> bulkWriterDataFrameWriter(Dataset<Row> df, QualifiedName tableName) {
        return this.sparkTestUtils.defaultBulkWriterDataFrameWriter(df, tableName, Collections.emptyMap());
    }

    protected DataFrameWriter<Row> bulkWriterDataFrameWriter(Dataset<Row> df, QualifiedName tableName, java.util.Map<String, String> additionalOptions) {
        return this.sparkTestUtils.defaultBulkWriterDataFrameWriter(df, tableName, additionalOptions);
    }

    protected SparkConf getOrCreateSparkConf() {
        if (this.sparkConf == null) {
            this.sparkConf = this.sparkTestUtils.defaultSparkConf();
        }
        return this.sparkConf;
    }

    protected SparkSession getOrCreateSparkSession() {
        if (this.sparkSession == null) {
            this.sparkSession = SparkSession.builder().config(this.getOrCreateSparkConf()).getOrCreate();
        }
        return this.sparkSession;
    }

    protected CassandraBridge getOrCreateBridge() {
        if (this.bridge == null) {
            Semver semVer = new Semver(this.testVersion.version(), Semver.SemverType.LOOSE);
            this.bridge = CassandraBridgeFactory.get((String)semVer.toStrict().toString());
        }
        return this.bridge;
    }

    public void checkSmallDataFrameEquality(Dataset<Row> expected, Dataset<Row> actual) {
        if (actual == null) {
            throw new NullPointerException("actual dataframe is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected dataframe is null");
        }
        if (!actual.exceptAll(expected).isEmpty() || !expected.exceptAll(actual).isEmpty()) {
            throw new IllegalStateException("The content of the dataframes differs");
        }
    }

    public void validateWritesWithDriverResultSet(List<Row> sparkData, ResultSet driverData, Function<com.datastax.driver.core.Row, String> driverRowFormatter) {
        HashSet driverEntries = new HashSet();
        driverData.forEach(row -> driverEntries.add(((String)driverRowFormatter.apply((com.datastax.driver.core.Row)row)).replace("NULL", "null")));
        Assertions.assertThat((int)driverEntries.size()).isEqualTo(sparkData.size());
        Set sparkEntries = sparkData.stream().map(this::formattedSparkRow).collect(Collectors.toSet());
        ((AbstractCollectionAssert)Assertions.assertThat(driverEntries).as("All entries are expected to be read from database", new Object[0])).containsExactlyInAnyOrderElementsOf(sparkEntries);
    }

    private String formattedSparkRow(Row row) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            this.maybeFormatSparkCompositeType(sb, row.get(i));
            if (i == row.size() - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    protected void maybeFormatSparkCompositeType(StringBuilder sb, Object o) {
        if (o instanceof Row) {
            Row r = (Row)o;
            sb.append("{");
            StructField[] fields = r.schema().fields();
            for (int i = 0; i < r.size(); ++i) {
                sb.append(this.maybeQuoteFieldName(fields[i]));
                sb.append(":");
                this.maybeFormatSparkCompositeType(sb, r.get(i));
                if (i == r.size() - 1) continue;
                sb.append(',');
            }
            sb.append("}");
        } else if (o instanceof Seq) {
            List entries = (List)JavaConverters.seqAsJavaListConverter((Seq)((Seq)o)).asJava();
            sb.append("{");
            for (int i = 0; i < entries.size(); ++i) {
                this.maybeFormatSparkCompositeType(sb, entries.get(i));
                if (i == entries.size() - 1) continue;
                sb.append(',');
            }
            sb.append("}");
        } else if (o instanceof Map) {
            java.util.Map map = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((Map)o)).asJava();
            for (Map.Entry entry : map.entrySet()) {
                sb.append("{");
                this.maybeFormatSparkCompositeType(sb, entry.getKey());
                sb.append(":");
                this.maybeFormatSparkCompositeType(sb, entry.getValue());
                sb.append("}");
            }
        } else if (o instanceof String) {
            sb.append(String.format("'%s'", o));
        } else {
            sb.append(String.format("%s", o));
        }
    }

    protected String maybeQuoteFieldName(StructField fields) {
        return this.getOrCreateBridge().maybeQuoteIdentifier(fields.name());
    }
}

