/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.correctness;

import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.jpountz.lz4.LZ4Exception;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BulkWriteCorruptionTest
extends SharedClusterSparkIntegrationTestBase {
    private static final QualifiedName QUALIFIED_NAME = new QualifiedName("spark_test", "test_write_corruption");

    @Test
    void testDiskCorruption() {
        Exception failure = this.bulkWriteWithCorruption(CorruptionMode.DISK);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)failure).isExactlyInstanceOf(RuntimeException.class)).hasMessageContaining("Bulk Write to Cassandra has failed").rootCause().isExactlyInstanceOf(LZ4Exception.class)).hasMessageContaining("Malformed input");
    }

    @Test
    void testDataTransferCorruption() {
        Exception failure = this.bulkWriteWithCorruption(CorruptionMode.WIRE);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)failure).isExactlyInstanceOf(RuntimeException.class)).hasMessageContaining("Bulk Write to Cassandra has failed").rootCause().isExactlyInstanceOf(ConsistencyNotSatisfiedException.class)).hasMessageContaining("Cause=o.a.c.sidecar.client.shaded.client.exception.RetriesExhaustedException").hasMessageContaining("after 5 attempts").hasMessageContaining("HttpResponseImpl{statusCode=455, statusMessage='Client Error (455)', contentAsString='{\"status\":\"Client Error (455)\",\"code\":455,\"message\":\"Digest mismatch.");
    }

    @Test
    void testDataTransferPassAfterOneFailedTask() {
        Dataset<Row> dfWrite = this.startBulkWrite(CorruptionMode.WIRE, 1);
        this.sparkTestUtils.validateWrites(dfWrite.collectAsList(), this.queryAllData(QUALIFIED_NAME));
    }

    private Exception bulkWriteWithCorruption(CorruptionMode corruptionMode) {
        try {
            this.startBulkWrite(corruptionMode, Integer.MAX_VALUE);
        }
        catch (Exception ex) {
            return ex;
        }
        throw new IllegalStateException("Bulk write should fail");
    }

    private Dataset<Row> startBulkWrite(CorruptionMode corruptionMode, int failedAttempts) {
        BBHelperForFileCorruption.corruptionMode = corruptionMode;
        BBHelperForFileCorruption.failedDataTransferAttempts.set(failedAttempts);
        HashMap<String, String> writerOptions = new HashMap<String, String>();
        writerOptions.put("bulk_writer_cl", "ALL");
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> dfWrite = DataGenerationUtils.generateCourseData(spark, 1000);
        this.bulkWriterDataFrameWriter(dfWrite, QUALIFIED_NAME, writerOptions).save();
        return dfWrite;
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF1);
        this.createTestTable(QUALIFIED_NAME, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(1);
    }

    static {
        BBHelperForFileCorruption.install();
    }

    public static class BBHelperForFileCorruption {
        static CorruptionMode corruptionMode = CorruptionMode.DISK;
        static AtomicInteger failedDataTransferAttempts = new AtomicInteger(Integer.MAX_VALUE);

        public static void install() {
            TypePool typePool = TypePool.Default.ofSystemLoader();
            new ByteBuddy().rebase(typePool.describe("org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter").resolve(), ClassFileLocator.ForClassLoader.ofSystemLoader()).method((ElementMatcher)ElementMatchers.named((String)"validateSSTables").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{BulkWriterContext.class, Path.class, Set.class}))).intercept((Implementation)MethodDelegation.to(BBHelperForFileCorruption.class)).make().load(BBHelperForFileCorruption.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            new ByteBuddy().rebase(typePool.describe("org.apache.cassandra.spark.bulkwriter.SidecarDataTransferApi").resolve(), ClassFileLocator.ForClassLoader.ofSystemLoader()).method((ElementMatcher)ElementMatchers.named((String)"uploadSSTableComponent")).intercept((Implementation)MethodDelegation.to(BBHelperForFileCorruption.class)).make().load(BBHelperForFileCorruption.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
        }

        public static void validateSSTables(BulkWriterContext context, Path outputDirectory, Set<Path> dataFilePaths, @SuperCall Callable<?> orig) throws Exception {
            if (corruptionMode == CorruptionMode.DISK) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(outputDirectory, "*Data.db");){
                    Path dataFile = stream.iterator().next();
                    try (RandomAccessFile file = new RandomAccessFile(dataFile.toFile(), "rw");){
                        file.seek(file.length() / 2L);
                        file.writeChars("THIS IS CORRUPT DATA AND SHOULD NOT BE READABLE");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            orig.call();
        }

        public static void uploadSSTableComponent(Path componentFile, int ssTableIdx, CassandraInstance instance, String sessionID, Digest digest, @SuperCall Callable<?> orig) throws Exception {
            if (corruptionMode == CorruptionMode.WIRE && failedDataTransferAttempts.getAndDecrement() > 0) {
                try (RandomAccessFile file = new RandomAccessFile(componentFile.toFile(), "rw");){
                    file.seek(file.length() / 2L);
                    file.writeChars("THIS IS CORRUPT DATA AND SHOULD FAIL DIGEST VALIDATION");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            orig.call();
        }
    }

    static enum CorruptionMode {
        DISK,
        WIRE;

    }
}

