/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client.retry;

import o.a.c.sidecar.client.shaded.client.retry.BasicRetryPolicy;

public class ExponentialBackoffRetryPolicy
extends BasicRetryPolicy {
    private final long maxRetryDelayMillis;
    private final long maxAttemptsBeforeOverflow;

    public ExponentialBackoffRetryPolicy() {
        this.maxRetryDelayMillis = 0L;
        this.maxAttemptsBeforeOverflow = this.computeMaxAttemptsBeforeOverflow();
    }

    public ExponentialBackoffRetryPolicy(int maxRetries, long retryDelayMillis, long maxRetryDelayMillis) {
        super(maxRetries, retryDelayMillis);
        this.maxRetryDelayMillis = maxRetryDelayMillis;
        this.maxAttemptsBeforeOverflow = this.computeMaxAttemptsBeforeOverflow();
    }

    @Override
    protected long retryDelayMillis(int attempts) {
        long retryDelay = (long)attempts >= this.maxAttemptsBeforeOverflow ? Long.MAX_VALUE : (long)Math.pow(2.0, attempts - 1) * this.retryDelayMillis;
        if (this.maxRetryDelayMillis > 0L) {
            return Math.min(this.maxRetryDelayMillis, retryDelay);
        }
        return retryDelay;
    }

    private long computeMaxAttemptsBeforeOverflow() {
        return 1L + (long)(Math.log(9.223372036854776E18 / (double)this.retryDelayMillis) / Math.log(2.0));
    }
}

