/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.lang.reflect.Method;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Transient;
import jnr.posix.POSIX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Native {
    private static final Logger LOGGER = LoggerFactory.getLogger(Native.class);

    public static boolean isGettimeofdayAvailable() {
        try {
            return LibCLoader.GETTIMEOFDAY_AVAILABLE;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static boolean isGetpidAvailable() {
        try {
            return PosixLoader.GETPID_AVAILABLE;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static long currentTimeMicros() {
        if (!Native.isGettimeofdayAvailable()) {
            throw new UnsupportedOperationException("JNR C library not loaded or gettimeofday not available");
        }
        LibCLoader.Timeval tv = new LibCLoader.Timeval(LibCLoader.LIB_C_RUNTIME);
        int res = LibCLoader.LIB_C.gettimeofday(tv, null);
        if (res != 0) {
            throw new IllegalStateException("Call to gettimeofday failed with result " + res);
        }
        return tv.tv_sec.get() * 1000000L + tv.tv_usec.get();
    }

    public static int processId() {
        if (!Native.isGetpidAvailable()) {
            throw new UnsupportedOperationException("JNR POSIX library not loaded or getpid not available");
        }
        return PosixLoader.POSIX.getpid();
    }

    private static class PosixLoader {
        public static final POSIX POSIX;
        private static final boolean GETPID_AVAILABLE;

        private PosixLoader() {
        }

        static {
            POSIX posix;
            try {
                Class<?> posixHandler = Class.forName("jnr.posix.POSIXHandler");
                Class<?> defaultPosixHandler = Class.forName("jnr.posix.util.DefaultPOSIXHandler");
                Class<?> posixFactory = Class.forName("jnr.posix.POSIXFactory");
                Method getPOSIX = posixFactory.getMethod("getPOSIX", posixHandler, Boolean.TYPE);
                posix = (POSIX)getPOSIX.invoke(null, defaultPosixHandler.newInstance(), true);
            }
            catch (Throwable t2) {
                posix = null;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not load JNR POSIX Library, native system calls through this library will not be available.", t2);
                }
                LOGGER.info("Could not load JNR POSIX Library, native system calls through this library will not be available (set this logger level to DEBUG to see the full stack trace).");
            }
            POSIX = posix;
            boolean getpid = false;
            if (POSIX != null) {
                try {
                    POSIX.getpid();
                    getpid = true;
                }
                catch (Throwable t3) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Native calls to getpid() not available on this system.", t3);
                    }
                    LOGGER.info("Native calls to getpid() not available on this system (set this logger level to DEBUG to see the full stack trace).");
                }
            }
            GETPID_AVAILABLE = getpid;
        }
    }

    private static class LibCLoader {
        private static final LibC LIB_C;
        private static final Runtime LIB_C_RUNTIME;
        private static final boolean GETTIMEOFDAY_AVAILABLE;

        private LibCLoader() {
        }

        static {
            LibC libc;
            Runtime runtime = null;
            try {
                libc = LibraryLoader.create(LibC.class).load("c");
                runtime = Runtime.getRuntime(libc);
            }
            catch (Throwable t2) {
                libc = null;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not load JNR C Library, native system calls through this library will not be available", t2);
                }
                LOGGER.info("Could not load JNR C Library, native system calls through this library will not be available (set this logger level to DEBUG to see the full stack trace).");
            }
            LIB_C = libc;
            LIB_C_RUNTIME = runtime;
            boolean gettimeofday = false;
            if (LIB_C_RUNTIME != null) {
                try {
                    gettimeofday = LIB_C.gettimeofday(new Timeval(LIB_C_RUNTIME), null) == 0;
                }
                catch (Throwable t3) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Native calls to gettimeofday() not available on this system.", t3);
                    }
                    LOGGER.info("Native calls to gettimeofday() not available on this system (set this logger level to DEBUG to see the full stack trace).");
                }
            }
            GETTIMEOFDAY_AVAILABLE = gettimeofday;
        }

        public static interface LibC {
            public int gettimeofday(@Out @Transient Timeval var1, Pointer var2);
        }

        static class Timeval
        extends Struct {
            public final Struct.time_t tv_sec = new Struct.time_t(this);
            public final Struct.Unsigned32 tv_usec = new Struct.Unsigned32(this);

            public Timeval(Runtime runtime) {
                super(runtime);
            }
        }
    }
}

