/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.SequentialExecutorPlus;
import org.apache.cassandra.concurrent.TaskFactory;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBuilder;
import org.apache.cassandra.concurrent.ThreadPoolExecutorPlus;

public class SingleThreadExecutorPlus
extends ThreadPoolExecutorPlus
implements SequentialExecutorPlus {
    SingleThreadExecutorPlus(ThreadPoolExecutorBuilder<? extends SingleThreadExecutorPlus> builder) {
        this(builder, TaskFactory.standard());
    }

    SingleThreadExecutorPlus(ThreadPoolExecutorBuilder<? extends SingleThreadExecutorPlus> builder, TaskFactory taskFactory) {
        super(builder, taskFactory);
    }

    @Override
    public int getCorePoolSize() {
        return 1;
    }

    @Override
    public void setCorePoolSize(int number) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaximumPoolSize() {
        return 1;
    }

    @Override
    public void setMaximumPoolSize(int number) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AtLeastOnce atLeastOnceTrigger(Runnable run) {
        return new AtLeastOnce(this, run);
    }

    public static class AtLeastOnce
    extends AtomicBoolean
    implements SequentialExecutorPlus.AtLeastOnceTrigger,
    Runnable {
        protected final SequentialExecutorPlus executor;
        protected final Runnable run;

        public AtLeastOnce(SequentialExecutorPlus executor, Runnable run) {
            this.executor = executor;
            this.run = run;
        }

        @Override
        public boolean trigger() {
            boolean success = this.compareAndSet(false, true);
            if (success) {
                this.executor.execute(this);
            }
            return success;
        }

        @Override
        public void runAfter(Runnable run) {
            this.executor.execute(run);
        }

        @Override
        public void sync() {
            Future done = this.executor.submit(() -> {});
            done.awaitThrowUncheckedOnInterrupt();
            done.rethrowIfFailed();
        }

        @Override
        public void run() {
            this.set(false);
            this.run.run();
        }

        @Override
        public String toString() {
            return this.run.toString();
        }
    }
}

