/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.Loader;
import org.apache.cassandra.utils.FBUtilities;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;

public class DefaultLoader
implements Loader {
    @Override
    public Map<String, Property> getProperties(Class<?> root) {
        String name;
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (Class<?> c = root; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                name = FBUtilities.camelToSnake(f.getName());
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) || f.isAnnotationPresent(JsonIgnore.class) || Modifier.isTransient(modifiers) || !Modifier.isPublic(modifiers) || properties.containsKey(name)) continue;
                properties.put(name, new FieldProperty(f));
            }
        }
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(root).getPropertyDescriptors();
            if (descriptors != null) {
                for (PropertyDescriptor d : descriptors) {
                    name = FBUtilities.camelToSnake(d.getName());
                    Method writeMethod = d.getWriteMethod();
                    if (writeMethod == null || writeMethod.isAnnotationPresent(JsonIgnore.class) || properties.containsKey(name) && (d.getReadMethod() == null || d.getReadMethod().isAnnotationPresent(JsonIgnore.class))) continue;
                    d.setName(name);
                    properties.put(name, new MethodPropertyPlus(d));
                }
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    private static class MethodPropertyPlus
    extends MethodProperty {
        private final Method readMethod;

        public MethodPropertyPlus(PropertyDescriptor property) {
            super(property);
            this.readMethod = property.getReadMethod();
        }

        @Override
        public Object get(Object object) {
            if (!this.isReadable()) {
                throw new YAMLException("No readable property '" + this.getName() + "' on class: " + object.getClass().getName());
            }
            try {
                return this.readMethod.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new YAMLException("Unable to find getter for property '" + this.getName() + "' on class " + object.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new YAMLException("Failed calling getter for property '" + this.getName() + "' on class " + object.getClass().getName(), e.getCause());
            }
        }
    }
}

