/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.PasswordObfuscator;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEvents {
    private static final Logger logger = LoggerFactory.getLogger(QueryEvents.class);
    private static final NoSpamLogger noSpam1m = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    public static final QueryEvents instance = new QueryEvents();
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    @VisibleForTesting
    public int listenerCount() {
        return this.listeners.size();
    }

    public void registerListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyQuerySuccess(CQLStatement statement, String query, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        try {
            String maybeObfuscatedQuery = this.listeners.size() > 0 ? this.maybeObfuscatePassword(statement, query) : query;
            for (Listener listener : this.listeners) {
                listener.querySuccess(statement, maybeObfuscatedQuery, options, state, queryTime, response);
            }
        }
        catch (Throwable t2) {
            noSpam1m.error("Failed notifying listeners", t2);
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    public void notifyQueryFailure(CQLStatement statement, String query, QueryOptions options, QueryState state, Exception cause) {
        try {
            String maybeObfuscatedQuery = this.listeners.size() > 0 ? this.maybeObfuscatePassword(statement, query) : query;
            for (Listener listener : this.listeners) {
                listener.queryFailure(statement, maybeObfuscatedQuery, options, state, cause);
            }
        }
        catch (Throwable t2) {
            noSpam1m.error("Failed notifying listeners", t2);
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    public void notifyExecuteSuccess(CQLStatement statement, String query, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        try {
            String maybeObfuscatedQuery = this.listeners.size() > 0 ? this.maybeObfuscatePassword(statement, query) : query;
            for (Listener listener : this.listeners) {
                listener.executeSuccess(statement, maybeObfuscatedQuery, options, state, queryTime, response);
            }
        }
        catch (Throwable t2) {
            noSpam1m.error("Failed notifying listeners", t2);
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    public void notifyExecuteFailure(QueryHandler.Prepared prepared, QueryOptions options, QueryState state, Exception cause) {
        CQLStatement statement = prepared != null ? prepared.statement : null;
        String query = prepared != null ? prepared.rawCQLStatement : null;
        try {
            String maybeObfuscatedQuery = this.listeners.size() > 0 ? this.maybeObfuscatePassword(statement, query) : query;
            for (Listener listener : this.listeners) {
                listener.executeFailure(statement, maybeObfuscatedQuery, options, state, cause);
            }
        }
        catch (Throwable t2) {
            noSpam1m.error("Failed notifying listeners", t2);
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    public void notifyBatchSuccess(BatchStatement.Type batchType, List<? extends CQLStatement> statements, List<String> queries, List<List<ByteBuffer>> values, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        try {
            for (Listener listener : this.listeners) {
                listener.batchSuccess(batchType, statements, queries, values, options, state, queryTime, response);
            }
        }
        catch (Throwable t2) {
            noSpam1m.error("Failed notifying listeners", t2);
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    public void notifyBatchFailure(List<QueryHandler.Prepared> prepared, BatchStatement.Type batchType, List<Object> queryOrIdList, List<List<ByteBuffer>> values, QueryOptions options, QueryState state, Exception cause) {
        if (this.hasListeners()) {
            ArrayList statements = new ArrayList(queryOrIdList.size());
            ArrayList<String> queries = new ArrayList<String>(queryOrIdList.size());
            if (prepared != null) {
                prepared.forEach(p -> {
                    statements.add(p.statement);
                    queries.add(p.rawCQLStatement);
                });
            }
            try {
                for (Listener listener : this.listeners) {
                    listener.batchFailure(batchType, statements, queries, values, options, state, cause);
                }
            }
            catch (Throwable t2) {
                noSpam1m.error("Failed notifying listeners", t2);
                JVMStabilityInspector.inspectThrowable(t2);
            }
        }
    }

    public void notifyPrepareSuccess(Supplier<QueryHandler.Prepared> preparedProvider, String query, QueryState state, long queryTime, ResultMessage.Prepared response) {
        if (this.hasListeners()) {
            QueryHandler.Prepared prepared = preparedProvider.get();
            if (prepared != null) {
                try {
                    String maybeObfuscatedQuery = this.listeners.size() > 0 ? this.maybeObfuscatePassword(prepared.statement, query) : query;
                    for (Listener listener : this.listeners) {
                        listener.prepareSuccess(prepared.statement, maybeObfuscatedQuery, state, queryTime, response);
                    }
                }
                catch (Throwable t2) {
                    noSpam1m.error("Failed notifying listeners", t2);
                    JVMStabilityInspector.inspectThrowable(t2);
                }
            } else {
                this.notifyPrepareFailure(null, query, state, new RuntimeException("Successfully prepared, but could not find prepared statement for " + response.statementId));
            }
        }
    }

    public void notifyPrepareFailure(@Nullable CQLStatement statement, String query, QueryState state, Exception cause) {
        try {
            String maybeObfuscatedQuery = this.listeners.size() > 0 ? this.maybeObfuscatePassword(statement, query) : query;
            for (Listener listener : this.listeners) {
                listener.prepareFailure(statement, maybeObfuscatedQuery, state, cause);
            }
        }
        catch (Throwable t2) {
            noSpam1m.error("Failed notifying listeners", t2);
            JVMStabilityInspector.inspectThrowable(t2);
        }
    }

    private String maybeObfuscatePassword(CQLStatement statement, String query) {
        if (statement == null) {
            return PasswordObfuscator.obfuscate(query);
        }
        if (statement instanceof AuthenticationStatement) {
            return ((AuthenticationStatement)statement).obfuscatePassword(query);
        }
        return query;
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public static interface Listener {
        default public void querySuccess(CQLStatement statement, String query, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        }

        default public void queryFailure(@Nullable CQLStatement statement, String query, QueryOptions options, QueryState state, Exception cause) {
        }

        default public void executeSuccess(CQLStatement statement, String query, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        }

        default public void executeFailure(@Nullable CQLStatement statement, @Nullable String query, QueryOptions options, QueryState state, Exception cause) {
        }

        default public void batchSuccess(BatchStatement.Type batchType, List<? extends CQLStatement> statements, List<String> queries, List<List<ByteBuffer>> values, QueryOptions options, QueryState state, long queryTime, Message.Response response) {
        }

        default public void batchFailure(BatchStatement.Type batchType, List<? extends CQLStatement> statements, List<String> queries, List<List<ByteBuffer>> values, QueryOptions options, QueryState state, Exception cause) {
        }

        default public void prepareSuccess(CQLStatement statement, String query, QueryState state, long queryTime, ResultMessage.Prepared response) {
        }

        default public void prepareFailure(@Nullable CQLStatement statement, String query, QueryState state, Exception cause) {
        }
    }
}

