/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.functions.types.CodecUtils;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.Duration;
import org.apache.cassandra.cql3.functions.types.LocalDate;
import org.apache.cassandra.cql3.functions.types.Metadata;
import org.apache.cassandra.cql3.functions.types.ParseUtils;
import org.apache.cassandra.cql3.functions.types.TupleType;
import org.apache.cassandra.cql3.functions.types.TupleValue;
import org.apache.cassandra.cql3.functions.types.TypeTokens;
import org.apache.cassandra.cql3.functions.types.UDTValue;
import org.apache.cassandra.cql3.functions.types.UserType;
import org.apache.cassandra.cql3.functions.types.VectorCodec;
import org.apache.cassandra.cql3.functions.types.VectorType;
import org.apache.cassandra.cql3.functions.types.exceptions.InvalidTypeException;
import org.apache.cassandra.cql3.functions.types.utils.Bytes;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.vint.VIntCoding;

public abstract class TypeCodec<T> {
    private static final int VARIABLE_LENGTH = -1;
    private final TypeToken<T> javaType;
    final DataType cqlType;

    public static PrimitiveBooleanCodec cboolean() {
        return BooleanCodec.instance;
    }

    public static PrimitiveByteCodec tinyInt() {
        return TinyIntCodec.instance;
    }

    public static PrimitiveShortCodec smallInt() {
        return SmallIntCodec.instance;
    }

    public static PrimitiveIntCodec cint() {
        return IntCodec.instance;
    }

    public static PrimitiveLongCodec bigint() {
        return BigintCodec.instance;
    }

    public static PrimitiveLongCodec counter() {
        return CounterCodec.instance;
    }

    public static PrimitiveFloatCodec cfloat() {
        return FloatCodec.instance;
    }

    public static PrimitiveDoubleCodec cdouble() {
        return DoubleCodec.instance;
    }

    public static TypeCodec<BigInteger> varint() {
        return VarintCodec.instance;
    }

    public static TypeCodec<BigDecimal> decimal() {
        return DecimalCodec.instance;
    }

    public static TypeCodec<String> ascii() {
        return AsciiCodec.instance;
    }

    public static TypeCodec<String> varchar() {
        return VarcharCodec.instance;
    }

    public static TypeCodec<ByteBuffer> blob() {
        return BlobCodec.instance;
    }

    public static TypeCodec<LocalDate> date() {
        return DateCodec.instance;
    }

    public static PrimitiveLongCodec time() {
        return TimeCodec.instance;
    }

    public static TypeCodec<Date> timestamp() {
        return TimestampCodec.instance;
    }

    public static TypeCodec<UUID> uuid() {
        return UUIDCodec.instance;
    }

    public static TypeCodec<UUID> timeUUID() {
        return TimeUUIDCodec.instance;
    }

    public static TypeCodec<InetAddress> inet() {
        return InetCodec.instance;
    }

    public static <T> TypeCodec<List<T>> list(TypeCodec<T> elementCodec) {
        return new ListCodec<T>(elementCodec);
    }

    public static <T> TypeCodec<Set<T>> set(TypeCodec<T> elementCodec) {
        return new SetCodec<T>(elementCodec);
    }

    public static <K, V> TypeCodec<Map<K, V>> map(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec) {
        return new MapCodec<K, V>(keyCodec, valueCodec);
    }

    public static <E> TypeCodec<List<E>> vector(VectorType type, TypeCodec<E> valueCodec) {
        return VectorCodec.of(type, valueCodec);
    }

    public static TypeCodec<UDTValue> userType(UserType type) {
        return new UDTCodec(type);
    }

    public static TypeCodec<TupleValue> tuple(TupleType type) {
        return new TupleCodec(type);
    }

    public static TypeCodec<ByteBuffer> custom(DataType.CustomType type) {
        return new CustomCodec(type);
    }

    public static TypeCodec<Duration> duration() {
        return DurationCodec.instance;
    }

    protected TypeCodec(DataType cqlType, Class<T> javaClass) {
        this(cqlType, TypeToken.of(javaClass));
    }

    protected TypeCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType, "cqlType cannot be null");
        Preconditions.checkNotNull(javaType, "javaType cannot be null");
        Preconditions.checkArgument(!javaType.isPrimitive(), "Cannot create a codec for a primitive Java type (%s), please use the wrapper type instead", javaType);
        this.cqlType = cqlType;
        this.javaType = javaType;
    }

    public TypeToken<T> getJavaType() {
        return this.javaType;
    }

    public DataType getCqlType() {
        return this.cqlType;
    }

    public int serializedSize() {
        return -1;
    }

    public final boolean isSerializedSizeFixed() {
        return this.serializedSize() != -1;
    }

    public abstract ByteBuffer serialize(T var1, ProtocolVersion var2) throws InvalidTypeException;

    public abstract T deserialize(ByteBuffer var1, ProtocolVersion var2) throws InvalidTypeException;

    public abstract T parse(String var1) throws InvalidTypeException;

    public abstract String format(T var1) throws InvalidTypeException;

    public boolean accepts(TypeToken<?> javaType) {
        Preconditions.checkNotNull(javaType, "Parameter javaType cannot be null");
        return this.javaType.equals(javaType.wrap());
    }

    public boolean accepts(Class<?> javaType) {
        Preconditions.checkNotNull(javaType, "Parameter javaType cannot be null");
        return this.accepts(TypeToken.of(javaType));
    }

    public boolean accepts(DataType cqlType) {
        Preconditions.checkNotNull(cqlType, "Parameter cqlType cannot be null");
        return this.cqlType.equals(cqlType);
    }

    public boolean accepts(Object value) {
        Preconditions.checkNotNull(value, "Parameter value cannot be null");
        return this.javaType.isSupertypeOf(TypeToken.of(value.getClass()));
    }

    public String toString() {
        return String.format("%s [%s <-> %s]", this.getClass().getSimpleName(), this.cqlType, this.javaType);
    }

    private static class DurationCodec
    extends TypeCodec<Duration> {
        private static final DurationCodec instance = new DurationCodec();

        private DurationCodec() {
            super(DataType.duration(), Duration.class);
        }

        @Override
        public ByteBuffer serialize(Duration duration, ProtocolVersion protocolVersion) throws InvalidTypeException {
            if (duration == null) {
                return null;
            }
            long months = duration.getMonths();
            long days = duration.getDays();
            long nanoseconds = duration.getNanoseconds();
            int size = VIntCoding.computeVIntSize(months) + VIntCoding.computeVIntSize(days) + VIntCoding.computeVIntSize(nanoseconds);
            ByteBuffer bb = ByteBuffer.allocate(size);
            VIntCoding.writeVInt(months, bb);
            VIntCoding.writeVInt(days, bb);
            VIntCoding.writeVInt(nanoseconds, bb);
            bb.flip();
            return bb;
        }

        @Override
        public Duration deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            ByteArrayDataInput in = ByteStreams.newDataInput(Bytes.getArray(bytes));
            try {
                int months = VIntCoding.readVInt32(in);
                int days = VIntCoding.readVInt32(in);
                long nanoseconds = VIntCoding.readVInt(in);
                return Duration.newInstance(months, days, nanoseconds);
            }
            catch (IOException e) {
                throw new AssertionError();
            }
        }

        @Override
        public Duration parse(String value) throws InvalidTypeException {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            return Duration.from(value);
        }

        @Override
        public String format(Duration value) throws InvalidTypeException {
            if (value == null) {
                return "NULL";
            }
            return value.toString();
        }
    }

    private static class TupleCodec
    extends AbstractTupleCodec<TupleValue> {
        private TupleCodec(TupleType definition) {
            super(definition, TupleValue.class);
        }

        @Override
        public boolean accepts(Object value) {
            return super.accepts(value) && this.definition.contains(((TupleValue)value).getType());
        }

        @Override
        protected TupleValue newInstance() {
            return this.definition.newValue();
        }

        @Override
        protected ByteBuffer serializeField(TupleValue source, int index, ProtocolVersion protocolVersion) {
            if (index >= source.values.length) {
                return null;
            }
            return source.getBytesUnsafe(index);
        }

        @Override
        protected TupleValue deserializeAndSetField(ByteBuffer input, TupleValue target, int index, ProtocolVersion protocolVersion) {
            if (index >= target.values.length) {
                return target;
            }
            return (TupleValue)target.setBytesUnsafe(index, input);
        }

        @Override
        protected String formatField(TupleValue value, int index) {
            DataType elementType = this.definition.getComponentTypes().get(index);
            TypeCodec<Object> codec = this.definition.getCodecRegistry().codecFor(elementType);
            return codec.format(value.get(index, codec.getJavaType()));
        }

        @Override
        protected TupleValue parseAndSetField(String input, TupleValue target, int index) {
            DataType elementType = this.definition.getComponentTypes().get(index);
            TypeCodec codec = this.definition.getCodecRegistry().codecFor(elementType);
            target.set(index, codec.parse(input), codec.getJavaType());
            return target;
        }
    }

    public static abstract class AbstractTupleCodec<T>
    extends TypeCodec<T> {
        protected final TupleType definition;

        AbstractTupleCodec(TupleType definition, Class<T> javaClass) {
            this(definition, TypeToken.of(javaClass));
        }

        AbstractTupleCodec(TupleType definition, TypeToken<T> javaType) {
            super((DataType)definition, javaType);
            this.definition = definition;
        }

        @Override
        public boolean accepts(DataType cqlType) {
            return super.accepts(cqlType) && this.definition.contains((TupleType)cqlType);
        }

        @Override
        public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            int size = 0;
            int length = this.definition.getComponentTypes().size();
            ByteBuffer[] elements = new ByteBuffer[length];
            for (int i = 0; i < length; ++i) {
                elements[i] = this.serializeField(value, i, protocolVersion);
                size += 4 + (elements[i] == null ? 0 : elements[i].remaining());
            }
            ByteBuffer result = ByteBuffer.allocate(size);
            for (ByteBuffer bb : elements) {
                if (bb == null) {
                    result.putInt(-1);
                    continue;
                }
                result.putInt(bb.remaining());
                result.put(bb.duplicate());
            }
            return result.flip();
        }

        @Override
        public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null) {
                return null;
            }
            try {
                ByteBuffer input = bytes.duplicate();
                T value = this.newInstance();
                int i = 0;
                while (input.hasRemaining() && i < this.definition.getComponentTypes().size()) {
                    int n = input.getInt();
                    ByteBuffer element = n < 0 ? null : CodecUtils.readBytes(input, n);
                    value = this.deserializeAndSetField(element, value, i++, protocolVersion);
                }
                return value;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a tuple", e);
            }
        }

        @Override
        public String format(T value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder("(");
            int length = this.definition.getComponentTypes().size();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.formatField(value, i));
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public T parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            T v = this.newInstance();
            int idx = ParseUtils.skipSpaces(value, 0);
            if (value.charAt(idx++) != '(') {
                throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting '(' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
            }
            if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == ')') {
                return v;
            }
            int i = 0;
            while (idx < value.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", invalid CQL value at character %d", value, idx), e);
                }
                String input = value.substring(idx, n);
                v = this.parseAndSetField(input, v, i);
                idx = n;
                ++i;
                idx = ParseUtils.skipSpaces(value, idx);
                if (value.charAt(idx) == ')') {
                    return v;
                }
                if (value.charAt(idx) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
                }
                ++idx;
                idx = ParseUtils.skipSpaces(value, idx);
            }
            throw new InvalidTypeException(String.format("Malformed tuple value \"%s\", missing closing ')'", value));
        }

        protected abstract T newInstance();

        protected abstract ByteBuffer serializeField(T var1, int var2, ProtocolVersion var3);

        protected abstract T deserializeAndSetField(ByteBuffer var1, T var2, int var3, ProtocolVersion var4);

        protected abstract String formatField(T var1, int var2);

        protected abstract T parseAndSetField(String var1, T var2, int var3);
    }

    private static class UDTCodec
    extends AbstractUDTCodec<UDTValue> {
        private UDTCodec(UserType definition) {
            super(definition, UDTValue.class);
        }

        @Override
        public boolean accepts(Object value) {
            return super.accepts(value) && ((UDTValue)value).getType().equals(this.definition);
        }

        @Override
        protected UDTValue newInstance() {
            return this.definition.newValue();
        }

        @Override
        protected ByteBuffer serializeField(UDTValue source, String fieldName, ProtocolVersion protocolVersion) {
            return source.getBytesUnsafe(fieldName);
        }

        @Override
        protected UDTValue deserializeAndSetField(ByteBuffer input, UDTValue target, String fieldName, ProtocolVersion protocolVersion) {
            return (UDTValue)target.setBytesUnsafe(fieldName, input);
        }

        @Override
        protected String formatField(UDTValue source, String fieldName) {
            DataType elementType = this.definition.getFieldType(fieldName);
            TypeCodec codec = this.definition.getCodecRegistry().codecFor(elementType);
            return codec.format(source.get(fieldName, codec.getJavaType()));
        }

        @Override
        protected UDTValue parseAndSetField(String input, UDTValue target, String fieldName) {
            DataType elementType = this.definition.getFieldType(fieldName);
            TypeCodec codec = this.definition.getCodecRegistry().codecFor(elementType);
            target.set(fieldName, codec.parse(input), codec.getJavaType());
            return target;
        }
    }

    public static abstract class AbstractUDTCodec<T>
    extends TypeCodec<T> {
        protected final UserType definition;

        AbstractUDTCodec(UserType definition, Class<T> javaClass) {
            this(definition, TypeToken.of(javaClass));
        }

        AbstractUDTCodec(UserType definition, TypeToken<T> javaType) {
            super((DataType)definition, javaType);
            this.definition = definition;
        }

        @Override
        public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            int size = 0;
            int length = this.definition.size();
            ByteBuffer[] elements = new ByteBuffer[length];
            int i = 0;
            for (UserType.Field field : this.definition) {
                elements[i] = this.serializeField(value, Metadata.quoteIfNecessary(field.getName()), protocolVersion);
                size += 4 + (elements[i] == null ? 0 : elements[i].remaining());
                ++i;
            }
            ByteBuffer result = ByteBuffer.allocate(size);
            for (ByteBuffer bb : elements) {
                if (bb == null) {
                    result.putInt(-1);
                    continue;
                }
                result.putInt(bb.remaining());
                result.put(bb.duplicate());
            }
            return result.flip();
        }

        @Override
        public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null) {
                return null;
            }
            try {
                ByteBuffer input = bytes.duplicate();
                T value = this.newInstance();
                for (UserType.Field field : this.definition) {
                    if (!input.hasRemaining()) break;
                    int n = input.getInt();
                    ByteBuffer element = n < 0 ? null : CodecUtils.readBytes(input, n);
                    value = this.deserializeAndSetField(element, value, Metadata.quoteIfNecessary(field.getName()), protocolVersion);
                }
                return value;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a UDT", e);
            }
        }

        @Override
        public String format(T value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder("{");
            int i = 0;
            for (UserType.Field field : this.definition) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Metadata.quoteIfNecessary(field.getName()));
                sb.append(':');
                sb.append(this.formatField(value, Metadata.quoteIfNecessary(field.getName())));
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public T parse(String value) {
            if (value == null || value.isEmpty() || value.equals("NULL")) {
                return null;
            }
            T v = this.newInstance();
            int idx = ParseUtils.skipSpaces(value, 0);
            if (value.charAt(idx++) != '{') {
                throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting '{' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
            }
            if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == '}') {
                return v;
            }
            while (idx < value.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLId(value, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", cannot parse a CQL identifier at character %d", value, idx), e);
                }
                String name = value.substring(idx, n);
                idx = n;
                if (!this.definition.contains(name)) {
                    throw new InvalidTypeException(String.format("Unknown field %s in value \"%s\"", name, value));
                }
                idx = ParseUtils.skipSpaces(value, idx);
                if (value.charAt(idx++) != ':') {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting ':' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value, idx);
                try {
                    n = ParseUtils.skipCQLValue(value, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", invalid CQL value at character %d", value, idx), e);
                }
                String input = value.substring(idx, n);
                v = this.parseAndSetField(input, v, name);
                idx = n;
                idx = ParseUtils.skipSpaces(value, idx);
                if (value.charAt(idx) == '}') {
                    return v;
                }
                if (value.charAt(idx) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
                }
                ++idx;
                idx = ParseUtils.skipSpaces(value, idx);
            }
            throw new InvalidTypeException(String.format("Malformed UDT value \"%s\", missing closing '}'", value));
        }

        protected abstract T newInstance();

        protected abstract ByteBuffer serializeField(T var1, String var2, ProtocolVersion var3);

        protected abstract T deserializeAndSetField(ByteBuffer var1, T var2, String var3, ProtocolVersion var4);

        protected abstract String formatField(T var1, String var2);

        protected abstract T parseAndSetField(String var1, T var2, String var3);
    }

    private static class MapCodec<K, V>
    extends AbstractMapCodec<K, V> {
        private MapCodec(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec) {
            super(keyCodec, valueCodec);
        }

        @Override
        protected Map<K, V> newInstance(int size) {
            return new LinkedHashMap(size);
        }
    }

    public static abstract class AbstractMapCodec<K, V>
    extends TypeCodec<Map<K, V>> {
        final TypeCodec<K> keyCodec;
        final TypeCodec<V> valueCodec;

        AbstractMapCodec(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec) {
            super((DataType)DataType.map(keyCodec.getCqlType(), valueCodec.getCqlType()), TypeTokens.mapOf(keyCodec.getJavaType(), valueCodec.getJavaType()));
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
        }

        @Override
        public boolean accepts(Object value) {
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    return true;
                }
                Map.Entry entry = map.entrySet().iterator().next();
                return this.keyCodec.accepts(entry.getKey()) && this.valueCodec.accepts(entry.getValue());
            }
            return false;
        }

        @Override
        public Map<K, V> parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value, 0);
            if (value.charAt(idx++) != '{') {
                throw new InvalidTypeException(String.format("cannot parse map value from \"%s\", at character %d expecting '{' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
            }
            if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == '}') {
                return this.newInstance(0);
            }
            HashMap<K, V> m4 = new HashMap<K, V>();
            while (idx < value.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value, idx), e);
                }
                K k = this.keyCodec.parse(value.substring(idx, n));
                idx = n;
                idx = ParseUtils.skipSpaces(value, idx);
                if (value.charAt(idx++) != ':') {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", at character %d expecting ':' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value, idx);
                try {
                    n = ParseUtils.skipCQLValue(value, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value, idx), e);
                }
                V v = this.valueCodec.parse(value.substring(idx, n));
                idx = n;
                m4.put(k, v);
                idx = ParseUtils.skipSpaces(value, idx);
                if (value.charAt(idx) == '}') {
                    return m4;
                }
                if (value.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value, idx);
            }
            throw new InvalidTypeException(String.format("Malformed map value \"%s\", missing closing '}'", value));
        }

        @Override
        public String format(Map<K, V> value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int i = 0;
            for (Map.Entry<K, V> e : value.entrySet()) {
                if (i++ != 0) {
                    sb.append(',');
                }
                sb.append(this.keyCodec.format(e.getKey()));
                sb.append(':');
                sb.append(this.valueCodec.format(e.getValue()));
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public ByteBuffer serialize(Map<K, V> value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            int i = 0;
            ByteBuffer[] bbs = new ByteBuffer[2 * value.size()];
            for (Map.Entry<K, V> entry : value.entrySet()) {
                ByteBuffer bbv;
                ByteBuffer bbk;
                K key = entry.getKey();
                if (key == null) {
                    throw new NullPointerException("Map keys cannot be null");
                }
                try {
                    bbk = this.keyCodec.serialize(key, protocolVersion);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for map key, expecting %s but got %s", this.keyCodec.getJavaType(), key.getClass()), e);
                }
                V v = entry.getValue();
                if (v == null) {
                    throw new NullPointerException("Map values cannot be null");
                }
                try {
                    bbv = this.valueCodec.serialize(v, protocolVersion);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for map value, expecting %s but got %s", this.valueCodec.getJavaType(), v.getClass()), e);
                }
                bbs[i++] = bbk;
                bbs[i++] = bbv;
            }
            return CodecUtils.pack(bbs, value.size(), protocolVersion);
        }

        @Override
        public Map<K, V> deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return this.newInstance(0);
            }
            try {
                ByteBuffer input = bytes.duplicate();
                int n = CodecUtils.readSize(input, protocolVersion);
                Map<K, V> m4 = this.newInstance(n);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer kbb = CodecUtils.readValue(input, protocolVersion);
                    ByteBuffer vbb = CodecUtils.readValue(input, protocolVersion);
                    m4.put(this.keyCodec.deserialize(kbb, protocolVersion), this.valueCodec.deserialize(vbb, protocolVersion));
                }
                return m4;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a map", e);
            }
        }

        protected abstract Map<K, V> newInstance(int var1);
    }

    private static class SetCodec<T>
    extends AbstractCollectionCodec<T, Set<T>> {
        private SetCodec(TypeCodec<T> eltCodec) {
            super(DataType.set(eltCodec.cqlType), TypeTokens.setOf(eltCodec.getJavaType()), eltCodec);
        }

        @Override
        protected Set<T> newInstance(int size) {
            return new LinkedHashSet(size);
        }
    }

    private static class ListCodec<T>
    extends AbstractCollectionCodec<T, List<T>> {
        private ListCodec(TypeCodec<T> eltCodec) {
            super(DataType.list(eltCodec.getCqlType()), TypeTokens.listOf(eltCodec.getJavaType()), eltCodec);
        }

        @Override
        protected List<T> newInstance(int size) {
            return new ArrayList(size);
        }
    }

    public static abstract class AbstractCollectionCodec<E, C extends Collection<E>>
    extends TypeCodec<C> {
        final TypeCodec<E> eltCodec;

        AbstractCollectionCodec(DataType.CollectionType cqlType, TypeToken<C> javaType, TypeCodec<E> eltCodec) {
            super((DataType)cqlType, javaType);
            Preconditions.checkArgument(cqlType.getName() == DataType.Name.LIST || cqlType.getName() == DataType.Name.SET, "Expecting list or set type, got %s", (Object)cqlType);
            this.eltCodec = eltCodec;
        }

        @Override
        public ByteBuffer serialize(C value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            int i = 0;
            ByteBuffer[] bbs = new ByteBuffer[value.size()];
            for (Object elt : value) {
                ByteBuffer bb;
                if (elt == null) {
                    throw new NullPointerException("Collection elements cannot be null");
                }
                try {
                    bb = this.eltCodec.serialize(elt, protocolVersion);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for %s element, expecting %s but got %s", this.cqlType, this.eltCodec.getJavaType(), elt.getClass()), e);
                }
                bbs[i++] = bb;
            }
            return CodecUtils.pack(bbs, value.size(), protocolVersion);
        }

        @Override
        public C deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return this.newInstance(0);
            }
            try {
                ByteBuffer input = bytes.duplicate();
                int size = CodecUtils.readSize(input, protocolVersion);
                C coll = this.newInstance(size);
                for (int i = 0; i < size; ++i) {
                    ByteBuffer databb = CodecUtils.readValue(input, protocolVersion);
                    coll.add(this.eltCodec.deserialize(databb, protocolVersion));
                }
                return coll;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize collection", e);
            }
        }

        @Override
        public String format(C value) {
            if (value == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getOpeningChar());
            int i = 0;
            for (Object v : value) {
                if (i++ != 0) {
                    sb.append(',');
                }
                sb.append(this.eltCodec.format(v));
            }
            sb.append(this.getClosingChar());
            return sb.toString();
        }

        @Override
        public C parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value, 0);
            if (value.charAt(idx++) != this.getOpeningChar()) {
                throw new InvalidTypeException(String.format("Cannot parse collection value from \"%s\", at character %d expecting '%s' but got '%c'", value, idx, Character.valueOf(this.getOpeningChar()), Character.valueOf(value.charAt(idx))));
            }
            if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == this.getClosingChar()) {
                return this.newInstance(0);
            }
            C l = this.newInstance(10);
            while (idx < value.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse collection value from \"%s\", invalid CQL value at character %d", value, idx), e);
                }
                l.add(this.eltCodec.parse(value.substring(idx, n)));
                idx = n;
                idx = ParseUtils.skipSpaces(value, idx);
                if (value.charAt(idx) == this.getClosingChar()) {
                    return l;
                }
                if (value.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse collection value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value, idx);
            }
            throw new InvalidTypeException(String.format("Malformed collection value \"%s\", missing closing '%s'", value, Character.valueOf(this.getClosingChar())));
        }

        @Override
        public boolean accepts(Object value) {
            if (this.getJavaType().getRawType().isAssignableFrom(value.getClass())) {
                Collection coll = (Collection)value;
                if (coll.isEmpty()) {
                    return true;
                }
                Object elt = coll.iterator().next();
                return this.eltCodec.accepts(elt);
            }
            return false;
        }

        protected abstract C newInstance(int var1);

        private char getOpeningChar() {
            return this.cqlType.getName() == DataType.Name.LIST ? (char)'[' : '{';
        }

        private char getClosingChar() {
            return this.cqlType.getName() == DataType.Name.LIST ? (char)']' : '}';
        }
    }

    private static class VarintCodec
    extends TypeCodec<BigInteger> {
        private static final VarintCodec instance = new VarintCodec();

        private VarintCodec() {
            super(DataType.varint(), BigInteger.class);
        }

        @Override
        public BigInteger parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : new BigInteger(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse varint value from \"%s\"", value), e);
            }
        }

        @Override
        public String format(BigInteger value) {
            if (value == null) {
                return "NULL";
            }
            return value.toString();
        }

        @Override
        public ByteBuffer serialize(BigInteger value, ProtocolVersion protocolVersion) {
            return value == null ? null : ByteBuffer.wrap(value.toByteArray());
        }

        @Override
        public BigInteger deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : new BigInteger(Bytes.getArray(bytes));
        }
    }

    private static class TimeUUIDCodec
    extends AbstractUUIDCodec {
        private static final TimeUUIDCodec instance = new TimeUUIDCodec();

        private TimeUUIDCodec() {
            super(DataType.timeuuid());
        }

        @Override
        public String format(UUID value) {
            if (value == null) {
                return "NULL";
            }
            if (value.version() != 1) {
                throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", value));
            }
            return super.format(value);
        }

        @Override
        public ByteBuffer serialize(UUID value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            if (value.version() != 1) {
                throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", value));
            }
            return super.serialize(value, protocolVersion);
        }
    }

    private static class UUIDCodec
    extends AbstractUUIDCodec {
        private static final UUIDCodec instance = new UUIDCodec();

        private UUIDCodec() {
            super(DataType.uuid());
        }
    }

    private static abstract class AbstractUUIDCodec
    extends TypeCodec<UUID> {
        private AbstractUUIDCodec(DataType cqlType) {
            super(cqlType, UUID.class);
        }

        @Override
        public int serializedSize() {
            return 16;
        }

        @Override
        public UUID parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse UUID value from \"%s\"", value), e);
            }
        }

        @Override
        public String format(UUID value) {
            if (value == null) {
                return "NULL";
            }
            return value.toString();
        }

        @Override
        public ByteBuffer serialize(UUID value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(0, value.getMostSignificantBits());
            bb.putLong(8, value.getLeastSignificantBits());
            return bb;
        }

        @Override
        public UUID deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : new UUID(bytes.getLong(bytes.position()), bytes.getLong(bytes.position() + 8));
        }
    }

    private static class TimeCodec
    extends LongCodec {
        private static final TimeCodec instance = new TimeCodec();

        private TimeCodec() {
            super(DataType.time());
        }

        @Override
        public Long parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value)) {
                throw new InvalidTypeException("time values must be enclosed by single quotes");
            }
            if (ParseUtils.isLongLiteral(value = value.substring(1, value.length() - 1))) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value), e);
                }
            }
            try {
                return ParseUtils.parseTime(value);
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value), e);
            }
        }

        @Override
        public String format(Long value) {
            if (value == null) {
                return "NULL";
            }
            return ParseUtils.quote(ParseUtils.formatTime(value));
        }
    }

    private static class DateCodec
    extends TypeCodec<LocalDate> {
        private static final DateCodec instance = new DateCodec();
        private static final String pattern = "yyyy-MM-dd";

        private DateCodec() {
            super(DataType.date(), LocalDate.class);
        }

        @Override
        public int serializedSize() {
            return 8;
        }

        @Override
        public LocalDate parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (ParseUtils.isQuoted(value)) {
                value = ParseUtils.unquote(value);
            }
            if (ParseUtils.isLongLiteral(value)) {
                long unsigned;
                try {
                    unsigned = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), e);
                }
                try {
                    int days = CodecUtils.fromCqlDateToDaysSinceEpoch(unsigned);
                    return LocalDate.fromDaysSinceEpoch(days);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), e);
                }
            }
            try {
                Date date = ParseUtils.parseDate(value, pattern);
                return LocalDate.fromMillisSinceEpoch(date.getTime());
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value), e);
            }
        }

        @Override
        public String format(LocalDate value) {
            if (value == null) {
                return "NULL";
            }
            return ParseUtils.quote(value.toString());
        }

        @Override
        public ByteBuffer serialize(LocalDate value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            int unsigned = CodecUtils.fromSignedToUnsignedInt(value.getDaysSinceEpoch());
            return IntCodec.instance.serializeNoBoxing(unsigned, protocolVersion);
        }

        @Override
        public LocalDate deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            int unsigned = IntCodec.instance.deserializeNoBoxing(bytes, protocolVersion);
            int signed = CodecUtils.fromUnsignedToSignedInt(unsigned);
            return LocalDate.fromDaysSinceEpoch(signed);
        }
    }

    private static class TimestampCodec
    extends TypeCodec<Date> {
        private static final TimestampCodec instance = new TimestampCodec();

        private TimestampCodec() {
            super(DataType.timestamp(), Date.class);
        }

        @Override
        public int serializedSize() {
            return 8;
        }

        @Override
        public Date parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (ParseUtils.isQuoted(value)) {
                value = ParseUtils.unquote(value);
            }
            if (ParseUtils.isLongLiteral(value)) {
                try {
                    return new Date(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
                }
            }
            try {
                return ParseUtils.parseDate(value);
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
            }
        }

        @Override
        public String format(Date value) {
            if (value == null) {
                return "NULL";
            }
            return Long.toString(value.getTime());
        }

        @Override
        public ByteBuffer serialize(Date value, ProtocolVersion protocolVersion) {
            return value == null ? null : BigintCodec.instance.serializeNoBoxing(value.getTime(), protocolVersion);
        }

        @Override
        public Date deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : new Date(BigintCodec.instance.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    private static class IntCodec
    extends PrimitiveIntCodec {
        private static final IntCodec instance = new IntCodec();

        private IntCodec() {
            super(DataType.cint());
        }

        @Override
        public int serializedSize() {
            return 4;
        }

        @Override
        public Integer parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Integer.valueOf(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 32-bits int value from \"%s\"", value));
            }
        }

        @Override
        public String format(Integer value) {
            if (value == null) {
                return "NULL";
            }
            return Integer.toString(value);
        }

        @Override
        public ByteBuffer serializeNoBoxing(int value, ProtocolVersion protocolVersion) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(0, value);
            return bb;
        }

        @Override
        public int deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0;
            }
            if (bytes.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits integer value, expecting 4 bytes but got " + bytes.remaining());
            }
            return bytes.getInt(bytes.position());
        }
    }

    private static class SmallIntCodec
    extends PrimitiveShortCodec {
        private static final SmallIntCodec instance = new SmallIntCodec();

        private SmallIntCodec() {
            super(DataType.smallint());
        }

        @Override
        public Short parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Short.valueOf(Short.parseShort(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 16-bits int value from \"%s\"", value));
            }
        }

        @Override
        public String format(Short value) {
            if (value == null) {
                return "NULL";
            }
            return Short.toString(value);
        }

        @Override
        public ByteBuffer serializeNoBoxing(short value, ProtocolVersion protocolVersion) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(0, value);
            return bb;
        }

        @Override
        public short deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0;
            }
            if (bytes.remaining() != 2) {
                throw new InvalidTypeException("Invalid 16-bits integer value, expecting 2 bytes but got " + bytes.remaining());
            }
            return bytes.getShort(bytes.position());
        }
    }

    private static class TinyIntCodec
    extends PrimitiveByteCodec {
        private static final TinyIntCodec instance = new TinyIntCodec();

        private TinyIntCodec() {
            super(DataType.tinyint());
        }

        @Override
        public Byte parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Byte.valueOf(Byte.parseByte(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 8-bits int value from \"%s\"", value));
            }
        }

        @Override
        public String format(Byte value) {
            if (value == null) {
                return "NULL";
            }
            return Byte.toString(value);
        }

        @Override
        public ByteBuffer serializeNoBoxing(byte value, ProtocolVersion protocolVersion) {
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, value);
            return bb;
        }

        @Override
        public byte deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0;
            }
            if (bytes.remaining() != 1) {
                throw new InvalidTypeException("Invalid 8-bits integer value, expecting 1 byte but got " + bytes.remaining());
            }
            return bytes.get(bytes.position());
        }
    }

    private static class InetCodec
    extends TypeCodec<InetAddress> {
        private static final InetCodec instance = new InetCodec();

        private InetCodec() {
            super(DataType.inet(), InetAddress.class);
        }

        @Override
        public InetAddress parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value = value.trim())) {
                throw new InvalidTypeException(String.format("inet values must be enclosed in single quotes (\"%s\")", value));
            }
            try {
                return InetAddress.getByName(value.substring(1, value.length() - 1));
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Cannot parse inet value from \"%s\"", value));
            }
        }

        @Override
        public String format(InetAddress value) {
            if (value == null) {
                return "NULL";
            }
            return "'" + value.getHostAddress() + "'";
        }

        @Override
        public ByteBuffer serialize(InetAddress value, ProtocolVersion protocolVersion) {
            return value == null ? null : ByteBuffer.wrap(value.getAddress());
        }

        @Override
        public InetAddress deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            try {
                return InetAddress.getByAddress(Bytes.getArray(bytes));
            }
            catch (UnknownHostException e) {
                throw new InvalidTypeException("Invalid bytes for inet value, got " + bytes.remaining() + " bytes");
            }
        }
    }

    private static class FloatCodec
    extends PrimitiveFloatCodec {
        private static final FloatCodec instance = new FloatCodec();

        private FloatCodec() {
            super(DataType.cfloat());
        }

        @Override
        public int serializedSize() {
            return 4;
        }

        @Override
        public Float parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 32-bits float value from \"%s\"", value));
            }
        }

        @Override
        public String format(Float value) {
            if (value == null) {
                return "NULL";
            }
            return Float.toString(value.floatValue());
        }

        @Override
        public ByteBuffer serializeNoBoxing(float value, ProtocolVersion protocolVersion) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putFloat(0, value);
            return bb;
        }

        @Override
        public float deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0.0f;
            }
            if (bytes.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits float value, expecting 4 bytes but got " + bytes.remaining());
            }
            return bytes.getFloat(bytes.position());
        }
    }

    private static class DoubleCodec
    extends PrimitiveDoubleCodec {
        private static final DoubleCodec instance = new DoubleCodec();

        private DoubleCodec() {
            super(DataType.cdouble());
        }

        @Override
        public int serializedSize() {
            return 8;
        }

        @Override
        public Double parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Double.valueOf(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 64-bits double value from \"%s\"", value));
            }
        }

        @Override
        public String format(Double value) {
            if (value == null) {
                return "NULL";
            }
            return Double.toString(value);
        }

        @Override
        public ByteBuffer serializeNoBoxing(double value, ProtocolVersion protocolVersion) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putDouble(0, value);
            return bb;
        }

        @Override
        public double deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0.0;
            }
            if (bytes.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits double value, expecting 8 bytes but got " + bytes.remaining());
            }
            return bytes.getDouble(bytes.position());
        }
    }

    private static class DecimalCodec
    extends TypeCodec<BigDecimal> {
        private static final DecimalCodec instance = new DecimalCodec();

        private DecimalCodec() {
            super(DataType.decimal(), BigDecimal.class);
        }

        @Override
        public BigDecimal parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse decimal value from \"%s\"", value));
            }
        }

        @Override
        public String format(BigDecimal value) {
            if (value == null) {
                return "NULL";
            }
            return value.toString();
        }

        @Override
        public ByteBuffer serialize(BigDecimal value, ProtocolVersion protocolVersion) {
            if (value == null) {
                return null;
            }
            BigInteger bi = value.unscaledValue();
            int scale = value.scale();
            byte[] bibytes = bi.toByteArray();
            ByteBuffer bytes = ByteBuffer.allocate(4 + bibytes.length);
            bytes.putInt(scale);
            bytes.put(bibytes);
            bytes.rewind();
            return bytes;
        }

        @Override
        public BigDecimal deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            if (bytes.remaining() < 4) {
                throw new InvalidTypeException("Invalid decimal value, expecting at least 4 bytes but got " + bytes.remaining());
            }
            bytes = bytes.duplicate();
            int scale = bytes.getInt();
            byte[] bibytes = new byte[bytes.remaining()];
            bytes.get(bibytes);
            BigInteger bi = new BigInteger(bibytes);
            return new BigDecimal(bi, scale);
        }
    }

    private static class BooleanCodec
    extends PrimitiveBooleanCodec {
        private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
        private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});
        private static final BooleanCodec instance = new BooleanCodec();

        private BooleanCodec() {
            super(DataType.cboolean());
        }

        @Override
        public int serializedSize() {
            return 1;
        }

        @Override
        public Boolean parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                return false;
            }
            if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                return true;
            }
            throw new InvalidTypeException(String.format("Cannot parse boolean value from \"%s\"", value));
        }

        @Override
        public String format(Boolean value) {
            if (value == null) {
                return "NULL";
            }
            return value != false ? "true" : "false";
        }

        @Override
        public ByteBuffer serializeNoBoxing(boolean value, ProtocolVersion protocolVersion) {
            return value ? TRUE.duplicate() : FALSE.duplicate();
        }

        @Override
        public boolean deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return false;
            }
            if (bytes.remaining() != 1) {
                throw new InvalidTypeException("Invalid boolean value, expecting 1 byte but got " + bytes.remaining());
            }
            return bytes.get(bytes.position()) != 0;
        }
    }

    private static class CustomCodec
    extends TypeCodec<ByteBuffer> {
        private CustomCodec(DataType custom) {
            super(custom, ByteBuffer.class);
            assert (custom.getName() == DataType.Name.CUSTOM);
        }

        @Override
        public ByteBuffer parse(String value) {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value);
        }

        @Override
        public String format(ByteBuffer value) {
            if (value == null) {
                return "NULL";
            }
            return Bytes.toHexString(value);
        }

        @Override
        public ByteBuffer serialize(ByteBuffer value, ProtocolVersion protocolVersion) {
            return value == null ? null : value.duplicate();
        }

        @Override
        public ByteBuffer deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null ? null : bytes.duplicate();
        }
    }

    private static class BlobCodec
    extends TypeCodec<ByteBuffer> {
        private static final BlobCodec instance = new BlobCodec();

        private BlobCodec() {
            super(DataType.blob(), ByteBuffer.class);
        }

        @Override
        public ByteBuffer parse(String value) {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value);
        }

        @Override
        public String format(ByteBuffer value) {
            if (value == null) {
                return "NULL";
            }
            return Bytes.toHexString(value);
        }

        @Override
        public ByteBuffer serialize(ByteBuffer value, ProtocolVersion protocolVersion) {
            return value == null ? null : value.duplicate();
        }

        @Override
        public ByteBuffer deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null ? null : bytes.duplicate();
        }
    }

    private static class CounterCodec
    extends LongCodec {
        private static final CounterCodec instance = new CounterCodec();

        private CounterCodec() {
            super(DataType.counter());
        }
    }

    private static class BigintCodec
    extends LongCodec {
        private static final BigintCodec instance = new BigintCodec();

        private BigintCodec() {
            super(DataType.bigint());
        }
    }

    private static abstract class LongCodec
    extends PrimitiveLongCodec {
        private LongCodec(DataType cqlType) {
            super(cqlType);
        }

        @Override
        public int serializedSize() {
            return 8;
        }

        @Override
        public Long parse(String value) {
            try {
                return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Long.valueOf(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 64-bits long value from \"%s\"", value));
            }
        }

        @Override
        public String format(Long value) {
            if (value == null) {
                return "NULL";
            }
            return Long.toString(value);
        }

        @Override
        public ByteBuffer serializeNoBoxing(long value, ProtocolVersion protocolVersion) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(0, value);
            return bb;
        }

        @Override
        public long deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0L;
            }
            if (bytes.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits long value, expecting 8 bytes but got " + bytes.remaining());
            }
            return bytes.getLong(bytes.position());
        }
    }

    private static class AsciiCodec
    extends StringCodec {
        private static final AsciiCodec instance = new AsciiCodec();
        private static final Pattern ASCII_PATTERN = Pattern.compile("^\\p{ASCII}*$");

        private AsciiCodec() {
            super(DataType.ascii(), Charset.forName("US-ASCII"));
        }

        @Override
        public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) {
            if (value != null && !ASCII_PATTERN.matcher(value).matches()) {
                throw new InvalidTypeException(String.format("%s is not a valid ASCII String", value));
            }
            return super.serialize(value, protocolVersion);
        }

        @Override
        public String format(String value) {
            if (value != null && !ASCII_PATTERN.matcher(value).matches()) {
                throw new InvalidTypeException(String.format("%s is not a valid ASCII String", value));
            }
            return super.format(value);
        }
    }

    private static class VarcharCodec
    extends StringCodec {
        private static final VarcharCodec instance = new VarcharCodec();

        private VarcharCodec() {
            super(DataType.varchar(), Charset.forName("UTF-8"));
        }
    }

    private static abstract class StringCodec
    extends TypeCodec<String> {
        private final Charset charset;

        private StringCodec(DataType cqlType, Charset charset) {
            super(cqlType, String.class);
            this.charset = charset;
        }

        @Override
        public String parse(String value) {
            if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value)) {
                throw new InvalidTypeException("text or varchar values must be enclosed by single quotes");
            }
            return ParseUtils.unquote(value);
        }

        @Override
        public String format(String value) {
            if (value == null) {
                return "NULL";
            }
            return ParseUtils.quote(value);
        }

        @Override
        public ByteBuffer serialize(String value, ProtocolVersion protocolVersion) {
            return value == null ? null : ByteBuffer.wrap(value.getBytes(this.charset));
        }

        @Override
        public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            if (bytes == null) {
                return null;
            }
            if (bytes.remaining() == 0) {
                return "";
            }
            return new String(Bytes.getArray(bytes), this.charset);
        }
    }

    public static abstract class PrimitiveDoubleCodec
    extends TypeCodec<Double> {
        PrimitiveDoubleCodec(DataType cqlType) {
            super(cqlType, Double.class);
        }

        public abstract ByteBuffer serializeNoBoxing(double var1, ProtocolVersion var3);

        public abstract double deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Double value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value, protocolVersion);
        }

        @Override
        public Double deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Double.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    public static abstract class PrimitiveFloatCodec
    extends TypeCodec<Float> {
        PrimitiveFloatCodec(DataType cqlType) {
            super(cqlType, Float.class);
        }

        public abstract ByteBuffer serializeNoBoxing(float var1, ProtocolVersion var2);

        public abstract float deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Float value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value.floatValue(), protocolVersion);
        }

        @Override
        public Float deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Float.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    public static abstract class PrimitiveLongCodec
    extends TypeCodec<Long> {
        PrimitiveLongCodec(DataType cqlType) {
            super(cqlType, Long.class);
        }

        public abstract ByteBuffer serializeNoBoxing(long var1, ProtocolVersion var3);

        public abstract long deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Long value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value, protocolVersion);
        }

        @Override
        public Long deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Long.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    public static abstract class PrimitiveIntCodec
    extends TypeCodec<Integer> {
        PrimitiveIntCodec(DataType cqlType) {
            super(cqlType, Integer.class);
        }

        public abstract ByteBuffer serializeNoBoxing(int var1, ProtocolVersion var2);

        public abstract int deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Integer value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value, protocolVersion);
        }

        @Override
        public Integer deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Integer.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    public static abstract class PrimitiveShortCodec
    extends TypeCodec<Short> {
        PrimitiveShortCodec(DataType cqlType) {
            super(cqlType, Short.class);
        }

        public abstract ByteBuffer serializeNoBoxing(short var1, ProtocolVersion var2);

        public abstract short deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Short value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value, protocolVersion);
        }

        @Override
        public Short deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Short.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    public static abstract class PrimitiveByteCodec
    extends TypeCodec<Byte> {
        PrimitiveByteCodec(DataType cqlType) {
            super(cqlType, Byte.class);
        }

        public abstract ByteBuffer serializeNoBoxing(byte var1, ProtocolVersion var2);

        public abstract byte deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Byte value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value, protocolVersion);
        }

        @Override
        public Byte deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Byte.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }

    public static abstract class PrimitiveBooleanCodec
    extends TypeCodec<Boolean> {
        PrimitiveBooleanCodec(DataType cqlType) {
            super(cqlType, Boolean.class);
        }

        public abstract ByteBuffer serializeNoBoxing(boolean var1, ProtocolVersion var2);

        public abstract boolean deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Boolean value, ProtocolVersion protocolVersion) {
            return value == null ? null : this.serializeNoBoxing(value, protocolVersion);
        }

        @Override
        public Boolean deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
            return bytes == null || bytes.remaining() == 0 ? null : Boolean.valueOf(this.deserializeNoBoxing(bytes, protocolVersion));
        }
    }
}

