/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractBufferClusteringPrefix;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public interface ClusteringBound<V>
extends ClusteringBoundOrBoundary<V> {
    public static final ClusteringBound<?> BOTTOM;
    public static final ClusteringBound<?> TOP;
    public static final ClusteringBound<?> MAX_START;
    public static final ClusteringBound<?> MIN_END;

    public static ClusteringPrefix.Kind boundKind(boolean isStart, boolean isInclusive) {
        return isStart ? (isInclusive ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND) : (isInclusive ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.EXCL_END_BOUND);
    }

    @Override
    public ClusteringBound<V> invert();

    public ClusteringBound<ByteBuffer> clone(ByteBufferCloner var1);

    default public boolean isStart() {
        return this.kind().isStart();
    }

    default public boolean isEnd() {
        return !this.isStart();
    }

    default public boolean isInclusive() {
        return this.kind() == ClusteringPrefix.Kind.INCL_START_BOUND || this.kind() == ClusteringPrefix.Kind.INCL_END_BOUND;
    }

    default public boolean isExclusive() {
        return this.kind() == ClusteringPrefix.Kind.EXCL_START_BOUND || this.kind() == ClusteringPrefix.Kind.EXCL_END_BOUND;
    }

    default public boolean isArtificial() {
        return this.kind() == ClusteringPrefix.Kind.SSTABLE_LOWER_BOUND || this.kind() == ClusteringPrefix.Kind.SSTABLE_UPPER_BOUND;
    }

    default public ClusteringBound<V> artificialLowerBound(boolean isReversed) {
        return ClusteringBound.create(!isReversed ? ClusteringPrefix.Kind.SSTABLE_LOWER_BOUND : ClusteringPrefix.Kind.SSTABLE_UPPER_BOUND, this);
    }

    public static <V> ClusteringBound<V> create(ClusteringPrefix.Kind kind, ClusteringPrefix<V> from) {
        return from.accessor().factory().bound(kind, from.getRawValues());
    }

    public static <V> ClusteringBound<V> inclusiveStartOf(ClusteringPrefix<V> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.INCL_START_BOUND, from);
    }

    public static <V> ClusteringBound<V> inclusiveEndOf(ClusteringPrefix<V> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.INCL_END_BOUND, from);
    }

    public static <V> ClusteringBound<V> exclusiveStartOf(ClusteringPrefix<V> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.EXCL_START_BOUND, from);
    }

    public static <V> ClusteringBound<V> exclusiveEndOf(ClusteringPrefix<V> from) {
        return ClusteringBound.create(ClusteringPrefix.Kind.EXCL_END_BOUND, from);
    }

    public static ClusteringBound<?> create(ClusteringComparator comparator, boolean isStart, boolean isInclusive, Object ... values) {
        CBuilder builder = CBuilder.create(comparator);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return builder.buildBound(isStart, isInclusive);
    }

    @Override
    default public ClusteringBound<V> asStartBound() {
        if (!1.$assertionsDisabled && !this.isStart()) {
            throw new AssertionError();
        }
        return this;
    }

    @Override
    default public ClusteringBound<V> asEndBound() {
        if (!1.$assertionsDisabled && !this.isEnd()) {
            throw new AssertionError();
        }
        return this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        BOTTOM = new BufferClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
        TOP = new BufferClusteringBound(ClusteringPrefix.Kind.INCL_END_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
        MAX_START = new BufferClusteringBound(ClusteringPrefix.Kind.EXCL_START_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
        MIN_END = new BufferClusteringBound(ClusteringPrefix.Kind.EXCL_END_BOUND, AbstractBufferClusteringPrefix.EMPTY_VALUES_ARRAY);
    }
}

