/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.btree.BTreeSet;

public abstract class MultiCBuilder {
    protected final ClusteringComparator comparator;
    protected int size;
    protected boolean built;
    protected boolean containsNull;
    protected boolean containsUnset;
    protected boolean hasMissingElements;

    protected MultiCBuilder(ClusteringComparator comparator) {
        this.comparator = comparator;
    }

    public static MultiCBuilder create(ClusteringComparator comparator, boolean forMultipleValues) {
        return forMultipleValues ? new MultiClusteringBuilder(comparator) : new OneClusteringBuilder(comparator);
    }

    public abstract MultiCBuilder addElementToAll(ByteBuffer var1);

    public abstract MultiCBuilder addEachElementToAll(List<ByteBuffer> var1);

    public abstract MultiCBuilder addAllElementsToAll(List<List<ByteBuffer>> var1);

    protected void checkUpdateable() {
        if (!this.hasRemaining() || this.built) {
            throw new IllegalStateException("this builder cannot be updated anymore");
        }
    }

    public int remainingCount() {
        return this.comparator.size() - this.size;
    }

    public abstract int buildSize();

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean containsUnset() {
        return this.containsUnset;
    }

    public boolean hasMissingElements() {
        return this.hasMissingElements;
    }

    public abstract NavigableSet<Clustering<?>> build();

    public abstract NavigableSet<ClusteringBound<?>> buildBoundForSlice(boolean var1, boolean var2, boolean var3, List<ColumnMetadata> var4);

    public abstract NavigableSet<ClusteringBound<?>> buildBound(boolean var1, boolean var2);

    public boolean hasRemaining() {
        return this.remainingCount() > 0;
    }

    private static class MultiClusteringBuilder
    extends MultiCBuilder {
        private final List<List<ByteBuffer>> elementsList = new ArrayList<List<ByteBuffer>>();

        public MultiClusteringBuilder(ClusteringComparator comparator) {
            super(comparator);
        }

        @Override
        public MultiCBuilder addElementToAll(ByteBuffer value) {
            this.checkUpdateable();
            if (this.elementsList.isEmpty()) {
                this.elementsList.add(new ArrayList());
            }
            if (value == null) {
                this.containsNull = true;
            } else if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                this.containsUnset = true;
            }
            int m4 = this.elementsList.size();
            for (int i = 0; i < m4; ++i) {
                this.elementsList.get(i).add(value);
            }
            ++this.size;
            return this;
        }

        @Override
        public MultiCBuilder addEachElementToAll(List<ByteBuffer> values) {
            this.checkUpdateable();
            if (this.elementsList.isEmpty()) {
                this.elementsList.add(new ArrayList());
            }
            if (values.isEmpty()) {
                this.hasMissingElements = true;
            } else {
                int m4 = this.elementsList.size();
                for (int i = 0; i < m4; ++i) {
                    List<ByteBuffer> oldComposite = this.elementsList.remove(0);
                    int n = values.size();
                    for (int j = 0; j < n; ++j) {
                        ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                        this.elementsList.add(newComposite);
                        ByteBuffer value = values.get(j);
                        if (value == null) {
                            this.containsNull = true;
                        }
                        if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                            this.containsUnset = true;
                        }
                        newComposite.add(values.get(j));
                    }
                }
            }
            ++this.size;
            return this;
        }

        @Override
        public MultiCBuilder addAllElementsToAll(List<List<ByteBuffer>> values) {
            this.checkUpdateable();
            if (this.elementsList.isEmpty()) {
                this.elementsList.add(new ArrayList());
            }
            if (values.isEmpty()) {
                this.hasMissingElements = true;
            } else {
                int m4 = this.elementsList.size();
                for (int i = 0; i < m4; ++i) {
                    List<ByteBuffer> oldComposite = this.elementsList.remove(0);
                    int n = values.size();
                    for (int j = 0; j < n; ++j) {
                        ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                        this.elementsList.add(newComposite);
                        List<ByteBuffer> value = values.get(j);
                        if (value.contains(null)) {
                            this.containsNull = true;
                        }
                        if (value.contains(ByteBufferUtil.UNSET_BYTE_BUFFER)) {
                            this.containsUnset = true;
                        }
                        newComposite.addAll(value);
                    }
                }
                this.size += values.get(0).size();
            }
            return this;
        }

        @Override
        public int buildSize() {
            return this.hasMissingElements ? 0 : this.elementsList.size();
        }

        @Override
        public NavigableSet<Clustering<?>> build() {
            this.built = true;
            if (this.hasMissingElements) {
                return BTreeSet.empty(this.comparator);
            }
            CBuilder builder = CBuilder.create(this.comparator);
            if (this.elementsList.isEmpty()) {
                return BTreeSet.of(builder.comparator(), builder.build());
            }
            BTreeSet.Builder<Clusterable> set = BTreeSet.builder(builder.comparator());
            int m4 = this.elementsList.size();
            for (int i = 0; i < m4; ++i) {
                List<ByteBuffer> elements = this.elementsList.get(i);
                set.add(builder.buildWith(elements));
            }
            return set.build();
        }

        @Override
        public NavigableSet<ClusteringBound<?>> buildBoundForSlice(boolean isStart, boolean isInclusive, boolean isOtherBoundInclusive, List<ColumnMetadata> columnDefs) {
            this.built = true;
            if (this.hasMissingElements) {
                return BTreeSet.empty(this.comparator);
            }
            CBuilder builder = CBuilder.create(this.comparator);
            if (this.elementsList.isEmpty()) {
                return BTreeSet.of(this.comparator, builder.buildBound(isStart, isInclusive));
            }
            BTreeSet.Builder<Clusterable> set = BTreeSet.builder(this.comparator);
            int offset = columnDefs.get(0).position();
            int m4 = this.elementsList.size();
            for (int i = 0; i < m4; ++i) {
                List<ByteBuffer> elements = this.elementsList.get(i);
                if (elements.size() == offset) {
                    set.add(builder.buildBoundWith(elements, isStart, true));
                    continue;
                }
                ColumnMetadata lastColumn = columnDefs.get(columnDefs.size() - 1);
                if (elements.size() <= lastColumn.position() && i < m4 - 1 && elements.equals(this.elementsList.get(i + 1))) {
                    set.add(builder.buildBoundWith(elements, isStart, false));
                    set.add(builder.buildBoundWith(this.elementsList.get(i++), isStart, true));
                    continue;
                }
                ColumnMetadata column = columnDefs.get(elements.size() - 1 - offset);
                set.add(builder.buildBoundWith(elements, isStart, column.isReversedType() ? isOtherBoundInclusive : isInclusive));
            }
            return set.build();
        }

        @Override
        public NavigableSet<ClusteringBound<?>> buildBound(boolean isStart, boolean isInclusive) {
            this.built = true;
            if (this.hasMissingElements) {
                return BTreeSet.empty(this.comparator);
            }
            CBuilder builder = CBuilder.create(this.comparator);
            if (this.elementsList.isEmpty()) {
                return BTreeSet.of(this.comparator, builder.buildBound(isStart, isInclusive));
            }
            BTreeSet.Builder<Clusterable> set = BTreeSet.builder(this.comparator);
            int m4 = this.elementsList.size();
            for (int i = 0; i < m4; ++i) {
                List<ByteBuffer> elements = this.elementsList.get(i);
                set.add(builder.buildBoundWith(elements, isStart, isInclusive));
            }
            return set.build();
        }
    }

    private static class OneClusteringBuilder
    extends MultiCBuilder {
        private final ByteBuffer[] elements;

        public OneClusteringBuilder(ClusteringComparator comparator) {
            super(comparator);
            this.elements = new ByteBuffer[comparator.size()];
        }

        @Override
        public MultiCBuilder addElementToAll(ByteBuffer value) {
            this.checkUpdateable();
            if (value == null) {
                this.containsNull = true;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                this.containsUnset = true;
            }
            this.elements[this.size++] = value;
            return this;
        }

        @Override
        public MultiCBuilder addEachElementToAll(List<ByteBuffer> values) {
            if (values.isEmpty()) {
                this.hasMissingElements = true;
                return this;
            }
            assert (values.size() == 1);
            return this.addElementToAll(values.get(0));
        }

        @Override
        public MultiCBuilder addAllElementsToAll(List<List<ByteBuffer>> values) {
            if (values.isEmpty()) {
                this.hasMissingElements = true;
                return this;
            }
            assert (values.size() == 1);
            return this.addEachElementToAll(values.get(0));
        }

        @Override
        public int buildSize() {
            return this.hasMissingElements ? 0 : 1;
        }

        @Override
        public NavigableSet<Clustering<?>> build() {
            this.built = true;
            if (this.hasMissingElements) {
                return BTreeSet.empty(this.comparator);
            }
            return BTreeSet.of(this.comparator, this.size == 0 ? Clustering.EMPTY : Clustering.make(this.elements));
        }

        @Override
        public NavigableSet<ClusteringBound<?>> buildBoundForSlice(boolean isStart, boolean isInclusive, boolean isOtherBoundInclusive, List<ColumnMetadata> columnDefs) {
            return this.buildBound(isStart, columnDefs.get(0).isReversedType() ? isOtherBoundInclusive : isInclusive);
        }

        @Override
        public NavigableSet<ClusteringBound<?>> buildBound(boolean isStart, boolean isInclusive) {
            this.built = true;
            if (this.hasMissingElements) {
                return BTreeSet.empty(this.comparator);
            }
            if (this.size == 0) {
                return BTreeSet.of(this.comparator, isStart ? BufferClusteringBound.BOTTOM : BufferClusteringBound.TOP);
            }
            ByteBuffer[] newValues = this.size == this.elements.length ? this.elements : Arrays.copyOf(this.elements, this.size);
            return BTreeSet.of(this.comparator, BufferClusteringBound.create(ClusteringBound.boundKind(isStart, isInclusive), newValues));
        }
    }
}

