/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.aggregation;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class GroupingState {
    public static final Serializer serializer = new Serializer();
    public static final GroupingState EMPTY_STATE = new GroupingState(null, null);
    private final ByteBuffer partitionKey;
    final Clustering<?> clustering;

    public GroupingState(ByteBuffer partitionKey, Clustering<?> clustering) {
        this.partitionKey = partitionKey;
        this.clustering = clustering;
    }

    public ByteBuffer partitionKey() {
        return this.partitionKey;
    }

    public Clustering<?> clustering() {
        return this.clustering;
    }

    public boolean hasClustering() {
        return this.clustering != null;
    }

    public static class Serializer {
        public void serialize(GroupingState state, DataOutputPlus out, int version, ClusteringComparator comparator) throws IOException {
            boolean hasPartitionKey = state.partitionKey != null;
            out.writeBoolean(hasPartitionKey);
            if (hasPartitionKey) {
                ByteBufferUtil.writeWithVIntLength(state.partitionKey, out);
                boolean hasClustering = state.hasClustering();
                out.writeBoolean(hasClustering);
                if (hasClustering) {
                    Clustering.serializer.serialize(state.clustering, out, version, comparator.subtypes());
                }
            }
        }

        public GroupingState deserialize(DataInputPlus in, int version, ClusteringComparator comparator) throws IOException {
            if (!in.readBoolean()) {
                return EMPTY_STATE;
            }
            ByteBuffer partitionKey = ByteBufferUtil.readWithVIntLength(in);
            Clustering<byte[]> clustering = null;
            if (in.readBoolean()) {
                clustering = Clustering.serializer.deserialize(in, version, comparator.subtypes());
            }
            return new GroupingState(partitionKey, clustering);
        }

        public long serializedSize(GroupingState state, int version, ClusteringComparator comparator) {
            boolean hasPartitionKey = state.partitionKey != null;
            long size = TypeSizes.sizeof(hasPartitionKey);
            if (hasPartitionKey) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(state.partitionKey);
                boolean hasClustering = state.hasClustering();
                size += (long)TypeSizes.sizeof(hasClustering);
                if (hasClustering) {
                    size += Clustering.serializer.serializedSize(state.clustering, version, comparator.subtypes());
                }
            }
            return size;
        }
    }
}

