/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.lifecycle.Helpers;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Interval;

public class View {
    public final List<Memtable> liveMemtables;
    public final List<Memtable> flushingMemtables;
    final Set<SSTableReader> compacting;
    final Set<SSTableReader> sstables;
    final Map<SSTableReader, SSTableReader> sstablesMap;
    final Map<SSTableReader, SSTableReader> compactingMap;
    final SSTableIntervalTree intervalTree;

    View(List<Memtable> liveMemtables, List<Memtable> flushingMemtables, Map<SSTableReader, SSTableReader> sstables, Map<SSTableReader, SSTableReader> compacting, SSTableIntervalTree intervalTree) {
        assert (liveMemtables != null);
        assert (flushingMemtables != null);
        assert (sstables != null);
        assert (compacting != null);
        assert (intervalTree != null);
        this.liveMemtables = liveMemtables;
        this.flushingMemtables = flushingMemtables;
        this.sstablesMap = sstables;
        this.sstables = this.sstablesMap.keySet();
        this.compactingMap = compacting;
        this.compacting = this.compactingMap.keySet();
        this.intervalTree = intervalTree;
    }

    public Memtable getCurrentMemtable() {
        return this.liveMemtables.get(this.liveMemtables.size() - 1);
    }

    public Iterable<Memtable> getAllMemtables() {
        return Iterables.concat(this.flushingMemtables, this.liveMemtables);
    }

    public Set<SSTableReader> liveSSTables() {
        return this.sstables;
    }

    public Iterable<SSTableReader> sstables(SSTableSet sstableSet, Predicate<SSTableReader> filter) {
        return Iterables.filter(this.select(sstableSet), filter);
    }

    @VisibleForTesting
    public Iterable<SSTableReader> allKnownSSTables() {
        return Iterables.concat(this.sstables, Helpers.filterOut(this.compacting, this.sstables));
    }

    public Iterable<SSTableReader> select(SSTableSet sstableSet) {
        switch (sstableSet) {
            case LIVE: {
                return this.sstables;
            }
            case NONCOMPACTING: {
                return Iterables.filter(this.sstables, s2 -> !this.compacting.contains(s2));
            }
            case CANONICAL: {
                HashSet<SSTableReader> canonicalSSTables = new HashSet<SSTableReader>(this.sstables.size() + this.compacting.size());
                for (SSTableReader sstable : this.compacting) {
                    if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
                    canonicalSSTables.add(sstable);
                }
                for (SSTableReader sstable : this.sstables) {
                    if (this.compacting.contains(sstable) || sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
                    canonicalSSTables.add(sstable);
                }
                return canonicalSSTables;
            }
        }
        throw new IllegalStateException();
    }

    public Iterable<SSTableReader> getUncompacting(Iterable<SSTableReader> candidates) {
        return Iterables.filter(candidates, new Predicate<SSTableReader>(){

            @Override
            public boolean apply(SSTableReader sstable) {
                return !View.this.compacting.contains(sstable);
            }
        });
    }

    public boolean isEmpty() {
        return this.sstables.isEmpty() && this.liveMemtables.size() <= 1 && this.flushingMemtables.size() == 0 && (this.liveMemtables.size() == 0 || this.liveMemtables.get(0).operationCount() == 0L);
    }

    public String toString() {
        return String.format("View(pending_count=%d, sstables=%s, compacting=%s)", this.liveMemtables.size() + this.flushingMemtables.size() - 1, this.sstables, this.compacting);
    }

    public Iterable<SSTableReader> liveSSTablesInBounds(PartitionPosition left, PartitionPosition right) {
        assert (!AbstractBounds.strictlyWrapsAround(left, right));
        if (this.intervalTree.isEmpty()) {
            return Collections.emptyList();
        }
        PartitionPosition stopInTree = right.isMinimum() ? (PartitionPosition)this.intervalTree.max() : right;
        return this.intervalTree.search(Interval.create(left, stopInTree));
    }

    public static List<SSTableReader> sstablesInBounds(PartitionPosition left, PartitionPosition right, SSTableIntervalTree intervalTree) {
        assert (!AbstractBounds.strictlyWrapsAround(left, right));
        if (intervalTree.isEmpty()) {
            return Collections.emptyList();
        }
        PartitionPosition stopInTree = right.isMinimum() ? (PartitionPosition)intervalTree.max() : right;
        return intervalTree.search(Interval.create(left, stopInTree));
    }

    public static Function<View, Iterable<SSTableReader>> selectFunction(SSTableSet sstableSet) {
        return view -> view.select(sstableSet);
    }

    public static Function<View, Iterable<SSTableReader>> select(SSTableSet sstableSet, Predicate<SSTableReader> filter) {
        return view -> view.sstables(sstableSet, filter);
    }

    public static Function<View, Iterable<SSTableReader>> select(SSTableSet sstableSet, DecoratedKey key) {
        assert (sstableSet == SSTableSet.LIVE);
        return view -> view.intervalTree.search(key);
    }

    public static Function<View, Iterable<SSTableReader>> selectLive(AbstractBounds<PartitionPosition> rowBounds) {
        return view -> view.liveSSTablesInBounds((PartitionPosition)rowBounds.left, (PartitionPosition)rowBounds.right);
    }

    static Function<View, View> updateCompacting(final Set<? extends SSTableReader> unmark, final Iterable<? extends SSTableReader> mark) {
        if (unmark.isEmpty() && Iterables.isEmpty(mark)) {
            return Functions.identity();
        }
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                assert (Iterables.all(mark, Helpers.idIn(view.sstablesMap)));
                return new View(view.liveMemtables, view.flushingMemtables, view.sstablesMap, Helpers.replace(view.compactingMap, unmark, mark), view.intervalTree);
            }
        };
    }

    static Predicate<View> permitCompacting(final Iterable<? extends SSTableReader> readers) {
        return new Predicate<View>(){

            @Override
            public boolean apply(View view) {
                for (SSTableReader reader : readers) {
                    if (!view.compacting.contains(reader) && view.sstablesMap.get(reader) == reader && !reader.isMarkedCompacted()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    static Function<View, View> updateLiveSet(final Set<SSTableReader> remove, final Collection<SSTableReader> add) {
        if (remove.isEmpty() && Iterables.isEmpty(add)) {
            return Functions.identity();
        }
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                Map<SSTableReader, SSTableReader> sstableMap = Helpers.replace(view.sstablesMap, remove, add);
                return new View(view.liveMemtables, view.flushingMemtables, sstableMap, view.compactingMap, SSTableIntervalTree.update(view.intervalTree, remove, add));
            }
        };
    }

    static Function<View, View> switchMemtable(final Memtable newMemtable) {
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                ImmutableCollection newLive = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(view.liveMemtables)).add(newMemtable)).build();
                assert (newLive.size() == view.liveMemtables.size() + 1);
                return new View((List<Memtable>)((Object)newLive), view.flushingMemtables, view.sstablesMap, view.compactingMap, view.intervalTree);
            }
        };
    }

    static Function<View, View> markFlushing(final Memtable toFlush) {
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                List<Memtable> live = view.liveMemtables;
                List<Memtable> flushing = view.flushingMemtables;
                ImmutableList<Memtable> newLive = ImmutableList.copyOf(Iterables.filter(live, Predicates.not(Predicates.equalTo(toFlush))));
                ImmutableList<Memtable> newFlushing = ImmutableList.copyOf(Iterables.concat(Iterables.filter(flushing, View.lessThan(toFlush)), ImmutableList.of(toFlush), Iterables.filter(flushing, Predicates.not(View.lessThan(toFlush)))));
                assert (newLive.size() == live.size() - 1);
                assert (newFlushing.size() == flushing.size() + 1);
                return new View(newLive, newFlushing, view.sstablesMap, view.compactingMap, view.intervalTree);
            }
        };
    }

    static Function<View, View> replaceFlushed(final Memtable memtable, final Collection<SSTableReader> flushed) {
        return new Function<View, View>(){

            @Override
            public View apply(View view) {
                ImmutableList<Memtable> flushingMemtables = ImmutableList.copyOf(Iterables.filter(view.flushingMemtables, Predicates.not(Predicates.equalTo(memtable))));
                assert (flushingMemtables.size() == view.flushingMemtables.size() - 1);
                if (flushed == null || Iterables.isEmpty(flushed)) {
                    return new View(view.liveMemtables, flushingMemtables, view.sstablesMap, view.compactingMap, view.intervalTree);
                }
                Map<SSTableReader, SSTableReader> sstableMap = Helpers.replace(view.sstablesMap, Helpers.emptySet(), flushed);
                return new View(view.liveMemtables, flushingMemtables, sstableMap, view.compactingMap, SSTableIntervalTree.update(view.intervalTree, null, flushed));
            }
        };
    }

    private static <T extends Comparable<T>> Predicate<T> lessThan(final T lessThan) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t2) {
                return t2.compareTo((Comparable)lessThan) < 0;
            }
        };
    }
}

