/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.JsonUtils;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class MapType<K, V>
extends CollectionType<Map<K, V>> {
    private static final ConcurrentHashMap<Pair<AbstractType<?>, AbstractType<?>>, MapType> instances = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Pair<AbstractType<?>, AbstractType<?>>, MapType> frozenInstances = new ConcurrentHashMap();
    private final AbstractType<K> keys;
    private final AbstractType<V> values;
    private final MapSerializer<K, V> serializer;
    private final boolean isMultiCell;

    public static MapType<?, ?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 2) {
            throw new ConfigurationException("MapType takes exactly 2 type parameters");
        }
        return MapType.getInstance(l.get(0).freeze(), l.get(1).freeze(), true);
    }

    public static <K, V> MapType<K, V> getInstance(AbstractType<K> keys, AbstractType<V> values, boolean isMultiCell) {
        ConcurrentHashMap<Pair<AbstractType<?>, AbstractType<?>>, MapType> internMap = isMultiCell ? instances : frozenInstances;
        Pair<AbstractType<K>, AbstractType<V>> p = Pair.create(keys, values);
        MapType t2 = (MapType)internMap.get(p);
        return null == t2 ? internMap.computeIfAbsent(p, k -> new MapType((AbstractType)k.left, (AbstractType)k.right, isMultiCell)) : t2;
    }

    private MapType(AbstractType<K> keys, AbstractType<V> values, boolean isMultiCell) {
        super(AbstractType.ComparisonType.CUSTOM, CollectionType.Kind.MAP);
        this.keys = keys;
        this.values = values;
        this.serializer = MapSerializer.getInstance(keys.getSerializer(), values.getSerializer(), keys.comparatorSet);
        this.isMultiCell = isMultiCell;
    }

    @Override
    public <T> boolean referencesUserType(T name, ValueAccessor<T> accessor) {
        return this.keys.referencesUserType(name, accessor) || this.values.referencesUserType(name, accessor);
    }

    public MapType<?, ?> withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        (this.isMultiCell ? instances : frozenInstances).remove(Pair.create(this.keys, this.values));
        return MapType.getInstance(this.keys.withUpdatedUserType(udt), this.values.withUpdatedUserType(udt), this.isMultiCell);
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return MapType.getInstance(this.keys.expandUserTypes(), this.values.expandUserTypes(), this.isMultiCell);
    }

    @Override
    public boolean referencesDuration() {
        return this.getValuesType().referencesDuration();
    }

    public AbstractType<K> getKeysType() {
        return this.keys;
    }

    public AbstractType<V> getValuesType() {
        return this.values;
    }

    @Override
    public AbstractType<K> nameComparator() {
        return this.keys;
    }

    @Override
    public AbstractType<V> valueComparator() {
        return this.values;
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return Arrays.asList(this.keys, this.values);
    }

    @Override
    public AbstractType<?> freeze() {
        return this.isMultiCell ? MapType.getInstance(this.keys.freeze(), this.values.freeze(), false) : this;
    }

    @Override
    public AbstractType<?> unfreeze() {
        return this.isMultiCell ? this : MapType.getInstance(this.keys, this.values, true);
    }

    @Override
    public AbstractType<?> freezeNestedMulticellTypes() {
        if (!this.isMultiCell()) {
            return this;
        }
        AbstractType<?> keyType = this.keys.isFreezable() && this.keys.isMultiCell() ? this.keys.freeze() : this.keys.freezeNestedMulticellTypes();
        AbstractType<?> valueType = this.values.isFreezable() && this.values.isMultiCell() ? this.values.freeze() : this.values.freezeNestedMulticellTypes();
        return MapType.getInstance(keyType, valueType, this.isMultiCell);
    }

    @Override
    public boolean isCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        MapType tprev = (MapType)previous;
        return this.keys.isCompatibleWith(tprev.keys) && this.values.isCompatibleWith(tprev.values);
    }

    @Override
    public boolean isValueCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        MapType tprev = (MapType)previous;
        return this.keys.isCompatibleWith(tprev.keys) && this.values.isValueCompatibleWith(tprev.values);
    }

    @Override
    public <RL, TR> int compareCustom(RL left, ValueAccessor<RL> accessorL, TR right, ValueAccessor<TR> accessorR) {
        return MapType.compareMaps(this.keys, this.values, left, accessorL, right, accessorR);
    }

    public static <TL, TR> int compareMaps(AbstractType<?> keysComparator, AbstractType<?> valuesComparator, TL left, ValueAccessor<TL> accessorL, TR right, ValueAccessor<TR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int sizeL = CollectionSerializer.readCollectionSize(left, accessorL);
        int sizeR = CollectionSerializer.readCollectionSize(right, accessorR);
        int offsetL = CollectionSerializer.sizeOfCollectionSize();
        int offsetR = CollectionSerializer.sizeOfCollectionSize();
        for (int i = 0; i < Math.min(sizeL, sizeR); ++i) {
            TL k1 = CollectionSerializer.readValue(left, accessorL, offsetL);
            offsetL += CollectionSerializer.sizeOfValue(k1, accessorL);
            TR k2 = CollectionSerializer.readValue(right, accessorR, offsetR);
            offsetR += CollectionSerializer.sizeOfValue(k2, accessorR);
            int cmp = keysComparator.compare(k1, accessorL, k2, accessorR);
            if (cmp != 0) {
                return cmp;
            }
            TL v1 = CollectionSerializer.readValue(left, accessorL, offsetL);
            offsetL += CollectionSerializer.sizeOfValue(v1, accessorL);
            TR v2 = CollectionSerializer.readValue(right, accessorR, offsetR);
            offsetR += CollectionSerializer.sizeOfValue(v2, accessorR);
            cmp = valuesComparator.compare(v1, accessorL, v2, accessorR);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(sizeL, sizeR);
    }

    @Override
    public <T> ByteSource asComparableBytes(ValueAccessor<T> accessor, T data, ByteComparable.Version version) {
        return MapType.asComparableBytesMap(this.getKeysType(), this.getValuesType(), accessor, data, version);
    }

    @Override
    public <T> T fromComparableBytes(ValueAccessor<T> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return MapType.fromComparableBytesMap(accessor, comparableBytes, version, this.getKeysType(), this.getValuesType());
    }

    static <V> ByteSource asComparableBytesMap(AbstractType<?> keysComparator, AbstractType<?> valuesComparator, ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        int offset = 0;
        int size = CollectionSerializer.readCollectionSize(data, accessor);
        offset += CollectionSerializer.sizeOfCollectionSize();
        ByteSource[] srcs = new ByteSource[size * 2];
        for (int i = 0; i < size; ++i) {
            V k = CollectionSerializer.readValue(data, accessor, offset);
            srcs[i * 2 + 0] = keysComparator.asComparableBytes(accessor, k, version);
            V v = CollectionSerializer.readValue(data, accessor, offset += CollectionSerializer.sizeOfValue(k, accessor));
            offset += CollectionSerializer.sizeOfValue(v, accessor);
            srcs[i * 2 + 1] = valuesComparator.asComparableBytes(accessor, v, version);
        }
        return ByteSource.withTerminatorMaybeLegacy(version, 0, srcs);
    }

    static <V> V fromComparableBytesMap(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version, AbstractType<?> keysComparator, AbstractType<?> valuesComparator) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        assert (version != ByteComparable.Version.LEGACY);
        ArrayList buffers = new ArrayList();
        int separator = comparableBytes.next();
        while (separator != 56) {
            buffers.add(ByteSourceInverse.nextComponentNull(separator) ? null : (Object)keysComparator.fromComparableBytes(accessor, comparableBytes, version));
            separator = comparableBytes.next();
            buffers.add(ByteSourceInverse.nextComponentNull(separator) ? null : (Object)valuesComparator.fromComparableBytes(accessor, comparableBytes, version));
            separator = comparableBytes.next();
        }
        return (V)CollectionSerializer.pack(buffers, accessor, buffers.size() / 2);
    }

    @Override
    public MapSerializer<K, V> getSerializer() {
        return this.serializer;
    }

    @Override
    protected int collectionSize(List<ByteBuffer> values) {
        return values.size() / 2;
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Arrays.asList(this.keys, this.values), ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<ByteBuffer> serializedValues(Iterator<Cell<?>> cells) {
        assert (this.isMultiCell);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        while (cells.hasNext()) {
            Cell<?> c = cells.next();
            bbs.add(c.path().get(0));
            bbs.add(c.buffer());
        }
        return bbs;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = JsonUtils.decodeJson((String)parsed);
        }
        if (!(parsed instanceof Map)) {
            throw new MarshalException(String.format("Expected a map, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        Map map = (Map)parsed;
        HashMap<Term, Term> terms = new HashMap<Term, Term>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new MarshalException("Invalid null key in map");
            }
            if (entry.getValue() == null) {
                throw new MarshalException("Invalid null value in map");
            }
            terms.put(this.keys.fromJSONObject(entry.getKey()), this.values.fromJSONObject(entry.getValue()));
        }
        return new Maps.DelayedValue(this.keys, terms);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        ByteBuffer value = buffer.duplicate();
        StringBuilder sb = new StringBuilder("{");
        int size = CollectionSerializer.readCollectionSize(value, ByteBufferAccessor.instance);
        int offset = CollectionSerializer.sizeOfCollectionSize();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ByteBuffer kv = CollectionSerializer.readValue(value, ByteBufferAccessor.instance, offset);
            offset += CollectionSerializer.sizeOfValue(kv, ByteBufferAccessor.instance);
            String key = this.keys.toJSONString(kv, protocolVersion);
            if (key.startsWith("\"")) {
                sb.append(key);
            } else {
                sb.append('\"').append(JsonUtils.quoteAsJsonString(key)).append('\"');
            }
            sb.append(": ");
            ByteBuffer vv = CollectionSerializer.readValue(value, ByteBufferAccessor.instance, offset);
            offset += CollectionSerializer.sizeOfValue(vv, ByteBufferAccessor.instance);
            sb.append(this.values.toJSONString(vv, protocolVersion));
        }
        return sb.append("}").toString();
    }

    @Override
    public void forEach(ByteBuffer input, Consumer<ByteBuffer> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return this.decompose(Collections.emptyMap());
    }
}

