/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.analyzer;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class NonTokenizingOptions {
    public static final String NORMALIZE = "normalize";
    public static final String CASE_SENSITIVE = "case_sensitive";
    public static final String ASCII = "ascii";
    private boolean caseSensitive;
    private boolean normalized;
    private boolean ascii;

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    boolean isNormalized() {
        return this.normalized;
    }

    void setAscii(boolean ascii) {
        this.ascii = ascii;
    }

    boolean isAscii() {
        return this.ascii;
    }

    void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    static boolean hasOption(String option) {
        return option.equals(NORMALIZE) || option.equals(CASE_SENSITIVE) || option.equals(ASCII);
    }

    public static NonTokenizingOptions getDefaultOptions() {
        return NonTokenizingOptions.fromMap(new HashMap<String, String>(1));
    }

    public static NonTokenizingOptions fromMap(Map<String, String> options) {
        OptionsBuilder builder = new OptionsBuilder();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            switch (entry.getKey()) {
                case "case_sensitive": {
                    boolean boolValue = NonTokenizingOptions.validateBoolean(entry.getValue(), CASE_SENSITIVE);
                    builder = builder.caseSensitive(boolValue);
                    break;
                }
                case "normalize": {
                    boolean boolValue = NonTokenizingOptions.validateBoolean(entry.getValue(), NORMALIZE);
                    builder = builder.normalized(boolValue);
                    break;
                }
                case "ascii": {
                    boolean boolValue = NonTokenizingOptions.validateBoolean(entry.getValue(), ASCII);
                    builder = builder.ascii(boolValue);
                    break;
                }
            }
        }
        return builder.build();
    }

    private static boolean validateBoolean(String value, String option) {
        if (Strings.isNullOrEmpty(value)) {
            throw new InvalidRequestException("Empty value for boolean option '" + option + "'");
        }
        if (!value.equalsIgnoreCase(Boolean.TRUE.toString()) && !value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            throw new InvalidRequestException("Illegal value for boolean option '" + option + "': " + value);
        }
        return Boolean.parseBoolean(value);
    }

    public static class OptionsBuilder {
        private boolean caseSensitive = true;
        private boolean normalized = false;
        private boolean ascii = false;

        OptionsBuilder() {
        }

        OptionsBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        OptionsBuilder ascii(boolean ascii) {
            this.ascii = ascii;
            return this;
        }

        OptionsBuilder normalized(boolean normalized) {
            this.normalized = normalized;
            return this;
        }

        public NonTokenizingOptions build() {
            NonTokenizingOptions options = new NonTokenizingOptions();
            options.setCaseSensitive(this.caseSensitive);
            options.setNormalized(this.normalized);
            options.setAscii(this.ascii);
            return options;
        }
    }
}

