/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.MessageParams;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.VectorQueryContext;
import org.apache.cassandra.index.sai.disk.IndexSearchResultIterator;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeConcatIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIntersectionIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeOrderingIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.QueryReferencingTooManyIndexesException;
import org.apache.cassandra.index.sai.plan.QueryViewBuilder;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.InsertionOrderedNavigableSet;
import org.apache.cassandra.utils.Throwables;

public class QueryController {
    final QueryContext queryContext;
    private final ColumnFamilyStore cfs;
    private final ReadCommand command;
    private final RowFilter indexFilter;
    private final List<DataRange> ranges;
    private final AbstractBounds<PartitionPosition> mergeRange;
    private final PrimaryKey.Factory keyFactory;
    private final PrimaryKey firstPrimaryKey;
    private final PrimaryKey lastPrimaryKey;
    private final int orderChunkSize;
    private final NavigableSet<Clustering<?>> nextClusterings;

    public QueryController(ColumnFamilyStore cfs, ReadCommand command, RowFilter indexFilter, QueryContext queryContext) {
        this.cfs = cfs;
        this.command = command;
        this.queryContext = queryContext;
        this.indexFilter = indexFilter;
        this.ranges = QueryController.dataRanges(command);
        DataRange first = this.ranges.get(0);
        DataRange last = this.ranges.get(this.ranges.size() - 1);
        this.mergeRange = this.ranges.size() == 1 ? first.keyRange() : first.keyRange().withNewRight((PartitionPosition)last.keyRange().right);
        this.keyFactory = new PrimaryKey.Factory(cfs.getPartitioner(), cfs.getComparator());
        this.firstPrimaryKey = this.keyFactory.create(((PartitionPosition)this.mergeRange.left).getToken());
        this.lastPrimaryKey = this.keyFactory.create(((PartitionPosition)this.mergeRange.right).getToken());
        this.orderChunkSize = CassandraRelevantProperties.SAI_VECTOR_SEARCH_ORDER_CHUNK_SIZE.getInt();
        this.nextClusterings = new InsertionOrderedNavigableSet<Clusterable>(cfs.metadata().comparator);
    }

    public PrimaryKey.Factory primaryKeyFactory() {
        return this.keyFactory;
    }

    public PrimaryKey firstPrimaryKeyInRange() {
        return this.firstPrimaryKey;
    }

    public PrimaryKey lastPrimaryKeyInRange() {
        return this.lastPrimaryKey;
    }

    public TableMetadata metadata() {
        return this.command.metadata();
    }

    public RowFilter indexFilter() {
        return this.indexFilter;
    }

    public boolean usesStrictFiltering() {
        return this.command.rowFilter().isStrict();
    }

    public List<DataRange> dataRanges() {
        return this.ranges;
    }

    @Nullable
    public StorageAttachedIndex indexFor(RowFilter.Expression expression) {
        return this.cfs.indexManager.getBestIndexFor(expression, StorageAttachedIndex.class).orElse(null);
    }

    public boolean hasAnalyzer(RowFilter.Expression expression) {
        StorageAttachedIndex index = this.indexFor(expression);
        return index != null && index.hasAnalyzer();
    }

    public UnfilteredRowIterator queryStorage(List<PrimaryKey> keys, ReadExecutionController executionController) {
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("At least one primary key is required!");
        }
        SinglePartitionReadCommand partition = SinglePartitionReadCommand.create(this.cfs.metadata(), this.command.nowInSec(), this.command.columnFilter(), RowFilter.none(), DataLimits.NONE, keys.get(0).partitionKey(), this.makeFilter(keys));
        return partition.queryMemtableAndDisk(this.cfs, executionController);
    }

    public KeyRangeIterator.Builder getIndexQueryResults(Collection<Expression> expressions) {
        expressions = expressions.stream().filter(e -> e.getIndexOperator() != Expression.IndexOperator.ANN).collect(Collectors.toList());
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(expressions, this.mergeRange).build();
        Runnable onClose = () -> queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
        KeyRangeIterator.Builder builder = this.command.rowFilter().isStrict() ? KeyRangeIntersectionIterator.builder(expressions.size(), onClose) : KeyRangeUnionIterator.builder(expressions.size(), onClose);
        try {
            this.maybeTriggerGuardrails(queryView);
            if (this.command.rowFilter().isStrict()) {
                for (QueryViewBuilder.QueryExpressionView queryExpressionView : queryView.view) {
                    builder.add(IndexSearchResultIterator.build(queryExpressionView, this.mergeRange, this.queryContext, true, () -> {}));
                }
            } else {
                KeyRangeIntersectionIterator.Builder repairedBuilder = KeyRangeIntersectionIterator.builder(expressions.size(), () -> {});
                for (QueryViewBuilder.QueryExpressionView queryExpressionView : queryView.view) {
                    Expression expression = queryExpressionView.expression;
                    ArrayList<SSTableIndex> repaired = new ArrayList<SSTableIndex>(5);
                    ArrayList<SSTableIndex> unrepaired = new ArrayList<SSTableIndex>(5);
                    for (SSTableIndex index : queryExpressionView.sstableIndexes) {
                        if (index.getSSTable().isRepaired()) {
                            repaired.add(index);
                            continue;
                        }
                        unrepaired.add(index);
                    }
                    IndexSearchResultIterator unrepairedIterator = IndexSearchResultIterator.build(expression, queryExpressionView.memtableIndexes, unrepaired, this.mergeRange, this.queryContext, true, () -> {});
                    if (unrepairedIterator.getMaxKeys() > 0L) {
                        builder.add(unrepairedIterator);
                        this.queryContext.hasUnrepairedMatches = true;
                    } else {
                        unrepairedIterator.close();
                    }
                    if (repaired.isEmpty()) continue;
                    ((KeyRangeIterator.Builder)repairedBuilder).add(IndexSearchResultIterator.build(expression, Collections.emptyList(), repaired, this.mergeRange, this.queryContext, false, () -> {}));
                }
                if (((KeyRangeIterator.Builder)repairedBuilder).rangeCount() > 0) {
                    builder.add(repairedBuilder.build());
                }
            }
        }
        catch (Throwable t2) {
            builder.cleanup();
            throw t2;
        }
        return builder;
    }

    private void maybeTriggerGuardrails(QueryViewBuilder.QueryView queryView) {
        int referencedIndexes = 0;
        for (QueryViewBuilder.QueryExpressionView expressionSSTables : queryView.view) {
            referencedIndexes = Math.max(referencedIndexes, expressionSSTables.sstableIndexes.size());
        }
        if (Guardrails.saiSSTableIndexesPerQuery.failsOn(referencedIndexes, null)) {
            String msg = String.format("Query %s attempted to read from too many indexes (%s) but max allowed is %s; query aborted (see sai_sstable_indexes_per_query_fail_threshold)", this.command.toCQLString(), referencedIndexes, Guardrails.CONFIG_PROVIDER.getOrCreate(null).getSaiSSTableIndexesPerQueryFailThreshold());
            Tracing.trace(msg);
            MessageParams.add(ParamType.TOO_MANY_REFERENCED_INDEXES_FAIL, referencedIndexes);
            throw new QueryReferencingTooManyIndexesException(msg);
        }
        if (Guardrails.saiSSTableIndexesPerQuery.warnsOn(referencedIndexes, null)) {
            MessageParams.add(ParamType.TOO_MANY_REFERENCED_INDEXES_WARN, referencedIndexes);
        }
    }

    public boolean doesNotSelect(PrimaryKey key) {
        return key.kind() == PrimaryKey.Kind.WIDE && !this.command.clusteringIndexFilter(key.partitionKey()).selects(key.clustering());
    }

    public KeyRangeIterator getTopKRows(RowFilter.Expression expression) {
        assert (expression.operator() == Operator.ANN);
        StorageAttachedIndex index = this.indexFor(expression);
        assert (index != null);
        Expression planExpression = Expression.create(index).add(Operator.ANN, expression.getIndexValue().duplicate());
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(Collections.singleton(planExpression), this.mergeRange).build();
        Runnable onClose = () -> queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
        try {
            List<KeyRangeIterator> memtableResults = queryView.view.stream().map(v -> v.memtableIndexes).flatMap(Collection::stream).map(idx -> idx.search(this.queryContext, planExpression, this.mergeRange)).collect(Collectors.toList());
            List<KeyRangeIterator> sstableIntersections = queryView.view.stream().map(this::createRowIdIterator).collect(Collectors.toList());
            return IndexSearchResultIterator.build(sstableIntersections, memtableResults, queryView.referencedIndexes, this.queryContext, onClose);
        }
        catch (Throwable t2) {
            onClose.run();
            throw t2;
        }
    }

    public KeyRangeIterator getTopKRows(KeyRangeIterator source, RowFilter.Expression expression) {
        return new KeyRangeOrderingIterator(source, this.orderChunkSize, list -> this.getTopKRows((List<PrimaryKey>)list, expression));
    }

    private KeyRangeIterator getTopKRows(List<PrimaryKey> rawSourceKeys, RowFilter.Expression expression) {
        VectorQueryContext vectorQueryContext = this.queryContext.vectorContext();
        List sourceKeys = rawSourceKeys.stream().filter(vectorQueryContext::shouldInclude).collect(Collectors.toList());
        StorageAttachedIndex index = this.indexFor(expression);
        assert (index != null) : "Cannot do ANN ordering on an unindexed column";
        Expression planExpression = Expression.create(index);
        planExpression.add(Operator.ANN, expression.getIndexValue().duplicate());
        QueryViewBuilder.QueryView queryView = new QueryViewBuilder(Collections.singleton(planExpression), this.mergeRange).build();
        Runnable onClose = () -> queryView.referencedIndexes.forEach(SSTableIndex::releaseQuietly);
        try {
            List<KeyRangeIterator> memtableResults = queryView.view.stream().map(v -> v.memtableIndexes).flatMap(Collection::stream).map(idx -> idx.limitToTopResults(sourceKeys, planExpression, vectorQueryContext.limit())).collect(Collectors.toList());
            List<KeyRangeIterator> sstableIntersections = queryView.view.stream().flatMap(pair -> pair.sstableIndexes.stream()).map(idx -> {
                try {
                    return idx.limitToTopKResults(this.queryContext, sourceKeys, planExpression);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).collect(Collectors.toList());
            return IndexSearchResultIterator.build(sstableIntersections, memtableResults, queryView.referencedIndexes, this.queryContext, onClose);
        }
        catch (Throwable t2) {
            onClose.run();
            throw t2;
        }
    }

    private KeyRangeIterator createRowIdIterator(QueryViewBuilder.QueryExpressionView indexExpression) {
        List<KeyRangeIterator> subIterators = indexExpression.sstableIndexes.stream().map(index -> {
            try {
                List<KeyRangeIterator> iterators = index.search(indexExpression.expression, this.mergeRange, this.queryContext);
                return KeyRangeConcatIterator.builder(iterators.size()).add(iterators).build();
            }
            catch (Throwable ex) {
                throw Throwables.cleaned(ex);
            }
        }).collect(Collectors.toList());
        return KeyRangeUnionIterator.build(subIterators);
    }

    private ClusteringIndexFilter makeFilter(List<PrimaryKey> keys) {
        PrimaryKey firstKey = keys.get(0);
        assert (this.cfs.metadata().comparator.size() == 0 && !firstKey.kind().hasClustering || this.cfs.metadata().comparator.size() > 0 && firstKey.kind().hasClustering) : "PrimaryKey " + firstKey + " clustering does not match table. There should be a clustering of size " + this.cfs.metadata().comparator.size();
        ClusteringIndexFilter clusteringIndexFilter = this.command.clusteringIndexFilter(firstKey.partitionKey());
        if (this.cfs.metadata().comparator.size() == 0 || firstKey.kind() == PrimaryKey.Kind.STATIC) {
            return clusteringIndexFilter;
        }
        this.nextClusterings.clear();
        for (PrimaryKey key : keys) {
            this.nextClusterings.add(key.clustering());
        }
        return new ClusteringIndexNamesFilter(this.nextClusterings, clusteringIndexFilter.isReversed());
    }

    private static List<DataRange> dataRanges(ReadCommand command) {
        if (command instanceof SinglePartitionReadCommand) {
            return Lists.newArrayList(command.dataRange());
        }
        if (command instanceof PartitionRangeReadCommand) {
            return Lists.newArrayList(command.dataRange());
        }
        throw new AssertionError((Object)("Unsupported read command type: " + command.getClass().getName()));
    }
}

