/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.Throwables;

public class ReducingKeyIterator
implements CloseableIterator<DecoratedKey> {
    private final ArrayList<KeyIterator> iters;
    private volatile IMergeIterator<DecoratedKey, DecoratedKey> mi;

    public ReducingKeyIterator(Collection<SSTableReader> sstables) {
        this.iters = new ArrayList(sstables.size());
        for (SSTableReader sstable : sstables) {
            try {
                this.iters.add(sstable.keyIterator());
            }
            catch (IOException ex) {
                this.iters.forEach(FileUtils::closeQuietly);
                throw new RuntimeException("Failed to create a key iterator for sstable " + sstable.getFilename());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInit() {
        if (this.mi != null) {
            return;
        }
        ReducingKeyIterator reducingKeyIterator = this;
        synchronized (reducingKeyIterator) {
            if (this.mi == null) {
                this.mi = MergeIterator.get(this.iters, DecoratedKey.comparator, new MergeIterator.Reducer<DecoratedKey, DecoratedKey>(){
                    DecoratedKey reduced = null;

                    @Override
                    public boolean trivialReduceIsTrivial() {
                        return true;
                    }

                    @Override
                    public void reduce(int idx, DecoratedKey current) {
                        this.reduced = current;
                    }

                    @Override
                    protected DecoratedKey getReduced() {
                        return this.reduced;
                    }
                });
            }
        }
    }

    @Override
    public void close() {
        if (this.mi != null) {
            this.mi.close();
        } else {
            Throwable err = Throwables.close(null, this.iters);
            if (err != null) {
                throw Throwables.unchecked(err);
            }
        }
    }

    public long getTotalBytes() {
        this.maybeInit();
        long m4 = 0L;
        for (Iterator<DecoratedKey> iter2 : this.mi.iterators()) {
            m4 += ((KeyIterator)iter2).getTotalBytes();
        }
        return m4;
    }

    public long getBytesRead() {
        this.maybeInit();
        long m4 = 0L;
        for (Iterator<DecoratedKey> iter2 : this.mi.iterators()) {
            m4 += ((KeyIterator)iter2).getBytesRead();
        }
        return m4;
    }

    @Override
    public boolean hasNext() {
        this.maybeInit();
        return this.mi.hasNext();
    }

    @Override
    public DecoratedKey next() {
        this.maybeInit();
        return (DecoratedKey)this.mi.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

