/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.sstable.IScrubber;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SortedTableScrubber;
import org.apache.cassandra.io.sstable.format.bti.BtiFormat;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.ScrubPartitionIterator;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Throwables;

public class BtiTableScrubber
extends SortedTableScrubber<BtiTableReader>
implements IScrubber {
    private final boolean isIndex;
    private final AbstractType<?> partitionKeyType;
    private ScrubPartitionIterator indexIterator;

    public BtiTableScrubber(ColumnFamilyStore cfs, LifecycleTransaction transaction, OutputHandler outputHandler, IScrubber.Options options) {
        super(cfs, transaction, outputHandler, options);
        boolean hasIndexFile = ((BtiTableReader)this.sstable).getComponents().contains(BtiFormat.Components.PARTITION_INDEX);
        this.isIndex = cfs.isIndex();
        this.partitionKeyType = cfs.metadata.get().partitionKeyType;
        if (!hasIndexFile) {
            outputHandler.warn("Missing index component");
        }
        try {
            this.indexIterator = hasIndexFile ? this.openIndexIterator() : null;
        }
        catch (RuntimeException ex) {
            outputHandler.warn("Detected corruption in the index file - cannot open index iterator", ex);
        }
    }

    private ScrubPartitionIterator openIndexIterator() {
        try {
            return ((BtiTableReader)this.sstable).scrubPartitionsIterator();
        }
        catch (Throwable t2) {
            this.outputHandler.warn(t2, "Index is unreadable, scrubbing will continue without index.");
            return null;
        }
    }

    @Override
    protected UnfilteredRowIterator withValidation(UnfilteredRowIterator iter2, String filename) {
        return this.options.checkData && !this.isIndex ? UnfilteredRowIterators.withValidation(iter2, filename) : iter2;
    }

    @Override
    public void scrubInternal(SSTableRewriter writer) {
        if (this.indexAvailable() && this.indexIterator.dataPosition() != 0L) {
            this.outputHandler.warn("First position reported by index should be 0, was " + this.indexIterator.dataPosition() + ", continuing without index.");
            this.indexIterator.close();
            this.indexIterator = null;
        }
        DecoratedKey prevKey = null;
        while (!this.dataFile.isEOF()) {
            if (this.scrubInfo.isStopRequested()) {
                throw new CompactionInterruptedException(this.scrubInfo.getCompactionInfo());
            }
            long dataStart = this.dataFile.getFilePointer();
            this.outputHandler.debug("Reading row at %d", dataStart);
            DecoratedKey key = null;
            Throwable keyReadError = null;
            try {
                ByteBuffer raw = ByteBufferUtil.readWithShortLength(this.dataFile);
                if (!this.isIndex) {
                    this.partitionKeyType.validate(raw);
                }
                key = ((BtiTableReader)this.sstable).decorateKey(raw);
            }
            catch (Throwable th) {
                keyReadError = th;
                BtiTableScrubber.throwIfFatal(th);
            }
            long dataStartFromIndex = -1L;
            long dataSizeFromIndex = -1L;
            ByteBuffer currentIndexKey = null;
            if (this.indexAvailable()) {
                currentIndexKey = this.indexIterator.key();
                dataStartFromIndex = this.indexIterator.dataPosition();
                if (!this.indexIterator.isExhausted()) {
                    try {
                        this.indexIterator.advance();
                        if (!this.indexIterator.isExhausted()) {
                            dataSizeFromIndex = this.indexIterator.dataPosition() - dataStartFromIndex;
                        }
                    }
                    catch (Throwable th) {
                        BtiTableScrubber.throwIfFatal(th);
                        this.outputHandler.warn(th, "Failed to advance to the next index position. Index is corrupted. Continuing without the index. Last position read is %d.", this.indexIterator.dataPosition());
                        this.indexIterator.close();
                        this.indexIterator = null;
                        currentIndexKey = null;
                        dataStartFromIndex = -1L;
                        dataSizeFromIndex = -1L;
                    }
                }
            }
            String keyName = key == null ? "(unreadable key)" : this.keyString(key);
            this.outputHandler.debug("partition %s is %s", keyName, FBUtilities.prettyPrintMemory(dataSizeFromIndex));
            try {
                if (key == null) {
                    throw new IOError(new IOException("Unable to read partition key from data file", keyReadError));
                }
                if (currentIndexKey != null && !key.getKey().equals(currentIndexKey)) {
                    throw new IOError(new IOException(String.format("Key from data file (%s) does not match key from index file (%s)", ByteBufferUtil.bytesToHex(key.getKey()), ByteBufferUtil.bytesToHex(currentIndexKey))));
                }
                if (this.indexIterator != null && dataSizeFromIndex > this.dataFile.length()) {
                    throw new IOError(new IOException("Impossible partition size (greater than file length): " + dataSizeFromIndex));
                }
                if (this.indexIterator != null && dataStart != dataStartFromIndex) {
                    this.outputHandler.warn("Data file partition position %d differs from index file row position %d", dataStart, dataStartFromIndex);
                }
                if (!this.tryAppend(prevKey, key, writer)) continue;
                prevKey = key;
            }
            catch (Throwable th) {
                BtiTableScrubber.throwIfFatal(th);
                this.outputHandler.warn(th, "Error reading partition %s (stacktrace follows):", keyName);
                if (!(currentIndexKey == null || key != null && key.getKey().equals(currentIndexKey) && dataStart == dataStartFromIndex)) {
                    long rowStartFromIndex = dataStartFromIndex + 2L + (long)currentIndexKey.remaining();
                    this.outputHandler.output("Retrying from partition index; data is %s bytes starting at %s", dataSizeFromIndex, rowStartFromIndex);
                    key = ((BtiTableReader)this.sstable).decorateKey(currentIndexKey);
                    try {
                        if (!this.isIndex) {
                            this.partitionKeyType.validate(key.getKey());
                        }
                        this.dataFile.seek(rowStartFromIndex);
                        if (!this.tryAppend(prevKey, key, writer)) continue;
                        prevKey = key;
                        continue;
                    }
                    catch (Throwable th2) {
                        BtiTableScrubber.throwIfFatal(th2);
                        this.throwIfCannotContinue(key, th2);
                        this.outputHandler.warn(th2, "Retry failed too. Skipping to next partition (retry's stacktrace follows)");
                        ++this.badPartitions;
                        if (this.seekToNextPartition()) continue;
                        break;
                    }
                }
                this.throwIfCannotContinue(key, th);
                ++this.badPartitions;
                if (this.indexIterator != null) {
                    this.outputHandler.warn("Partition starting at position %d is unreadable; skipping to next", dataStart);
                    if (this.seekToNextPartition()) continue;
                    break;
                }
                this.outputHandler.warn("Unrecoverable error while scrubbing %s.Scrubbing cannot continue. The sstable will be marked for deletion. You can attempt manual recovery from the pre-scrub snapshot. You can also run nodetool repair to transfer the data from a healthy replica, if any.", this.sstable);
                break;
            }
        }
    }

    private boolean indexAvailable() {
        return this.indexIterator != null && !this.indexIterator.isExhausted();
    }

    private boolean seekToNextPartition() {
        while (this.indexAvailable()) {
            long nextRowPositionFromIndex = this.indexIterator.dataPosition();
            try {
                this.dataFile.seek(nextRowPositionFromIndex);
                return true;
            }
            catch (Throwable th) {
                BtiTableScrubber.throwIfFatal(th);
                this.outputHandler.warn(th, "Failed to seek to next row position %d", nextRowPositionFromIndex);
                ++this.badPartitions;
                try {
                    this.indexIterator.advance();
                }
                catch (Throwable th2) {
                    this.outputHandler.warn(th2, "Failed to go to the next entry in index");
                    throw Throwables.cleaned(th2);
                }
            }
        }
        return false;
    }

    @Override
    protected void throwIfCannotContinue(DecoratedKey key, Throwable th) {
        if (this.isIndex) {
            this.outputHandler.warn("An error occurred while scrubbing the partition with key '%s' for an index table. Scrubbing will abort for this table and the index will be rebuilt.", this.keyString(key));
            throw new IOError(th);
        }
        super.throwIfCannotContinue(key, th);
    }

    @Override
    public void close() {
        this.fileAccessLock.writeLock().lock();
        try {
            FileUtils.closeQuietly(this.dataFile);
            FileUtils.closeQuietly(this.indexIterator);
        }
        finally {
            this.fileAccessLock.writeLock().unlock();
        }
    }
}

