/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndexEarly;
import org.apache.cassandra.io.tries.IncrementalTrieWriter;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

class PartitionIndexBuilder
implements AutoCloseable {
    private final SequentialWriter writer;
    private final IncrementalTrieWriter<PartitionIndex.Payload> trieWriter;
    private final FileHandle.Builder fhBuilder;
    private long dataSyncPosition;
    private long rowIndexSyncPosition;
    private long partitionIndexSyncPosition;
    private long partialIndexDataEnd;
    private long partialIndexRowEnd;
    private long partialIndexPartitionEnd;
    private IncrementalTrieWriter.PartialTail partialIndexTail;
    private Consumer<PartitionIndex> partialIndexConsumer;
    private DecoratedKey partialIndexLastKey;
    private int lastDiffPoint;
    private DecoratedKey firstKey;
    private DecoratedKey lastKey;
    private DecoratedKey lastWrittenKey;
    private PartitionIndex.Payload lastPayload;

    public PartitionIndexBuilder(SequentialWriter writer, FileHandle.Builder fhBuilder) {
        this.writer = writer;
        this.trieWriter = IncrementalTrieWriter.open(PartitionIndex.TRIE_SERIALIZER, writer);
        this.fhBuilder = fhBuilder;
    }

    public void markPartitionIndexSynced(long upToPosition) {
        this.partitionIndexSyncPosition = upToPosition;
        this.refreshReadableBoundary();
    }

    public void markRowIndexSynced(long upToPosition) {
        this.rowIndexSyncPosition = upToPosition;
        this.refreshReadableBoundary();
    }

    public void markDataSynced(long upToPosition) {
        this.dataSyncPosition = upToPosition;
        this.refreshReadableBoundary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshReadableBoundary() {
        if (this.partialIndexConsumer == null) {
            return;
        }
        if (this.dataSyncPosition < this.partialIndexDataEnd) {
            return;
        }
        if (this.rowIndexSyncPosition < this.partialIndexRowEnd) {
            return;
        }
        if (this.partitionIndexSyncPosition < this.partialIndexPartitionEnd) {
            return;
        }
        try (FileHandle fh = this.fhBuilder.withLengthOverride(this.writer.getLastFlushOffset()).complete();){
            PartitionIndexEarly pi = new PartitionIndexEarly(fh, this.partialIndexTail.root(), this.partialIndexTail.count(), this.firstKey, this.partialIndexLastKey, this.partialIndexTail.cutoff(), this.partialIndexTail.tail());
            this.partialIndexConsumer.accept(pi);
            this.partialIndexConsumer = null;
        }
        finally {
            this.fhBuilder.withLengthOverride(-1L);
        }
    }

    public void addEntry(DecoratedKey decoratedKey, long position) throws IOException {
        if (this.lastKey == null) {
            this.firstKey = decoratedKey;
            this.lastDiffPoint = 0;
        } else {
            int diffPoint = ByteComparable.diffPoint(this.lastKey, decoratedKey, Walker.BYTE_COMPARABLE_VERSION);
            ByteComparable prevPrefix = ByteComparable.cut(this.lastKey, Math.max(diffPoint, this.lastDiffPoint));
            this.trieWriter.add(prevPrefix, this.lastPayload);
            this.lastWrittenKey = this.lastKey;
            this.lastDiffPoint = diffPoint;
        }
        this.lastKey = decoratedKey;
        this.lastPayload = new PartitionIndex.Payload(position, decoratedKey.filterHashLowerBits());
    }

    public long complete() throws IOException {
        this.partialIndexConsumer = null;
        if (this.lastKey != this.lastWrittenKey) {
            ByteComparable prevPrefix = ByteComparable.cut(this.lastKey, this.lastDiffPoint);
            this.trieWriter.add(prevPrefix, this.lastPayload);
        }
        long root = this.trieWriter.complete();
        long count = this.trieWriter.count();
        long firstKeyPos = this.writer.position();
        if (this.firstKey != null) {
            ByteBufferUtil.writeWithShortLength(this.firstKey.getKey(), this.writer);
            ByteBufferUtil.writeWithShortLength(this.lastKey.getKey(), this.writer);
        } else {
            assert (this.lastKey == null);
            this.writer.writeShort(0);
            this.writer.writeShort(0);
        }
        this.writer.writeLong(firstKeyPos);
        this.writer.writeLong(count);
        this.writer.writeLong(root);
        this.writer.sync();
        this.fhBuilder.withLengthOverride(this.writer.getLastFlushOffset());
        return root;
    }

    public boolean buildPartial(Consumer<PartitionIndex> callWhenReady, long rowIndexEnd, long dataEnd) {
        if (this.lastWrittenKey == this.partialIndexLastKey) {
            return false;
        }
        if (this.partialIndexConsumer != null) {
            return false;
        }
        try {
            this.partialIndexTail = this.trieWriter.makePartialRoot();
            this.partialIndexDataEnd = dataEnd;
            this.partialIndexRowEnd = rowIndexEnd;
            this.partialIndexPartitionEnd = this.writer.position();
            this.partialIndexLastKey = this.lastWrittenKey;
            this.partialIndexConsumer = callWhenReady;
            return true;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void close() {
        this.trieWriter.close();
    }
}

