/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.MinMaxAvgMetric;
import org.apache.cassandra.metrics.TableMetrics;

public class TrieMemtableMetricsView {
    private static final String UNCONTENDED_PUTS = "Uncontended memtable puts";
    private static final String CONTENDED_PUTS = "Contended memtable puts";
    private static final String CONTENTION_TIME = "Contention time";
    private static final String LAST_FLUSH_SHARD_SIZES = "Shard sizes during last flush";
    public final Counter uncontendedPuts;
    public final Counter contendedPuts;
    public final LatencyMetrics contentionTime;
    public final MinMaxAvgMetric lastFlushShardDataSizes;
    private final TrieMemtableMetricNameFactory factory;

    public TrieMemtableMetricsView(String keyspace, String table) {
        this.factory = new TrieMemtableMetricNameFactory(keyspace, table);
        this.uncontendedPuts = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(UNCONTENDED_PUTS));
        this.contendedPuts = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(CONTENDED_PUTS));
        this.contentionTime = new LatencyMetrics(this.factory, CONTENTION_TIME);
        this.lastFlushShardDataSizes = new MinMaxAvgMetric(this.factory, LAST_FLUSH_SHARD_SIZES);
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(UNCONTENDED_PUTS));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(CONTENDED_PUTS));
        this.contentionTime.release();
        this.lastFlushShardDataSizes.release();
    }

    static class TrieMemtableMetricNameFactory
    implements MetricNameFactory {
        private final String keyspace;
        private final String table;

        TrieMemtableMetricNameFactory(String keyspace, String table) {
            this.keyspace = keyspace;
            this.table = table;
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            String type = "TrieMemtable";
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",keyspace=").append(this.keyspace);
            mbeanName.append(",scope=").append(this.table);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, type, metricName, this.keyspace + "." + this.table, mbeanName.toString());
        }
    }
}

