/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.schema.SchemaAnnouncementDiagnostics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPushVerbHandler
implements IVerbHandler<Collection<Mutation>> {
    public static final SchemaPushVerbHandler instance = new SchemaPushVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(SchemaPushVerbHandler.class);
    private final List<Consumer<Message<Collection<Mutation>>>> handlers = new CopyOnWriteArrayList<Consumer<Message<Collection<Mutation>>>>();

    public void register(Consumer<Message<Collection<Mutation>>> handler) {
        this.handlers.add(handler);
    }

    @Override
    public void doVerb(Message<Collection<Mutation>> message) {
        logger.trace("Received schema push request from {}", (Object)message.from());
        SchemaAnnouncementDiagnostics.schemataMutationsReceived(message.from());
        List<Consumer<Message<Collection<Mutation>>>> handlers = this.handlers;
        if (handlers.isEmpty()) {
            throw new UnsupportedOperationException("There is no handler registered for schema push verb");
        }
        handlers.forEach(h2 -> h2.accept(message));
    }
}

