/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Predicate;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.transport.CQLMessageHandler;
import org.apache.cassandra.transport.ClientResourceLimits;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.ExceptionHandlers;
import org.apache.cassandra.transport.Flusher;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.QueueBackpressure;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreV5Handlers {
    private static ProtocolVersion getConnectionVersion(ChannelHandlerContext ctx) {
        Connection connection = ctx.channel().attr(Connection.attributeKey).get();
        return connection == null ? ProtocolVersion.CURRENT : connection.getVersion();
    }

    @ChannelHandler.Sharable
    public static final class ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
        public static final ExceptionHandler instance = new ExceptionHandler();

        private ExceptionHandler() {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx.channel().isOpen()) {
                Predicate<Throwable> handler = ExceptionHandlers.getUnexpectedExceptionHandler(ctx.channel(), false);
                ErrorMessage errorMessage = ErrorMessage.fromException(cause, handler);
                ChannelFuture future = ctx.writeAndFlush(errorMessage.encode(PreV5Handlers.getConnectionVersion(ctx)));
                if (ExceptionHandler.isFatal(cause)) {
                    future.addListener(f -> ctx.close());
                }
            }
            if (DatabaseDescriptor.getClientErrorReportingExclusions().contains(ctx.channel().remoteAddress())) {
                logger.debug("Excluding client exception for {}; address contained in client_error_reporting_exclusions", (Object)ctx.channel().remoteAddress(), (Object)cause);
                return;
            }
            ExceptionHandlers.logClientNetworkingExceptions(cause, ctx.channel().remoteAddress());
            JVMStabilityInspector.inspectThrowable(cause);
        }

        private static boolean isFatal(Throwable cause) {
            return cause instanceof ProtocolException;
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolEncoder
    extends MessageToMessageEncoder<Message> {
        public static final ProtocolEncoder instance = new ProtocolEncoder();

        private ProtocolEncoder() {
        }

        @Override
        public void encode(ChannelHandlerContext ctx, Message source, List<Object> results) {
            ProtocolVersion version = PreV5Handlers.getConnectionVersion(ctx);
            results.add(source.encode(version));
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolDecoder
    extends MessageToMessageDecoder<Envelope> {
        public static final ProtocolDecoder instance = new ProtocolDecoder();

        private ProtocolDecoder() {
        }

        @Override
        public void decode(ChannelHandlerContext ctx, Envelope source, List<Object> results) {
            try {
                ProtocolVersion version = PreV5Handlers.getConnectionVersion(ctx);
                if (source.header.version != version) {
                    throw new ProtocolException(String.format("Invalid message version. Got %s but previous messages on this connection had version %s", source.header.version, version));
                }
                results.add(Message.Decoder.decodeMessage(ctx.channel(), source));
            }
            catch (Throwable ex) {
                source.release();
                throw ErrorMessage.wrap(ex, source.header.streamId);
            }
        }
    }

    public static class LegacyDispatchHandler
    extends SimpleChannelInboundHandler<Message.Request> {
        private static final Logger logger = LoggerFactory.getLogger(LegacyDispatchHandler.class);
        private final Dispatcher dispatcher;
        private final ClientResourceLimits.Allocator endpointPayloadTracker;
        private final QueueBackpressure queueBackpressure;
        private long channelPayloadBytesInFlight;
        private ClientResourceLimits.Overload backpressure = ClientResourceLimits.Overload.NONE;

        LegacyDispatchHandler(Dispatcher dispatcher, QueueBackpressure queueBackpressure, ClientResourceLimits.Allocator endpointPayloadTracker) {
            this.dispatcher = dispatcher;
            this.queueBackpressure = queueBackpressure;
            this.endpointPayloadTracker = endpointPayloadTracker;
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, Message.Request request) {
            this.checkLimits(ctx, request);
            this.dispatcher.dispatch(ctx.channel(), request, this::toFlushItem, this.backpressure);
        }

        private Flusher.FlushItem.Unframed toFlushItem(Channel channel, Message.Request request, Message.Response response) {
            return new Flusher.FlushItem.Unframed(channel, response, request.getSource(), this::releaseItem);
        }

        private void releaseItem(Flusher.FlushItem<Message.Response> item) {
            long itemSize = item.request.header.bodySizeInBytes;
            item.request.release();
            this.channelPayloadBytesInFlight -= itemSize;
            boolean globalInFlightBytesBelowLimit = this.endpointPayloadTracker.release(itemSize) == ResourceLimits.Outcome.BELOW_LIMIT;
            ChannelConfig config = item.channel.config();
            if (this.backpressure == ClientResourceLimits.Overload.BYTES_IN_FLIGHT && (this.channelPayloadBytesInFlight == 0L || globalInFlightBytesBelowLimit)) {
                this.unpauseConnection(config);
            }
        }

        private void checkLimits(ChannelHandlerContext ctx, Message.Request request) {
            long requestSize = request.getSource().header.bodySizeInBytes;
            if (request.connection.isThrowOnOverload()) {
                if (this.endpointPayloadTracker.tryAllocate(requestSize) != ResourceLimits.Outcome.SUCCESS) {
                    this.discardAndThrow(request, requestSize, ClientResourceLimits.Overload.BYTES_IN_FLIGHT);
                }
                ClientResourceLimits.Overload backpressure = ClientResourceLimits.Overload.NONE;
                if (DatabaseDescriptor.getNativeTransportRateLimitingEnabled() && !ClientResourceLimits.GLOBAL_REQUEST_LIMITER.tryReserve()) {
                    backpressure = ClientResourceLimits.Overload.REQUESTS;
                } else if (!this.dispatcher.hasQueueCapacity()) {
                    backpressure = ClientResourceLimits.Overload.QUEUE_TIME;
                }
                if (backpressure != ClientResourceLimits.Overload.NONE) {
                    this.endpointPayloadTracker.release(requestSize);
                    this.discardAndThrow(request, requestSize, backpressure);
                }
            } else {
                this.channelPayloadBytesInFlight += requestSize;
                if (this.endpointPayloadTracker.tryAllocate(requestSize) != ResourceLimits.Outcome.SUCCESS) {
                    this.endpointPayloadTracker.allocate(requestSize);
                    this.pauseConnection(ctx);
                    this.backpressure = ClientResourceLimits.Overload.BYTES_IN_FLIGHT;
                }
                long delay = -1L;
                if (DatabaseDescriptor.getNativeTransportRateLimitingEnabled()) {
                    delay = ClientResourceLimits.GLOBAL_REQUEST_LIMITER.reserveAndGetDelay(CQLMessageHandler.RATE_LIMITER_DELAY_UNIT);
                    if (this.backpressure == ClientResourceLimits.Overload.NONE && delay > 0L) {
                        this.backpressure = ClientResourceLimits.Overload.REQUESTS;
                    }
                }
                if (this.backpressure == ClientResourceLimits.Overload.NONE && !this.dispatcher.hasQueueCapacity() && (delay = this.queueBackpressure.markAndGetDelay(CQLMessageHandler.RATE_LIMITER_DELAY_UNIT)) > 0L) {
                    this.backpressure = ClientResourceLimits.Overload.QUEUE_TIME;
                }
                if (delay > 0L) {
                    assert (this.backpressure == ClientResourceLimits.Overload.REQUESTS || this.backpressure == ClientResourceLimits.Overload.QUEUE_TIME) : this.backpressure;
                    this.pauseConnection(ctx);
                    ctx.channel().eventLoop().schedule(() -> this.unpauseConnection(ctx.channel().config()), delay, CQLMessageHandler.RATE_LIMITER_DELAY_UNIT);
                }
            }
        }

        private void pauseConnection(ChannelHandlerContext ctx) {
            if (ctx.channel().config().isAutoRead()) {
                ctx.channel().config().setAutoRead(false);
                ClientMetrics.instance.pauseConnection();
            }
        }

        private void unpauseConnection(ChannelConfig config) {
            this.backpressure = ClientResourceLimits.Overload.NONE;
            if (!config.isAutoRead()) {
                ClientMetrics.instance.unpauseConnection();
                config.setAutoRead(true);
            }
        }

        private void discardAndThrow(Message.Request request, long requestSize, ClientResourceLimits.Overload overload) {
            ClientMetrics.instance.markRequestDiscarded();
            logger.trace("Discarded request of size {} with {} bytes in flight on channel. {} Global rate limiter: {} Request: {}", new Object[]{requestSize, this.channelPayloadBytesInFlight, this.endpointPayloadTracker, ClientResourceLimits.GLOBAL_REQUEST_LIMITER, request});
            OverloadedException exception = CQLMessageHandler.buildOverloadedException(this.endpointPayloadTracker::toString, ClientResourceLimits.GLOBAL_REQUEST_LIMITER, overload);
            throw ErrorMessage.wrap(exception, request.getSource().header.streamId);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            this.endpointPayloadTracker.release();
            if (!ctx.channel().config().isAutoRead()) {
                ClientMetrics.instance.unpauseConnection();
            }
            ctx.fireChannelInactive();
        }
    }
}

