/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;

public interface Backoff {
    public int maxAttempts();

    public long computeWaitTime(int var1);

    public TimeUnit unit();

    public static class ExponentialBackoff
    implements Backoff {
        private final int maxAttempts;
        private final long baseSleepTimeMillis;
        private final long maxSleepMillis;
        private final DoubleSupplier randomSource;

        public ExponentialBackoff(int maxAttempts, long baseSleepTimeMillis, long maxSleepMillis, DoubleSupplier randomSource) {
            this.maxAttempts = maxAttempts;
            this.baseSleepTimeMillis = baseSleepTimeMillis;
            this.maxSleepMillis = maxSleepMillis;
            this.randomSource = randomSource;
        }

        @Override
        public int maxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public long computeWaitTime(int retryCount) {
            long baseTimeMillis = this.baseSleepTimeMillis * (1L << retryCount);
            if (baseTimeMillis <= 0L) {
                baseTimeMillis = this.maxSleepMillis;
            }
            baseTimeMillis = Math.min(baseTimeMillis, this.maxSleepMillis);
            return (long)((double)baseTimeMillis * (this.randomSource.getAsDouble() + 0.5));
        }

        @Override
        public TimeUnit unit() {
            return TimeUnit.MILLISECONDS;
        }
    }

    public static enum None implements Backoff
    {
        INSTANCE;


        @Override
        public int maxAttempts() {
            return 0;
        }

        @Override
        public long computeWaitTime(int retryCount) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TimeUnit unit() {
            throw new UnsupportedOperationException();
        }
    }
}

