/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummary;
import org.apache.cassandra.io.util.RebufferingChannelInputStream;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SummaryDbUtils {
    private SummaryDbUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Summary readSummary(@NotNull TableMetadata metadata, @NotNull SSTable ssTable) throws IOException {
        return SummaryDbUtils.readSummary(ssTable, metadata.partitioner, metadata.params.minIndexInterval, metadata.params.maxIndexInterval);
    }

    @Nullable
    public static Summary readSummary(@NotNull SSTable ssTable, IPartitioner partitioner, int minIndexInterval, int maxIndexInterval) throws IOException {
        try (InputStream in = ssTable.openSummaryStream();){
            Summary summary = SummaryDbUtils.readSummary(in, partitioner, minIndexInterval, maxIndexInterval);
            return summary;
        }
    }

    @Nullable
    static Summary readSummary(InputStream summaryStream, IPartitioner partitioner, int minIndexInterval, int maxIndexInterval) throws IOException {
        if (summaryStream == null) {
            return null;
        }
        int bufferSize = ReaderUtils.inputStreamBufferSize(summaryStream);
        try (DataInputStream is = new DataInputStream(summaryStream);){
            Summary summary;
            try (RebufferingChannelInputStream dis = new RebufferingChannelInputStream(is, bufferSize);){
                IndexSummary indexSummary = IndexSummary.serializer.deserialize((InputStream)((Object)dis), partitioner, minIndexInterval, maxIndexInterval);
                DecoratedKey firstKey = partitioner.decorateKey(ByteBufferUtil.readWithLength((DataInput)((Object)dis)));
                DecoratedKey lastKey = partitioner.decorateKey(ByteBufferUtil.readWithLength((DataInput)((Object)dis)));
                summary = new Summary(indexSummary, firstKey, lastKey);
            }
            return summary;
        }
    }

    public static long findIndexOffsetInSummary(IndexSummary summary, IPartitioner partitioner, BigInteger token) {
        return summary.getPosition(SummaryDbUtils.binarySearchSummary(summary, partitioner, token));
    }

    public static int binarySearchSummary(IndexSummary summary, IPartitioner partitioner, BigInteger token) {
        return SummaryDbUtils.binarySearchSummary(new IndexSummaryTokenList(partitioner, summary), token);
    }

    public static int binarySearchSummary(TokenList tokenList, BigInteger token) {
        int low = 0;
        int mid = tokenList.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = token.compareTo(tokenList.tokenAt(mid));
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result >= 0) break;
            high = mid - 1;
        }
        return result <= 0 ? Math.max(0, mid - 1) : mid;
    }

    public static class IndexSummaryTokenList
    implements TokenList {
        final IPartitioner partitioner;
        final IndexSummary summary;

        IndexSummaryTokenList(IPartitioner partitioner, IndexSummary summary) {
            this.partitioner = partitioner;
            this.summary = summary;
        }

        @Override
        public int size() {
            return this.summary.size();
        }

        @Override
        public BigInteger tokenAt(int index) {
            return ReaderUtils.tokenToBigInteger((Token)this.partitioner.decorateKey(ByteBuffer.wrap(this.summary.getKey(index))).getToken());
        }
    }

    public static interface TokenList {
        public int size();

        public BigInteger tokenAt(int var1);
    }

    public static class Summary {
        private final IndexSummary indexSummary;
        private final DecoratedKey firstKey;
        private final DecoratedKey lastKey;

        Summary(IndexSummary indexSummary, DecoratedKey firstKey, DecoratedKey lastKey) {
            this.indexSummary = indexSummary;
            this.firstKey = firstKey;
            this.lastKey = lastKey;
        }

        public IndexSummary summary() {
            return this.indexSummary;
        }

        public DecoratedKey first() {
            return this.firstKey;
        }

        public DecoratedKey last() {
            return this.lastKey;
        }
    }
}

