/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import okio.Okio;
import okio.Source;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.SidecarClient;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.SidecarInstanceImpl;
import org.apache.cassandra.sidecar.client.StreamBuffer;
import org.apache.cassandra.sidecar.client.StreamConsumer;
import org.apache.cassandra.sidecar.client.exception.RetriesExhaustedException;
import org.apache.cassandra.sidecar.client.request.BaseRequestTest;
import org.apache.cassandra.sidecar.client.request.RequestExecutorTest;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.common.data.RestoreJobSecrets;
import org.apache.cassandra.sidecar.common.request.ImportSSTableRequest;
import org.apache.cassandra.sidecar.common.request.NodeSettingsRequest;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.common.request.data.AllServicesConfigPayload;
import org.apache.cassandra.sidecar.common.request.data.CreateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.request.data.Digest;
import org.apache.cassandra.sidecar.common.request.data.MD5Digest;
import org.apache.cassandra.sidecar.common.request.data.UpdateCdcServiceConfigPayload;
import org.apache.cassandra.sidecar.common.request.data.XXHash32Digest;
import org.apache.cassandra.sidecar.common.response.ConnectedClientStatsResponse;
import org.apache.cassandra.sidecar.common.response.GossipInfoResponse;
import org.apache.cassandra.sidecar.common.response.HealthResponse;
import org.apache.cassandra.sidecar.common.response.ListCdcSegmentsResponse;
import org.apache.cassandra.sidecar.common.response.ListOperationalJobsResponse;
import org.apache.cassandra.sidecar.common.response.ListSnapshotFilesResponse;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.response.OperationalJobResponse;
import org.apache.cassandra.sidecar.common.response.RingResponse;
import org.apache.cassandra.sidecar.common.response.SSTableImportResponse;
import org.apache.cassandra.sidecar.common.response.SchemaResponse;
import org.apache.cassandra.sidecar.common.response.StreamStatsResponse;
import org.apache.cassandra.sidecar.common.response.TableStatsResponse;
import org.apache.cassandra.sidecar.common.response.TimeSkewResponse;
import org.apache.cassandra.sidecar.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.sidecar.common.response.data.CdcSegmentInfo;
import org.apache.cassandra.sidecar.common.response.data.ClientConnectionEntry;
import org.apache.cassandra.sidecar.common.response.data.CreateRestoreJobResponsePayload;
import org.apache.cassandra.sidecar.common.response.data.RingEntry;
import org.apache.cassandra.sidecar.common.response.data.StreamsProgressStats;
import org.apache.cassandra.sidecar.common.utils.HttpRange;
import org.apache.cassandra.sidecar.foundation.RestoreJobSecretsGen;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

abstract class SidecarClientTest {
    SidecarClient client;
    List<MockWebServer> servers;
    List<SidecarInstanceImpl> instances;

    SidecarClientTest() {
    }

    @BeforeEach
    void setup() {
        this.servers = new ArrayList<MockWebServer>();
        for (int i = 0; i < 4; ++i) {
            this.servers.add(new MockWebServer());
        }
        this.instances = this.servers.stream().map(BaseRequestTest::newSidecarInstance).collect(Collectors.toList());
        this.client = this.initialize(this.instances);
    }

    protected abstract SidecarClient initialize(List<SidecarInstanceImpl> var1);

    @AfterEach
    void tearDown() throws Exception {
        for (MockWebServer server : this.servers) {
            server.shutdown();
        }
        this.client.close();
    }

    @Test
    void testSidecarHealthOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(200).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"OK\"}");
        this.enqueue(response);
        HealthResponse result = (HealthResponse)this.client.sidecarHealth().get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.status()).isEqualToIgnoringCase((CharSequence)"OK");
        Assertions.assertThat((boolean)result.isOk()).isTrue();
        this.validateResponseServed("/api/v1/__health");
    }

    @Test
    void testSidecarHealthNotOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(503).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"NOT_OK\"}");
        this.enqueue(response);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.sidecarHealth().get(30L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RetriesExhaustedException.class);
        this.validateResponseServed("/api/v1/__health");
    }

    @Test
    void testCassandraDeprecatedHealthOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(200).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"OK\"}");
        this.enqueue(response);
        HealthResponse result = (HealthResponse)this.client.cassandraHealth().get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.status()).isEqualToIgnoringCase((CharSequence)"OK");
        Assertions.assertThat((boolean)result.isOk()).isTrue();
        this.validateResponseServed("/api/v1/cassandra/__health");
    }

    @Test
    void testCassandraDeprecatedHealthNotOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(503).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"NOT_OK\"}");
        this.enqueue(response);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.cassandraHealth().get(30L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RetriesExhaustedException.class);
        this.validateResponseServed("/api/v1/cassandra/__health");
    }

    @Test
    void testCassandraNativeHealthOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(200).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"OK\"}");
        this.enqueue(response);
        HealthResponse result = (HealthResponse)this.client.cassandraNativeHealth().get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.status()).isEqualToIgnoringCase((CharSequence)"OK");
        Assertions.assertThat((boolean)result.isOk()).isTrue();
        this.validateResponseServed("/api/v1/cassandra/native/__health");
    }

    @Test
    void testCassandraNativeHealthNotOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(503).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"NOT_OK\"}");
        this.enqueue(response);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.cassandraNativeHealth().get(30L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RetriesExhaustedException.class);
        this.validateResponseServed("/api/v1/cassandra/native/__health");
    }

    @Test
    void testCassandraJmxHealthOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(200).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"OK\"}");
        this.enqueue(response);
        HealthResponse result = (HealthResponse)this.client.cassandraJmxHealth().get(1L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.status()).isEqualTo("OK");
        Assertions.assertThat((boolean)result.isOk()).isTrue();
        this.validateResponseServed("/api/v1/cassandra/jmx/__health");
    }

    @Test
    void testCassandraJmxHealthNotOk() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(503).setHeader("content-type", (Object)"application/json").setBody("{\"status\":\"NOT_OK\"}");
        this.enqueue(response);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.cassandraJmxHealth().get(1L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RetriesExhaustedException.class);
        this.validateResponseServed("/api/v1/cassandra/jmx/__health");
    }

    @Test
    void testFullSchema() throws Exception {
        String fullSchemaAsString = "{\"schema\":\"CREATE KEYSPACE sample_ks.sample_table ...\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(fullSchemaAsString);
        this.enqueue(response);
        SchemaResponse result = (SchemaResponse)this.client.fullSchema().get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.keyspace()).isNull();
        Assertions.assertThat((String)result.schema()).isEqualTo("CREATE KEYSPACE sample_ks.sample_table ...");
        this.validateResponseServed("/api/v1/cassandra/schema");
    }

    @Test
    void testSchema() throws Exception {
        String schemaAsString = "{\"keyspace\":\"cycling\",\"schema\":\"CREATE KEYSPACE sample_ks.sample_table ...\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(schemaAsString);
        this.enqueue(response);
        SchemaResponse result = (SchemaResponse)this.client.schema("cycling").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.keyspace()).isEqualTo("cycling");
        Assertions.assertThat((String)result.schema()).isEqualTo("CREATE KEYSPACE sample_ks.sample_table ...");
        this.validateResponseServed("/api/v1/keyspaces/:keyspace/schema".replaceAll(":keyspace", "cycling"));
    }

    @Test
    void testRing() throws Exception {
        String schemaAsString = "[{\"datacenter\":\"dc\",\"address\":\"127.0.0.1\",\"port\":80,\"rack\":\"r1\",\"status\":\"up\",\"state\":\"normal\",\"load\":\"1 KiB\",\"owns\":\"1%\",\"token\":\"100\",\"fqdn\":\"local\",\"hostId\":\"000\"}]";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(schemaAsString);
        this.enqueue(response);
        RingResponse result = (RingResponse)this.client.ring("cycling").get(30L, TimeUnit.SECONDS);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)result).isNotNull()).hasSize(1);
        RingEntry entry = (RingEntry)result.iterator().next();
        Assertions.assertThat((String)entry.datacenter()).isEqualTo("dc");
        Assertions.assertThat((String)entry.address()).isEqualTo("127.0.0.1");
        Assertions.assertThat((int)entry.port()).isEqualTo(80);
        Assertions.assertThat((String)entry.rack()).isEqualTo("r1");
        Assertions.assertThat((String)entry.status()).isEqualTo("up");
        Assertions.assertThat((String)entry.state()).isEqualTo("normal");
        Assertions.assertThat((String)entry.load()).isEqualTo("1 KiB");
        Assertions.assertThat((String)entry.owns()).isEqualTo("1%");
        Assertions.assertThat((String)entry.token()).isEqualTo("100");
        Assertions.assertThat((String)entry.fqdn()).isEqualTo("local");
        Assertions.assertThat((String)entry.hostId()).isEqualTo("000");
        this.validateResponseServed("/api/v1/cassandra/ring/keyspaces/:keyspace".replaceAll(":keyspace", "cycling"));
    }

    @Test
    public void testNodeSettings() throws Exception {
        String nodeSettingsAsString = "{\"partitioner\":\"test-partitioner\", \"releaseVersion\": \"4.0.0\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(nodeSettingsAsString);
        this.enqueue(response);
        NodeSettings result = (NodeSettings)this.client.nodeSettings().get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.partitioner()).isEqualTo("test-partitioner");
        Assertions.assertThat((String)result.releaseVersion()).isEqualTo("4.0.0");
        this.validateResponseServed("/api/v1/cassandra/settings");
    }

    @Test
    public void testNodeSettingsFromSpecifiedInstance() throws Exception {
        String nodeSettingsAsString = "{\"partitioner\":\"test-partitioner\", \"releaseVersion\": \"4.0.0\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(nodeSettingsAsString);
        MockWebServer mockWebServer = this.servers.get(1);
        mockWebServer.enqueue(response);
        SidecarInstanceImpl instance = new SidecarInstanceImpl(mockWebServer.getHostName(), mockWebServer.getPort());
        NodeSettings result = (NodeSettings)this.client.nodeSettings((SidecarInstance)instance).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.partitioner()).isEqualTo("test-partitioner");
        Assertions.assertThat((String)result.releaseVersion()).isEqualTo("4.0.0");
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/cassandra/settings");
    }

    @Test
    public void testGossipInfo() throws Exception {
        String gossipInfoAsString = "{\"/127.0.0.1:7000\":{\"generation\":\"1\",\"schema\":\"4994b214\",\"rack\":\"r2\",\"heartbeat\":\"214\",\"releaseVersion\":\"4.0.7\",\"sstableVersions\":\"big-nb\"}}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(gossipInfoAsString);
        this.enqueue(response);
        GossipInfoResponse result = (GossipInfoResponse)this.client.gossipInfo().get(30L, TimeUnit.SECONDS);
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasSize(1);
        String key = (String)((Map.Entry)result.entrySet().iterator().next()).getKey();
        GossipInfoResponse.GossipInfo gossipInfo = result.get((Object)key);
        Assertions.assertThat((String)gossipInfo.generation()).isEqualTo("1");
        Assertions.assertThat((String)gossipInfo.schema()).isEqualTo("4994b214");
        Assertions.assertThat((String)gossipInfo.rack()).isEqualTo("r2");
        Assertions.assertThat((String)gossipInfo.heartbeat()).isEqualTo("214");
        Assertions.assertThat((String)gossipInfo.releaseVersion()).isEqualTo("4.0.7");
        Assertions.assertThat((List)gossipInfo.sstableVersions()).isEqualTo(Collections.singletonList("big-nb"));
        this.validateResponseServed("/api/v1/cassandra/gossip");
    }

    @Test
    public void testGossipHealthOK() throws InterruptedException, ExecutionException, TimeoutException {
        SidecarInstanceImpl sidecarInstance = this.instances.get(3);
        String gossipHealthAsString = "{\"status\":\"OK\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(gossipHealthAsString);
        this.enqueue(response);
        HealthResponse result = (HealthResponse)this.client.gossipHealth((SidecarInstance)sidecarInstance).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.status()).isEqualTo("OK");
        this.validateResponseServed("/api/v1/cassandra/gossip/__health");
    }

    @Test
    public void testGossipHealthNotOK() throws InterruptedException, ExecutionException, TimeoutException {
        SidecarInstanceImpl sidecarInstance = this.instances.get(3);
        String gossipHealthAsString = "{\"status\":\"NOT_OK\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(gossipHealthAsString);
        this.enqueue(response);
        HealthResponse result = (HealthResponse)this.client.gossipHealth((SidecarInstance)sidecarInstance).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.status()).isEqualTo("NOT_OK");
        this.validateResponseServed("/api/v1/cassandra/gossip/__health");
    }

    @Test
    public void testTimeSkew() throws Exception {
        String timeSkewAsString = "{\"currentTime\":\"123456789\",\"allowableSkewInMinutes\":\"122\"}}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(timeSkewAsString);
        this.enqueue(response);
        TimeSkewResponse result = (TimeSkewResponse)this.client.timeSkew().get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.allowableSkewInMinutes).isEqualTo(122);
        Assertions.assertThat((long)result.currentTime).isEqualTo(123456789L);
        this.validateResponseServed("/api/v1/time-skew");
    }

    @Test
    public void testTimeSkewFromReplicaSet() throws Exception {
        String timeSkewAsString = "{\"currentTime\":\"5555555\",\"allowableSkewInMinutes\":\"24\"}}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(timeSkewAsString);
        this.enqueue(response);
        TimeSkewResponse result = (TimeSkewResponse)this.client.timeSkew(this.instances.subList(1, 2)).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.allowableSkewInMinutes).isEqualTo(24);
        Assertions.assertThat((long)result.currentTime).isEqualTo(5555555L);
        this.validateResponseServed("/api/v1/time-skew");
    }

    @Test
    public void testTokenRangeReplicasFromReplicaSet() throws Exception {
        String keyspace = "test";
        String nodeAddress = "127.0.0.1";
        int port = 7000;
        String nodeWithPort = nodeAddress + ":" + port;
        String expectedRangeStart = "-9223372036854775808";
        String expectedRangeEnd = "9223372036854775807";
        String tokenRangeReplicasAsString = "{\"replicaMetadata\":{\"127.0.0.1:7000\":{\"state\":\"Normal\",\"status\":\"Up\",\"fqdn\":\"localhost\",\"address\":\"127.0.0.1\",\"port\":7000,\"datacenter\":\"datacenter1\"}},\"writeReplicas\":[{\"start\":\"-9223372036854775808\",\"end\":\"9223372036854775807\",\"replicasByDatacenter\":{\"datacenter1\":[\"127.0.0.1:7000\"]}}],\"readReplicas\":[{\"start\":\"-9223372036854775808\",\"end\":\"9223372036854775807\",\"replicasByDatacenter\":{\"datacenter1\":[\"127.0.0.1:7000\"]}}]}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(tokenRangeReplicasAsString);
        this.enqueue(response);
        TokenRangeReplicasResponse result = (TokenRangeReplicasResponse)this.client.tokenRangeReplicas(this.instances.subList(1, 2), keyspace).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((List)result.writeReplicas()).hasSize(1);
        TokenRangeReplicasResponse.ReplicaInfo writeReplica = (TokenRangeReplicasResponse.ReplicaInfo)result.writeReplicas().get(0);
        Assertions.assertThat((String)writeReplica.start()).isEqualTo(expectedRangeStart);
        Assertions.assertThat((String)writeReplica.end()).isEqualTo(expectedRangeEnd);
        Assertions.assertThat((Map)writeReplica.replicasByDatacenter()).containsKey((Object)"datacenter1");
        Assertions.assertThat((List)((List)writeReplica.replicasByDatacenter().get("datacenter1"))).containsExactly((Object[])new String[]{nodeWithPort});
        Assertions.assertThat((List)result.readReplicas()).hasSize(1);
        TokenRangeReplicasResponse.ReplicaInfo readReplica = (TokenRangeReplicasResponse.ReplicaInfo)result.readReplicas().get(0);
        Assertions.assertThat((String)readReplica.start()).isEqualTo(expectedRangeStart);
        Assertions.assertThat((String)readReplica.end()).isEqualTo(expectedRangeEnd);
        Assertions.assertThat((Map)readReplica.replicasByDatacenter()).containsKey((Object)"datacenter1");
        Assertions.assertThat((List)((List)readReplica.replicasByDatacenter().get("datacenter1"))).containsExactly((Object[])new String[]{nodeWithPort});
        Assertions.assertThat((Map)result.replicaMetadata()).hasSize(1);
        TokenRangeReplicasResponse.ReplicaMetadata instanceMetadata = (TokenRangeReplicasResponse.ReplicaMetadata)result.replicaMetadata().get(nodeWithPort);
        Assertions.assertThat((String)instanceMetadata.state()).isEqualTo("Normal");
        Assertions.assertThat((String)instanceMetadata.status()).isEqualTo("Up");
        Assertions.assertThat((String)instanceMetadata.fqdn()).isEqualTo("localhost");
        Assertions.assertThat((String)instanceMetadata.datacenter()).isEqualTo("datacenter1");
        this.validateResponseServed("/api/v1/keyspaces/:keyspace/token-range-replicas".replaceAll(":keyspace", keyspace));
    }

    @Test
    public void testListSnapshotFiles() throws Exception {
        String responseAsString = "{\"snapshotFilesInfo\":[{\"size\":15,\"host\":\"localhost1\",\"port\":2020,\"dataDirIndex\":1,\"snapshotName\":\"2023.04.11\",\"keySpaceName\":\"cycling\",\"tableName\":\"cyclist_name\",\"fileName\":\"nb-203-big-TOC.txt\"}]}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(responseAsString);
        SidecarInstanceImpl sidecarInstance = this.instances.get(2);
        MockWebServer mockWebServer = this.servers.get(2);
        mockWebServer.enqueue(response);
        ListSnapshotFilesResponse result = (ListSnapshotFilesResponse)this.client.listSnapshotFiles((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.11").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((List)result.snapshotFilesInfo()).hasSize(1);
        ListSnapshotFilesResponse.FileInfo fileInfo = (ListSnapshotFilesResponse.FileInfo)result.snapshotFilesInfo().get(0);
        Assertions.assertThat((long)fileInfo.size).isEqualTo(15L);
        Assertions.assertThat((String)fileInfo.host).isEqualTo("localhost1");
        Assertions.assertThat((int)fileInfo.port).isEqualTo(2020);
        Assertions.assertThat((int)fileInfo.dataDirIndex).isEqualTo(1);
        Assertions.assertThat((String)fileInfo.snapshotName).isEqualTo("2023.04.11");
        Assertions.assertThat((String)fileInfo.keySpaceName).isEqualTo("cycling");
        Assertions.assertThat((String)fileInfo.tableName).isEqualTo("cyclist_name");
        Assertions.assertThat((String)fileInfo.fileName).isEqualTo("nb-203-big-TOC.txt");
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.11") + "?includeSecondaryIndexFiles=true");
    }

    @Test
    public void testListSnapshotFilesPayloadWithTableId() throws Exception {
        String responseAsString = "{\"snapshotFilesInfo\":[{\"size\":15,\"host\":\"localhost1\",\"port\":2020,\"dataDirIndex\":1,\"snapshotName\":\"2023.04.11\",\"keySpaceName\":\"cycling\",\"tableName\":\"cyclist_name\",\"tableId\":\"1234\",\"fileName\":\"nb-203-big-TOC.txt\"}]}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(responseAsString);
        SidecarInstanceImpl sidecarInstance = this.instances.get(2);
        MockWebServer mockWebServer = this.servers.get(2);
        mockWebServer.enqueue(response);
        ListSnapshotFilesResponse result = (ListSnapshotFilesResponse)this.client.listSnapshotFiles((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.11").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((List)result.snapshotFilesInfo()).hasSize(1);
        ListSnapshotFilesResponse.FileInfo fileInfo = (ListSnapshotFilesResponse.FileInfo)result.snapshotFilesInfo().get(0);
        Assertions.assertThat((long)fileInfo.size).isEqualTo(15L);
        Assertions.assertThat((String)fileInfo.host).isEqualTo("localhost1");
        Assertions.assertThat((int)fileInfo.port).isEqualTo(2020);
        Assertions.assertThat((int)fileInfo.dataDirIndex).isEqualTo(1);
        Assertions.assertThat((String)fileInfo.snapshotName).isEqualTo("2023.04.11");
        Assertions.assertThat((String)fileInfo.keySpaceName).isEqualTo("cycling");
        Assertions.assertThat((String)fileInfo.tableName).isEqualTo("cyclist_name");
        Assertions.assertThat((String)fileInfo.fileName).isEqualTo("nb-203-big-TOC.txt");
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.11") + "?includeSecondaryIndexFiles=true");
    }

    @Test
    public void testListSnapshotFilesWithoutSecondaryIndexFiles() throws Exception {
        String responseAsString = "{\"snapshotFilesInfo\":[{\"size\":15,\"host\":\"localhost1\",\"port\":2020,\"dataDirIndex\":1,\"snapshotName\":\"2023.04.11\",\"keySpaceName\":\"cycling\",\"tableName\":\"cyclist_name\",\"fileName\":\"nb-203-big-TOC.txt\"}]}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(responseAsString);
        SidecarInstanceImpl sidecarInstance = this.instances.get(2);
        MockWebServer mockWebServer = this.servers.get(2);
        mockWebServer.enqueue(response);
        ListSnapshotFilesResponse result = (ListSnapshotFilesResponse)this.client.listSnapshotFiles((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.11", false).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((List)result.snapshotFilesInfo()).hasSize(1);
        ListSnapshotFilesResponse.FileInfo fileInfo = (ListSnapshotFilesResponse.FileInfo)result.snapshotFilesInfo().get(0);
        Assertions.assertThat((long)fileInfo.size).isEqualTo(15L);
        Assertions.assertThat((String)fileInfo.host).isEqualTo("localhost1");
        Assertions.assertThat((int)fileInfo.port).isEqualTo(2020);
        Assertions.assertThat((int)fileInfo.dataDirIndex).isEqualTo(1);
        Assertions.assertThat((String)fileInfo.snapshotName).isEqualTo("2023.04.11");
        Assertions.assertThat((String)fileInfo.keySpaceName).isEqualTo("cycling");
        Assertions.assertThat((String)fileInfo.tableName).isEqualTo("cyclist_name");
        Assertions.assertThat((String)fileInfo.fileName).isEqualTo("nb-203-big-TOC.txt");
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.11"));
    }

    @Test
    void testClearSnapshot() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code());
        SidecarInstanceImpl sidecarInstance = this.instances.get(2);
        MockWebServer mockWebServer = this.servers.get(2);
        mockWebServer.enqueue(response);
        this.client.clearSnapshot((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.11").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.11"));
        Assertions.assertThat((String)request.getMethod()).isEqualTo("DELETE");
    }

    @Test
    void testCreateSnapshot() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code());
        SidecarInstanceImpl sidecarInstance = this.instances.get(3);
        MockWebServer mockWebServer = this.servers.get(3);
        mockWebServer.enqueue(response);
        this.client.createSnapshot((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.11").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.11"));
        Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
    }

    @Test
    void testCreateSnapshotWithTTL() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code());
        SidecarInstanceImpl sidecarInstance = this.instances.get(3);
        MockWebServer mockWebServer = this.servers.get(3);
        mockWebServer.enqueue(response);
        this.client.createSnapshot((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.11", "2d").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        String expected = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.11") + "?ttl=2d";
        Assertions.assertThat((String)request.getPath()).isEqualTo(expected);
        Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
    }

    @Test
    void testCleanUploadSession() throws Exception {
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code());
        SidecarInstanceImpl sidecarInstance = this.instances.get(0);
        MockWebServer mockWebServer = this.servers.get(0);
        mockWebServer.enqueue(response);
        this.client.cleanUploadSession((SidecarInstance)sidecarInstance, "00000").get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId".replaceAll(":uploadId", "00000"));
        Assertions.assertThat((String)request.getMethod()).isEqualTo("DELETE");
    }

    @Test
    void testSSTableImport() throws Exception {
        String responseAsString = "{\"success\":true,\"uploadId\":\"0000-0000\",\"keyspace\":\"cycling\",\"tableName\":\"cyclist_name\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(responseAsString);
        SidecarInstanceImpl sidecarInstance = this.instances.get(0);
        MockWebServer mockWebServer = this.servers.get(0);
        mockWebServer.enqueue(response);
        ImportSSTableRequest.ImportOptions options = new ImportSSTableRequest.ImportOptions();
        SSTableImportResponse result = (SSTableImportResponse)this.client.importSSTableRequest((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "0000-0000", options).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.keyspace()).isEqualTo("cycling");
        Assertions.assertThat((String)result.tableName()).isEqualTo("cyclist_name");
        Assertions.assertThat((boolean)result.success()).isTrue();
        Assertions.assertThat((String)result.uploadId()).isEqualTo("0000-0000");
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(1);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/import".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":uploadId", "0000-0000"));
        Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
    }

    @Test
    void testSSTableImportWithAcceptedResponse() throws Exception {
        String responseAsString = "{\"success\":true,\"uploadId\":\"0000-0000\",\"keyspace\":\"cycling\",\"tableName\":\"cyclist_name\"}";
        SidecarInstanceImpl sidecarInstance = this.instances.get(0);
        MockWebServer mockWebServer = this.servers.get(0);
        mockWebServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.ACCEPTED.code()));
        mockWebServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.ACCEPTED.code()));
        mockWebServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.ACCEPTED.code()));
        mockWebServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.ACCEPTED.code()));
        mockWebServer.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(responseAsString));
        ImportSSTableRequest.ImportOptions options = new ImportSSTableRequest.ImportOptions();
        SSTableImportResponse result = (SSTableImportResponse)this.client.importSSTableRequest((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "0000-0000", options).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.keyspace()).isEqualTo("cycling");
        Assertions.assertThat((String)result.tableName()).isEqualTo("cyclist_name");
        Assertions.assertThat((boolean)result.success()).isTrue();
        Assertions.assertThat((String)result.uploadId()).isEqualTo("0000-0000");
        Assertions.assertThat((int)mockWebServer.getRequestCount()).isEqualTo(5);
        RecordedRequest request = mockWebServer.takeRequest();
        Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/import".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":uploadId", "0000-0000"));
        Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
    }

    @Test
    void testUploadSSTableFailsWhenFileDoesNotExist() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.client.uploadSSTableRequest((SidecarInstance)new SidecarInstanceImpl("host", 8080), "cycling", "cyclist_name", "0000-0000", "nb-1-big-TOC.txt", null, "path").get(30L, TimeUnit.SECONDS)).withMessage("File 'path' does not exist");
    }

    @Test
    void testUploadSSTableWithoutDigest(@TempDir Path tempDirectory) throws Exception {
        Path fileToUpload = this.prepareFile(tempDirectory);
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()));
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            this.client.uploadSSTableRequest((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "0000-0000", "nb-1-big-TOC.txt", null, fileToUpload.toString()).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/components/:component".replaceAll(":uploadId", "0000-0000").replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":component", "nb-1-big-TOC.txt"));
            Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
            Assertions.assertThat((String)request.getHeader(HttpHeaderNames.CONTENT_MD5.toString())).isNull();
            Assertions.assertThat((String)request.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString())).isEqualTo("80");
            Assertions.assertThat((long)request.getBodySize()).isEqualTo(80L);
        }
    }

    @Test
    void testUploadSSTableWithMD5Digest(@TempDir Path tempDirectory) throws Exception {
        Path fileToUpload = this.prepareFile(tempDirectory);
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()));
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            this.client.uploadSSTableRequest((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "0000-0000", "nb-1-big-TOC.txt", (Digest)new MD5Digest("15a69dc6501aa5ae17af037fe053f610"), fileToUpload.toString()).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/components/:component".replaceAll(":uploadId", "0000-0000").replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":component", "nb-1-big-TOC.txt"));
            Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
            Assertions.assertThat((String)request.getHeader(HttpHeaderNames.CONTENT_MD5.toString())).isEqualTo("15a69dc6501aa5ae17af037fe053f610");
            Assertions.assertThat((String)request.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString())).isEqualTo("80");
            Assertions.assertThat((long)request.getBodySize()).isEqualTo(80L);
        }
    }

    @Test
    void testUploadSSTableWithXXHashDigest(@TempDir Path tempDirectory) throws Exception {
        Path fileToUpload = this.prepareFile(tempDirectory);
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()));
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            this.client.uploadSSTableRequest((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "0000-0000", "nb-1-big-TOC.txt", (Digest)new XXHash32Digest("15a69dc6501aa5ae17af037fe053f610"), fileToUpload.toString()).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/components/:component".replaceAll(":uploadId", "0000-0000").replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":component", "nb-1-big-TOC.txt"));
            Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
            Assertions.assertThat((String)request.getHeader("cassandra-content-xxhash32")).isEqualTo("15a69dc6501aa5ae17af037fe053f610");
            Assertions.assertThat((String)request.getHeader("cassandra-content-xxhash32-seed")).isNull();
            Assertions.assertThat((String)request.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString())).isEqualTo("80");
            Assertions.assertThat((long)request.getBodySize()).isEqualTo(80L);
        }
    }

    @Test
    void testUploadSSTableWithXXHashDigestAndSeed(@TempDir Path tempDirectory) throws Exception {
        Path fileToUpload = this.prepareFile(tempDirectory);
        try (MockWebServer server = new MockWebServer();){
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()));
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            this.client.uploadSSTableRequest((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "0000-0000", "nb-1-big-TOC.txt", (Digest)new XXHash32Digest("15a69dc6501aa5ae17af037fe053f610", "123456"), fileToUpload.toString()).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo("/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/components/:component".replaceAll(":uploadId", "0000-0000").replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":component", "nb-1-big-TOC.txt"));
            Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT");
            Assertions.assertThat((String)request.getHeader("cassandra-content-xxhash32")).isEqualTo("15a69dc6501aa5ae17af037fe053f610");
            Assertions.assertThat((String)request.getHeader("cassandra-content-xxhash32-seed")).isEqualTo("123456");
            Assertions.assertThat((String)request.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString())).isEqualTo("80");
            Assertions.assertThat((long)request.getBodySize()).isEqualTo(80L);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testLegacyStreamSSTableComponentWithNoRange(boolean useLegacyApi) throws Exception {
        try (MockWebServer server = new MockWebServer();){
            String expectedPath;
            final CountDownLatch latch = new CountDownLatch(1);
            final ArrayList receivedBytes = new ArrayList();
            StreamConsumer mockStreamConsumer = new StreamConsumer(){

                public void onRead(StreamBuffer buffer) {
                    Assertions.assertThat((int)buffer.readableBytes()).isGreaterThan(0);
                    byte[] dst = new byte[buffer.readableBytes()];
                    buffer.copyBytes(0, dst, 0, buffer.readableBytes());
                    receivedBytes.add(dst);
                }

                public void onComplete() {
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    latch.countDown();
                    Assertions.fail((String)"Should not encounter an error", (Throwable)throwable);
                }
            };
            InputStream inputStream = this.resourceInputStream("sstables/nb-1-big-TOC.txt");
            Buffer buffer = Okio.buffer((Source)Okio.source((InputStream)inputStream)).getBuffer();
            Okio.use((Closeable)buffer, buffer1 -> {
                try {
                    return buffer1.writeAll(Okio.source((InputStream)inputStream));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM).setHeader(HttpHeaderNames.ACCEPT_RANGES.toString(), (Object)"bytes").setBody(buffer);
            server.enqueue(response);
            if (useLegacyApi) {
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.12", "nb-203-big-Data.db", null, mockStreamConsumer);
                expectedPath = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.12").replaceAll(":component", "nb-203-big-Data.db");
            } else {
                ListSnapshotFilesResponse.FileInfo fileInfo = new ListSnapshotFilesResponse.FileInfo(2023L, server.getHostName(), server.getPort(), 0, "2023.04.12", "cycling", "cyclist_name-1234", "nb-1-big-TOC.txt");
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, fileInfo, null, mockStreamConsumer);
                expectedPath = fileInfo.componentDownloadUrl();
            }
            Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).isTrue();
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo(expectedPath);
            Assertions.assertThat((String)request.getHeader("User-Agent")).isEqualTo("cassandra-sidecar-test/0.0.1");
            Assertions.assertThat((String)request.getHeader("range")).isNull();
            byte[] bytes = receivedBytes.stream().collect(ByteArrayOutputStream::new, (outputStream, src) -> outputStream.write((byte[])src, 0, ((byte[])src).length), (outputStream, src) -> {}).toByteArray();
            Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo("Summary.db\nTOC.txt\nStatistics.db\nFilter.db\nData.db\nCRC.db\nDigest.crc32\nIndex.db\n");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testStreamSSTableComponentWithRange(boolean useLegacyApi) throws Exception {
        try (MockWebServer server = new MockWebServer();){
            String expectedPath;
            final CountDownLatch latch = new CountDownLatch(1);
            final ArrayList receivedBytes = new ArrayList();
            StreamConsumer mockStreamConsumer = new StreamConsumer(){

                public void onRead(StreamBuffer buffer) {
                    Assertions.assertThat((int)buffer.readableBytes()).isGreaterThan(0);
                    byte[] dst = new byte[buffer.readableBytes()];
                    buffer.copyBytes(0, dst, 0, buffer.readableBytes());
                    receivedBytes.add(dst);
                }

                public void onComplete() {
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    latch.countDown();
                    Assertions.fail((String)"Should not encounter an error", (Throwable)throwable);
                }
            };
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.PARTIAL_CONTENT.code()).setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM).setHeader(HttpHeaderNames.ACCEPT_RANGES.toString(), (Object)"bytes").setHeader(HttpHeaderNames.CONTENT_RANGE.toString(), (Object)"bytes 10-20/80").setBody("TOC.txt\nSt");
            server.enqueue(response);
            if (useLegacyApi) {
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.12", "nb-1-big-TOC.txt", HttpRange.of((long)10L, (long)20L), mockStreamConsumer);
                expectedPath = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.12").replaceAll(":component", "nb-1-big-TOC.txt");
            } else {
                ListSnapshotFilesResponse.FileInfo fileInfo = new ListSnapshotFilesResponse.FileInfo(2023L, server.getHostName(), server.getPort(), 0, "2023.04.12", "cycling", "cyclist_name-1234", "nb-1-big-TOC.txt");
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, fileInfo, HttpRange.of((long)10L, (long)20L), mockStreamConsumer);
                expectedPath = fileInfo.componentDownloadUrl();
            }
            Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).isTrue();
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo(expectedPath);
            Assertions.assertThat((String)request.getHeader("User-Agent")).isEqualTo("cassandra-sidecar-test/0.0.1");
            Assertions.assertThat((String)request.getHeader("range")).isEqualTo("bytes=10-20");
            byte[] bytes = receivedBytes.stream().collect(ByteArrayOutputStream::new, (outputStream, src) -> outputStream.write((byte[])src, 0, ((byte[])src).length), (outputStream, src) -> {}).toByteArray();
            Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo("TOC.txt\nSt");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testStreamSSTableComponentFailsMidStream(boolean useLegacyApi) throws Exception {
        try (MockWebServer server = new MockWebServer();){
            String expectedPath;
            final CountDownLatch latch = new CountDownLatch(1);
            final ArrayList receivedBytes = new ArrayList();
            StreamConsumer mockStreamConsumer = new StreamConsumer(){

                public void onRead(StreamBuffer buffer) {
                    Assertions.assertThat((int)buffer.readableBytes()).isGreaterThan(0);
                    byte[] dst = new byte[buffer.readableBytes()];
                    buffer.copyBytes(0, dst, 0, buffer.readableBytes());
                    receivedBytes.add(dst);
                }

                public void onComplete() {
                }

                public void onError(Throwable throwable) {
                    latch.countDown();
                    Assertions.assertThat((Throwable)throwable).isNotNull();
                }
            };
            InputStream inputStream = this.resourceInputStream("sstables/nb-1-big-TOC.txt");
            Buffer buffer = Okio.buffer((Source)Okio.source((InputStream)inputStream)).getBuffer();
            Okio.use((Closeable)buffer, buffer1 -> {
                try {
                    return buffer1.writeAll(Okio.source((InputStream)inputStream));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM).setHeader(HttpHeaderNames.ACCEPT_RANGES.toString(), (Object)"bytes").setBody(buffer).setSocketPolicy(SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
            server.enqueue(response);
            if (useLegacyApi) {
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.12", "nb-1-big-TOC.txt", null, mockStreamConsumer);
                expectedPath = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.12").replaceAll(":component", "nb-1-big-TOC.txt");
            } else {
                ListSnapshotFilesResponse.FileInfo fileInfo = new ListSnapshotFilesResponse.FileInfo(2023L, server.getHostName(), server.getPort(), 0, "2023.04.12", "cycling", "cyclist_name-1234", "nb-1-big-TOC.txt");
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, fileInfo, null, mockStreamConsumer);
                expectedPath = fileInfo.componentDownloadUrl();
            }
            Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).isTrue();
            RecordedRequest request = server.takeRequest();
            Assertions.assertThat((String)request.getPath()).isEqualTo(expectedPath);
            Assertions.assertThat((String)request.getHeader("User-Agent")).isEqualTo("cassandra-sidecar-test/0.0.1");
            Assertions.assertThat((String)request.getHeader("range")).isNull();
            Assertions.assertThat(receivedBytes).hasSizeGreaterThan(0);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testStreamSSTableComponentWithRetries(boolean useLegacyApi) throws Exception {
        try (MockWebServer server = new MockWebServer();){
            String expectedPath;
            final CountDownLatch latch = new CountDownLatch(1);
            final ArrayList receivedBytes = new ArrayList();
            StreamConsumer mockStreamConsumer = new StreamConsumer(){

                public void onRead(StreamBuffer buffer) {
                    Assertions.assertThat((int)buffer.readableBytes()).isGreaterThan(0);
                    byte[] dst = new byte[buffer.readableBytes()];
                    buffer.copyBytes(0, dst, 0, buffer.readableBytes());
                    receivedBytes.add(dst);
                }

                public void onComplete() {
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                }
            };
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.PARTIAL_CONTENT.code()).setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM).setHeader(HttpHeaderNames.ACCEPT_RANGES.toString(), (Object)"bytes").setHeader(HttpHeaderNames.CONTENT_RANGE.toString(), (Object)"bytes 10-20/80").setBody("TOC.txt\nSt");
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody("{\"error\":\"some error\"}"));
            server.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody("{\"error\":\"some error\"}"));
            server.enqueue(response);
            if (useLegacyApi) {
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, "cycling", "cyclist_name", "2023.04.12", "nb-1-big-TOC.txt", HttpRange.of((long)10L, (long)20L), mockStreamConsumer);
                expectedPath = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component".replaceAll(":keyspace", "cycling").replaceAll(":table", "cyclist_name").replaceAll(":snapshot", "2023.04.12").replaceAll(":component", "nb-1-big-TOC.txt");
            } else {
                ListSnapshotFilesResponse.FileInfo fileInfo = new ListSnapshotFilesResponse.FileInfo(2023L, server.getHostName(), server.getPort(), 0, "2023.04.12", "cycling", "cyclist_name-1234", "nb-1-big-TOC.txt");
                this.client.streamSSTableComponent((SidecarInstance)sidecarInstance, fileInfo, HttpRange.of((long)10L, (long)20L), mockStreamConsumer);
                expectedPath = fileInfo.componentDownloadUrl();
            }
            Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).isTrue();
            server.takeRequest();
            server.takeRequest();
            RecordedRequest request3 = server.takeRequest();
            Assertions.assertThat((String)request3.getPath()).isEqualTo(expectedPath);
            Assertions.assertThat((String)request3.getHeader("User-Agent")).isEqualTo("cassandra-sidecar-test/0.0.1");
            Assertions.assertThat((String)request3.getHeader("range")).isEqualTo("bytes=10-20");
            byte[] bytes = receivedBytes.stream().collect(ByteArrayOutputStream::new, (outputStream, src) -> outputStream.write((byte[])src, 0, ((byte[])src).length), (outputStream, src) -> {}).toByteArray();
            Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo("TOC.txt\nSt");
        }
    }

    @Test
    public void testOperationalJobs() throws Exception {
        UUID jobId = UUID.randomUUID();
        String jobStatusAsString = "{\"jobId\":\"" + String.valueOf(jobId) + "\",\"jobStatus\":\"RUNNING\",\"operation\":\"test\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setHeader("content-type", (Object)"application/json").setBody(jobStatusAsString);
        this.enqueue(response);
        for (MockWebServer server : this.servers) {
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            OperationalJobResponse result = (OperationalJobResponse)this.client.operationalJobs((SidecarInstance)sidecarInstance, jobId).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Comparable)result.jobId()).isEqualTo((Object)jobId);
            Assertions.assertThat((Comparable)result.status()).isEqualTo((Object)OperationalJobStatus.RUNNING);
            Assertions.assertThat((String)result.operation()).isEqualTo("test");
            this.validateResponseServed(server, "/api/v1/cassandra/operational-jobs/:operationId".replaceAll(":operationId", jobId.toString()), req -> {});
        }
    }

    @Test
    public void testlistOperationalJobs() throws Exception {
        UUID jobId = UUID.randomUUID();
        String listJobsString = "{\"jobs\":[{\"jobId\":\"" + String.valueOf(jobId) + "\",\"status\":\"RUNNING\",\"failureReason\":\"\",\"operation\":\"test\"}]}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setHeader("content-type", (Object)"application/json").setBody(listJobsString);
        this.enqueue(response);
        for (MockWebServer server : this.servers) {
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            ListOperationalJobsResponse result = (ListOperationalJobsResponse)this.client.listOperationalJobs((SidecarInstance)sidecarInstance).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.jobs()).isNotNull();
            Assertions.assertThat((Comparable)((OperationalJobResponse)result.jobs().get(0)).jobId()).isEqualTo((Object)jobId);
            this.validateResponseServed(server, "/api/v1/cassandra/operational-jobs", req -> {});
        }
    }

    @Test
    public void testNodeDecommission() throws Exception {
        UUID jobId = UUID.randomUUID();
        String nodeDecommissionString = "{\"jobId\":\"" + String.valueOf(jobId) + "\",\"jobStatus\":\"SUCCEEDED\",\"instance\":\"127.0.0.1\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setHeader("content-type", (Object)"application/json").setBody(nodeDecommissionString);
        this.enqueue(response);
        SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(this.servers.get(0));
        OperationalJobResponse result = (OperationalJobResponse)this.client.nodeDecommission((SidecarInstance)sidecarInstance).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Comparable)result.status()).isEqualTo((Object)OperationalJobStatus.SUCCEEDED);
        this.validateResponseServed("/api/v1/cassandra/operations/decommission");
    }

    @Test
    void testFailsWithOneAttemptPerServer() {
        for (MockWebServer server : this.servers) {
            MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody("{\"error\":\"some error\"}");
            server.enqueue(response);
        }
        Assertions.assertThatExceptionOfType(ExecutionException.class).isThrownBy(() -> this.client.schema("cycling").get(30L, TimeUnit.SECONDS)).withRootCauseInstanceOf(RetriesExhaustedException.class).withMessageContaining("Unable to complete request '/api/v1/keyspaces/cycling/schema' after 4 attempts");
    }

    @Test
    void testProvidingCustomRetryPolicy() throws ExecutionException, InterruptedException, TimeoutException {
        String nodeSettingsAsString = "{\"partitioner\":\"test-partitioner\", \"releaseVersion\": \"4.0.0\"}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.ACCEPTED.code()).setBody(nodeSettingsAsString);
        this.enqueue(response);
        RequestContext requestContext = this.client.requestBuilder().request((Request)new NodeSettingsRequest()).retryPolicy(new RetryPolicy(){

            public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
                if (response != null && response.statusCode() == HttpResponseStatus.ACCEPTED.code()) {
                    responseFuture.complete(response);
                } else {
                    SidecarClientTest.this.client.defaultRetryPolicy().onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
                }
            }
        }).build();
        NodeSettings result = (NodeSettings)this.client.executeRequestAsync(requestContext).get(30L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((String)result.partitioner()).isEqualTo("test-partitioner");
        Assertions.assertThat((String)result.releaseVersion()).isEqualTo("4.0.0");
        this.validateResponseServed("/api/v1/cassandra/settings");
    }

    @Test
    void testAcceptCreateRestoreJobRequest() throws Exception {
        String jobIdStr = "8e5799a4-d277-11ed-8d85-6916bb9b8056";
        this.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody("{\"jobId\":\"" + jobIdStr + "\",\"status\":\"CREATED\"}"));
        UUID jobId = UUID.fromString(jobIdStr);
        long expireAt = System.currentTimeMillis() + 10000L;
        RestoreJobSecrets secrets = RestoreJobSecretsGen.genRestoreJobSecrets();
        CreateRestoreJobRequestPayload requestPayload = CreateRestoreJobRequestPayload.builder((RestoreJobSecrets)secrets, (long)expireAt).jobId(jobId).build();
        CreateRestoreJobResponsePayload responsePayload = (CreateRestoreJobResponsePayload)this.client.createRestoreJob("cycling", "rank_by_year_and_name", requestPayload).join();
        Assertions.assertThat((Object)responsePayload).isNotNull();
        Assertions.assertThat((Comparable)responsePayload.jobId()).isEqualTo((Object)jobId);
        Assertions.assertThat((String)responsePayload.status()).isEqualTo("CREATED");
        ObjectMapper mapper = new ObjectMapper();
        String expectedReqBodyString = mapper.writeValueAsString((Object)requestPayload);
        this.validateResponseServed("/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs".replaceAll(":keyspace", "cycling").replaceAll(":table", "rank_by_year_and_name").replaceAll(":jobId", jobIdStr), recordedRequest -> {
            String reqBodyString = recordedRequest.getBody().readString(Charset.defaultCharset());
            Assertions.assertThat((String)reqBodyString).isEqualTo(expectedReqBodyString);
        });
    }

    @Test
    void testCreateRestoreJobShouldNotRetryOnDifferentHostWithBadRequest() throws Exception {
        String jobIdStr = "8e5799a4-d277-11ed-8d85-6916bb9b8056";
        this.enqueue(new MockResponse().setResponseCode(HttpResponseStatus.BAD_REQUEST.code()).setBody("{\"status\":\"Fail\",\"message\":\"Error while decoding values, check your request body\"}"));
        UUID jobId = UUID.fromString(jobIdStr);
        long expireAt = System.currentTimeMillis() + 10000L;
        RestoreJobSecrets secrets = RestoreJobSecretsGen.genRestoreJobSecrets();
        CreateRestoreJobRequestPayload requestPayload = CreateRestoreJobRequestPayload.builder((RestoreJobSecrets)secrets, (long)expireAt).jobId(jobId).build();
        Assertions.assertThatException().isThrownBy(() -> this.client.createRestoreJob("badkeyspace", "bad_table", requestPayload).join()).withCauseInstanceOf(RetriesExhaustedException.class).withMessageContaining("Unable to complete request '/api/v1/keyspaces/badkeyspace/tables/bad_table/restore-jobs' after 1 attempt");
        ObjectMapper mapper = new ObjectMapper();
        String expectedReqBodyString = mapper.writeValueAsString((Object)requestPayload);
        this.validateResponseServed("/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs".replaceAll(":keyspace", "badkeyspace").replaceAll(":table", "bad_table").replaceAll(":jobId", jobIdStr), recordedRequest -> {
            String reqBodyString = recordedRequest.getBody().readString(Charset.defaultCharset());
            Assertions.assertThat((String)reqBodyString).isEqualTo(expectedReqBodyString);
        });
    }

    @Test
    public void testConnectedClientStats() throws Exception {
        String connectedClientStatsResponseAsString = "{\"clientConnections\":[{\"address\":\"127.0.0.1\",\"port\":54628,\"sslEnabled\":false,\"sslCipherSuite\":\"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\",\"sslProtocol\":\"TLSv1.2\",\"protocolVersion\":\"5\",\"username\":\"anonymous\",\"requestCount\":39,\"driverName\":\"DataStax Java Driver\",\"driverVersion\":\"3.11.3\",\"keyspaceName\":\"test\",\"authenticationMode\":\"MutualTls\",\"authenticationMetadata\":{\"identity\":\"spiffe://test.cassandra.apache.org/unitTest/mtls\"},\"clientOptions\":{\"CQL_VERSION\":\"3.4.6\",\"DRIVER_NAME\":\"DataStax Python Driver\",\"DRIVER_VERSION\":\"3.25.0\"}}],\"totalConnectedClients\":1,\"connectionsByUser\":{\"anonymous\":1}}";
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(connectedClientStatsResponseAsString);
        this.enqueue(response);
        for (MockWebServer server : this.servers) {
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            ConnectedClientStatsResponse result = (ConnectedClientStatsResponse)this.client.connectedClientStats((SidecarInstance)sidecarInstance).get();
            Assertions.assertThat((Object)result).isNotNull();
            ((ListAssert)Assertions.assertThat((List)result.clientConnections()).isNotNull()).hasSize(1);
            ((AbstractLongAssert)Assertions.assertThat((long)result.totalConnectedClients()).isNotNull()).isEqualTo(1L);
            ((MapAssert)Assertions.assertThat((Map)result.connectionsByUser()).isNotNull()).containsKey((Object)"anonymous");
            ClientConnectionEntry entry = (ClientConnectionEntry)result.clientConnections().iterator().next();
            Assertions.assertThat((String)entry.address()).isEqualTo("127.0.0.1");
            Assertions.assertThat((int)entry.port()).isEqualTo(54628);
            Assertions.assertThat((Boolean)entry.sslEnabled()).isEqualTo(false);
            Assertions.assertThat((String)entry.sslCipherSuite()).isEqualTo("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
            Assertions.assertThat((String)entry.sslProtocol()).isEqualTo("TLSv1.2");
            Assertions.assertThat((String)entry.protocolVersion()).isEqualTo("5");
            Assertions.assertThat((String)entry.username()).isEqualTo("anonymous");
            Assertions.assertThat((long)entry.requestCount()).isEqualTo(39L);
            Assertions.assertThat((String)entry.driverName()).isEqualTo("DataStax Java Driver");
            Assertions.assertThat((String)entry.driverVersion()).isEqualTo("3.11.3");
            Assertions.assertThat((String)entry.keyspaceName()).isEqualTo("test");
            Assertions.assertThat((String)entry.authenticationMode()).isEqualTo("MutualTls");
            Assertions.assertThat((Map)entry.authenticationMetadata()).containsKey((Object)"identity");
            Assertions.assertThat((Map)entry.clientOptions()).containsKeys((Object[])new String[]{"CQL_VERSION", "DRIVER_NAME", "DRIVER_VERSION"});
            this.validateResponseServed(server, "/api/v1/cassandra/stats/connected-clients", req -> {});
        }
    }

    @Test
    public void testTableStats() throws Exception {
        String testKeyspace = "testKeyspace";
        String testTable = "testTable";
        int expectedSstables = 10;
        long expectedSize = 1024L;
        long expectedTotalSize = 2048L;
        long expectedSnapshotSize = 100L;
        TableStatsResponse tableStatsResponse = new TableStatsResponse(testKeyspace, testTable, (long)expectedSstables, expectedSize, expectedTotalSize, expectedSnapshotSize);
        ObjectMapper mapper = new ObjectMapper();
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(mapper.writeValueAsString((Object)tableStatsResponse));
        this.enqueue(response);
        for (MockWebServer server : this.servers) {
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            TableStatsResponse result = (TableStatsResponse)this.client.tableStats((SidecarInstance)sidecarInstance, testKeyspace, testTable).get();
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((long)result.sstableCount()).isEqualTo((long)expectedSstables);
            Assertions.assertThat((long)result.diskSpaceUsedBytes()).isEqualTo(expectedSize);
            Assertions.assertThat((long)result.totalDiskSpaceUsedBytes()).isEqualTo(expectedTotalSize);
            Assertions.assertThat((long)result.snapshotsSizeBytes()).isEqualTo(expectedSnapshotSize);
            this.validateResponseServed(server, "/api/v1/cassandra/keyspaces/:keyspace/tables/:table/stats".replaceAll(":keyspace", testKeyspace).replaceAll(":table", testTable), req -> {});
        }
    }

    @Test
    public void testListCdcSegments() throws ExecutionException, InterruptedException, JsonProcessingException {
        List<CdcSegmentInfo> segments = Arrays.asList(new CdcSegmentInfo("commit-log1", 100L, 100L, true, 1732148713725L), new CdcSegmentInfo("commit-log2", 100L, 10L, false, 1732148713725L));
        ListCdcSegmentsResponse listSegmentsResponse = new ListCdcSegmentsResponse("localhost", 9043, segments);
        ObjectMapper mapper = new ObjectMapper();
        MockResponse response = new MockResponse();
        response.setResponseCode(200);
        response.setHeader("content-type", (Object)"application/json");
        response.setBody(mapper.writeValueAsString((Object)listSegmentsResponse));
        this.enqueue(response);
        SidecarInstance instance = (SidecarInstance)this.instances.get(0);
        ListCdcSegmentsResponse result = (ListCdcSegmentsResponse)this.client.listCdcSegments(instance).get();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object)result).isEqualTo((Object)listSegmentsResponse);
        this.validateResponseServed("/api/v1/cdc/segments");
    }

    @Test
    public void testStreamCdcSegments() throws InterruptedException {
        MockResponse response = new MockResponse();
        response.setResponseCode(200).setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_OCTET_STREAM).setHeader(HttpHeaderNames.ACCEPT_RANGES.toString(), (Object)"bytes").setHeader(HttpHeaderNames.CONTENT_RANGE.toString(), (Object)"bytes 0-11/1024").setBody("Test Content");
        this.enqueue(response);
        SidecarInstance instance = (SidecarInstance)this.instances.get(0);
        final CountDownLatch latch = new CountDownLatch(1);
        final ArrayList receivedBytes = new ArrayList();
        StreamConsumer mockStreamConsumer = new StreamConsumer(){

            public void onRead(StreamBuffer buffer) {
                Assertions.assertThat((int)buffer.readableBytes()).isGreaterThan(0);
                byte[] dst = new byte[buffer.readableBytes()];
                buffer.copyBytes(0, dst, 0, buffer.readableBytes());
                receivedBytes.add(dst);
            }

            public void onComplete() {
                latch.countDown();
            }

            public void onError(Throwable throwable) {
                latch.countDown();
            }
        };
        this.client.streamCdcSegments(instance, "testSegment", HttpRange.of((long)0L, (long)11L), mockStreamConsumer);
        latch.await();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] bytes : receivedBytes) {
            baos.write(bytes, 0, bytes.length);
        }
        Assertions.assertThat((String)new String(baos.toByteArray(), StandardCharsets.UTF_8)).isEqualTo("Test Content");
    }

    @Test
    public void testReportSchemaSuccess() {
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody("{\"status\":\"OK\"}");
        this.enqueue(response);
        SidecarInstance instance = (SidecarInstance)this.instances.get(0);
        Assertions.assertThatNoException().isThrownBy(() -> this.client.reportSchema(instance).get());
    }

    @Test
    public void testReportSchemaFailure() {
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setBody(HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase());
        this.enqueue(response);
        SidecarInstance instance = (SidecarInstance)this.instances.get(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.reportSchema(instance).get()).isExactlyInstanceOf(ExecutionException.class)).hasCauseInstanceOf(RetriesExhaustedException.class).hasMessageContaining(Integer.toString(HttpResponseStatus.INTERNAL_SERVER_ERROR.code())).hasMessageContaining(HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase());
    }

    @Test
    public void testAllServiceSuccessTests() throws IOException, ExecutionException, InterruptedException {
        ArrayList<AllServicesConfigPayload.Service> services = new ArrayList<AllServicesConfigPayload.Service>();
        HashMap<String, String> kafkaConfigs = new HashMap<String, String>();
        kafkaConfigs.put("k1", "v1");
        kafkaConfigs.put("k2", "v2");
        HashMap<String, String> cdcConfigs = new HashMap<String, String>();
        cdcConfigs.put("k1", "v1");
        cdcConfigs.put("k2", "v2");
        services.add(new AllServicesConfigPayload.Service("kafka", kafkaConfigs));
        services.add(new AllServicesConfigPayload.Service("cdc", cdcConfigs));
        AllServicesConfigPayload expectedResponse = new AllServicesConfigPayload(services);
        MockResponse response = new MockResponse();
        response.setResponseCode(200);
        response.setHeader("content-type", (Object)"application/json");
        ObjectMapper mapper = new ObjectMapper();
        response.setBody(mapper.writeValueAsString((Object)expectedResponse));
        this.enqueue(response);
        Assertions.assertThat((Object)((AllServicesConfigPayload)this.client.allServicesConfig().get())).isEqualTo((Object)expectedResponse);
        this.validateResponseServed("/api/v1/services", request -> Assertions.assertThat((String)request.getMethod()).isEqualTo("GET"));
    }

    @Test
    public void testUpdateConfigSuccessTests() throws IOException, ExecutionException, InterruptedException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("testKey", "testValue");
        UpdateCdcServiceConfigPayload putResponse = new UpdateCdcServiceConfigPayload(payload);
        MockResponse response = new MockResponse();
        response.setResponseCode(200);
        response.setHeader("content-type", (Object)"application/json");
        ObjectMapper mapper = new ObjectMapper();
        response.setBody(mapper.writeValueAsString((Object)putResponse));
        this.enqueue(response);
        Assertions.assertThat((Object)((UpdateCdcServiceConfigPayload)this.client.updateCdcServiceConfig(Service.CDC, payload).get())).isEqualTo((Object)putResponse);
        this.validateResponseServed("/api/v1/services/:service/config".replaceAll(":service", "cdc"), request -> Assertions.assertThat((String)request.getMethod()).isEqualTo("PUT"));
    }

    @Test
    public void testDeleteConfigTests() throws ExecutionException, InterruptedException {
        MockResponse response = new MockResponse();
        response.setResponseCode(200);
        this.enqueue(response);
        this.client.deleteCdcServiceConfig(Service.CDC).get();
        this.validateResponseServed("/api/v1/services/:service/config".replaceAll(":service", "cdc"), request -> Assertions.assertThat((String)request.getMethod()).isEqualTo("DELETE"));
    }

    @Test
    public void testStreamsStats() throws Exception {
        StreamsProgressStats stats = new StreamsProgressStats(7L, 7L, 15088L, 15088L, 2L, 2L, 1024L, 1024L);
        StreamStatsResponse mockResp = new StreamStatsResponse("NORMAL", stats);
        ObjectMapper mapper = new ObjectMapper();
        String expectedResponse = mapper.writeValueAsString((Object)mockResp);
        MockResponse response = new MockResponse().setResponseCode(HttpResponseStatus.OK.code()).setBody(expectedResponse);
        this.enqueue(response);
        for (MockWebServer server : this.servers) {
            SidecarInstanceImpl sidecarInstance = RequestExecutorTest.newSidecarInstance(server);
            StreamStatsResponse result = (StreamStatsResponse)this.client.streamsStats((SidecarInstance)sidecarInstance).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat((String)mapper.writeValueAsString((Object)result)).isEqualTo(expectedResponse);
            this.validateResponseServed(server, "/api/v1/cassandra/stats/streams", req -> {});
        }
    }

    private void enqueue(MockResponse response) {
        for (MockWebServer server : this.servers) {
            server.enqueue(response);
        }
    }

    private void validateResponseServed(String expectedEndpointPath) throws InterruptedException {
        this.validateResponseServed(expectedEndpointPath, req -> {});
    }

    private void validateResponseServed(String expectedEndpointPath, Consumer<RecordedRequest> serverReceivedRequestVerifier) throws InterruptedException {
        for (MockWebServer server : this.servers) {
            if (!this.validateResponseServed(server, expectedEndpointPath, serverReceivedRequestVerifier)) continue;
            return;
        }
        Assertions.fail((String)"The request was not served by any of the provided servers");
    }

    private boolean validateResponseServed(MockWebServer server, String expectedEndpointPath, Consumer<RecordedRequest> serverReceivedRequestVerifier) throws InterruptedException {
        if (server.getRequestCount() > 0) {
            Assertions.assertThat((int)server.getRequestCount()).isEqualTo(1);
            RecordedRequest request = server.takeRequest();
            serverReceivedRequestVerifier.accept(request);
            Assertions.assertThat((String)request.getPath()).isEqualTo(expectedEndpointPath);
            return true;
        }
        return false;
    }

    private InputStream resourceInputStream(String name) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        return inputStream;
    }

    private Path prepareFile(Path tempDirectory) throws IOException {
        Path fileToUpload = tempDirectory.resolve("nb-1-big-TOC.txt");
        try (InputStream inputStream = this.resourceInputStream("sstables/nb-1-big-TOC.txt");){
            Files.copy(inputStream, fileToUpload, StandardCopyOption.REPLACE_EXISTING);
        }
        return fileToUpload;
    }
}

