/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.bulkwriter.DataTransportInfo;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithmSupplier;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithms;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.DirectStreamSession;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SchemaInfo;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.StreamSession;
import org.apache.cassandra.spark.bulkwriter.TTLOption;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TableSchemaTestCommon;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.UploadRequest;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.WriteMode;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.spark.common.stats.JobStatsPublisher;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.apache.cassandra.spark.validation.StartupValidator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockBulkWriterContext
implements BulkWriterContext,
ClusterInfo,
JobInfo,
SchemaInfo,
JobStatsPublisher {
    private static final long serialVersionUID = -2912371629236770646L;
    public static final String[] DEFAULT_PARTITION_KEY_COLUMNS = new String[]{"id", "date"};
    public static final String[] DEFAULT_PRIMARY_KEY_COLUMN_NAMES = new String[]{"id", "date"};
    public static final Pair<StructType, ImmutableMap<String, CqlField.CqlType>> DEFAULT_VALID_PAIR = TableSchemaTestCommon.buildMatchedDataframeAndCqlColumns(new String[]{"id", "date", "course", "marks"}, new DataType[]{DataTypes.IntegerType, DataTypes.DateType, DataTypes.StringType, DataTypes.IntegerType}, new CqlField.CqlType[]{TableSchemaTestCommon.mockCqlType("int"), TableSchemaTestCommon.mockCqlType("date"), TableSchemaTestCommon.mockCqlType("varchar"), TableSchemaTestCommon.mockCqlType("int")});
    private ConsistencyLevel.CL consistencyLevel;
    private int sstableDataSizeInMB = 128;
    private TimeSkewTooLargeException timeSkewTooLargeException;
    public static final String DEFAULT_CASSANDRA_VERSION = "cassandra-5.0.5";
    private final UUID jobId;
    private boolean skipClean = false;
    public int refreshClusterInfoCallCount = 0;
    private final Map<CassandraInstance, List<UploadRequest>> uploads = new ConcurrentHashMap<CassandraInstance, List<UploadRequest>>();
    private final Map<CassandraInstance, List<String>> commits = new ConcurrentHashMap<CassandraInstance, List<String>>();
    final Pair<StructType, ImmutableMap<String, CqlField.CqlType>> validPair;
    private final TableSchema schema;
    private final TokenRangeMapping<RingInstance> tokenRangeMapping;
    private final Set<CassandraInstance> cleanCalledForInstance = Collections.synchronizedSet(new HashSet());
    private boolean cleanShouldThrow = false;
    private final TokenPartitioner tokenPartitioner;
    private final String cassandraVersion;
    private final CassandraBridge bridge;
    private CommitResultSupplier crSupplier = (uuids, dc) -> new DirectDataTransferApi.RemoteCommitResult(true, Collections.emptyList(), uuids, null);
    private Predicate<CassandraInstance> uploadRequestConsumer = instance -> true;
    private ReplicationFactor replicationFactor;

    public void publish(Map<String, String> stats) {
    }

    public MockBulkWriterContext(TokenRangeMapping<RingInstance> tokenRangeMapping) {
        this(tokenRangeMapping, DEFAULT_CASSANDRA_VERSION, ConsistencyLevel.CL.LOCAL_QUORUM, DEFAULT_VALID_PAIR, DEFAULT_PARTITION_KEY_COLUMNS, DEFAULT_PRIMARY_KEY_COLUMN_NAMES, false);
    }

    public MockBulkWriterContext(TokenRangeMapping<RingInstance> tokenRangeMapping, String cassandraVersion, ConsistencyLevel.CL consistencyLevel) {
        this(tokenRangeMapping, cassandraVersion, consistencyLevel, DEFAULT_VALID_PAIR, DEFAULT_PARTITION_KEY_COLUMNS, DEFAULT_PRIMARY_KEY_COLUMN_NAMES, false);
    }

    public MockBulkWriterContext(TokenRangeMapping<RingInstance> tokenRangeMapping, String cassandraVersion, ConsistencyLevel.CL consistencyLevel, Pair<StructType, ImmutableMap<String, CqlField.CqlType>> validPair, String[] partitionKeyColumns, String[] primaryKeyColumnNames, boolean quoteIdentifiers) {
        this.tokenRangeMapping = tokenRangeMapping;
        this.tokenPartitioner = new TokenPartitioner(tokenRangeMapping, Integer.valueOf(1), 2, Integer.valueOf(2), false);
        this.cassandraVersion = cassandraVersion;
        this.consistencyLevel = consistencyLevel;
        this.validPair = validPair;
        this.bridge = CassandraBridgeFactory.get((String)cassandraVersion);
        StructType validDataFrameSchema = (StructType)this.validPair.getKey();
        ImmutableMap validCqlColumns = (ImmutableMap)this.validPair.getValue();
        ColumnType[] partitionKeyColumnTypes = new ColumnType[]{ColumnTypes.INT, ColumnTypes.INT};
        TTLOption ttlOption = TTLOption.forever();
        TableSchemaTestCommon.MockTableSchemaBuilder builder = new TableSchemaTestCommon.MockTableSchemaBuilder(this.bridge).withCqlColumns((Map<String, CqlField.CqlType>)validCqlColumns).withPartitionKeyColumns(partitionKeyColumns).withPrimaryKeyColumnNames(primaryKeyColumnNames).withCassandraVersion(cassandraVersion).withPartitionKeyColumnTypes(partitionKeyColumnTypes).withWriteMode(WriteMode.INSERT).withDataFrameSchema(validDataFrameSchema).withTTLSetting(ttlOption);
        if (quoteIdentifiers) {
            builder.withQuotedIdentifiers();
        }
        this.schema = builder.build();
        this.jobId = UUID.randomUUID();
    }

    public void shutdown() {
    }

    public void setTimeSkewTooLargeException(TimeSkewTooLargeException exception) {
        this.timeSkewTooLargeException = exception;
    }

    public void validateTimeSkew(Range<BigInteger> range) throws SidecarApiCallException, TimeSkewTooLargeException {
        if (this.timeSkewTooLargeException != null) {
            throw this.timeSkewTooLargeException;
        }
    }

    public String getKeyspaceSchema(boolean cached) {
        throw new UnsupportedOperationException();
    }

    public ReplicationFactor replicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public CassandraContext getCassandraContext() {
        return null;
    }

    public String clusterId() {
        return "test-cluster";
    }

    public void refreshClusterInfo() {
        ++this.refreshClusterInfoCallCount;
    }

    public ConsistencyLevel.CL getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getLocalDC() {
        if (this.getConsistencyLevel().isLocal()) {
            return "DC1";
        }
        return null;
    }

    public int sstableDataSizeInMiB() {
        return this.sstableDataSizeInMB;
    }

    @VisibleForTesting
    void setSstableDataSizeInMB(int sstableDataSizeInMB) {
        this.sstableDataSizeInMB = sstableDataSizeInMB;
    }

    public int getCommitBatchSize() {
        return 1;
    }

    public boolean skipExtendedVerify() {
        return false;
    }

    public boolean getSkipClean() {
        return this.skipClean;
    }

    @NotNull
    public DigestAlgorithmSupplier digestAlgorithmSupplier() {
        return DigestAlgorithms.XXHASH32;
    }

    public DataTransportInfo transportInfo() {
        return new DataTransportInfo(DataTransport.DIRECT, null, 0L);
    }

    public int jobKeepAliveMinutes() {
        return 1;
    }

    public long jobTimeoutSeconds() {
        return -1L;
    }

    public int effectiveSidecarPort() {
        return 9043;
    }

    public double importCoordinatorTimeoutMultiplier() {
        return 2.0;
    }

    @Nullable
    public CoordinatedWriteConf coordinatedWriteConf() {
        return null;
    }

    public void setSkipCleanOnFailures(boolean skipClean) {
        this.skipClean = skipClean;
    }

    public int getCommitThreadsPerInstance() {
        return 1;
    }

    public TokenRangeMapping<RingInstance> getTokenRangeMapping(boolean cached) {
        return this.tokenRangeMapping;
    }

    public UUID getRestoreJobId() {
        return this.jobId;
    }

    public UUID getRestoreJobId(@Nullable String clusterId) throws NoSuchElementException {
        return this.jobId;
    }

    public String getConfiguredJobId() {
        return null;
    }

    public TokenPartitioner getTokenPartitioner() {
        return this.tokenPartitioner;
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public Set<String> getUserDefinedTypeStatements() {
        return Collections.emptySet();
    }

    public Partitioner getPartitioner() {
        return Partitioner.Murmur3Partitioner;
    }

    public void checkBulkWriterIsEnabledOrThrow() {
        throw new RuntimeException(String.format("Aborting Bulk Writer! feature %s is disabled for cluster", "cassandra-spark-bulk-writer"));
    }

    public String getLowestCassandraVersion() {
        return this.cassandraVersion;
    }

    private List<String> buildCompleteBatchIds(List<String> uuids) {
        return uuids.stream().map(uuid -> uuid + "-" + String.valueOf(this.jobId)).collect(Collectors.toList());
    }

    public Map<RingInstance, WriteAvailability> clusterWriteAvailability() {
        Set allInstances = this.tokenRangeMapping.allInstances();
        HashMap<RingInstance, WriteAvailability> result = new HashMap<RingInstance, WriteAvailability>(allInstances.size());
        for (RingInstance instance : allInstances) {
            result.put(instance, WriteAvailability.AVAILABLE);
        }
        return result;
    }

    public void setUploadSupplier(Predicate<CassandraInstance> uploadRequestConsumer) {
        this.uploadRequestConsumer = uploadRequestConsumer;
    }

    public int refreshClusterInfoCallCount() {
        return this.refreshClusterInfoCallCount;
    }

    public List<CassandraInstance> getCleanedInstances() {
        return new ArrayList<CassandraInstance>(this.cleanCalledForInstance);
    }

    public void setCleanShouldThrow(boolean cleanShouldThrow) {
        this.cleanShouldThrow = cleanShouldThrow;
    }

    public Map<CassandraInstance, List<UploadRequest>> getUploads() {
        return this.uploads;
    }

    public CommitResultSupplier setCommitResultSupplier(CommitResultSupplier supplier) {
        CommitResultSupplier oldSupplier = this.crSupplier;
        this.crSupplier = supplier;
        return oldSupplier;
    }

    public ClusterInfo cluster() {
        return this;
    }

    public JobInfo job() {
        return this;
    }

    public JobStatsPublisher jobStats() {
        return this;
    }

    public SchemaInfo schema() {
        return this;
    }

    public TransportContext transportContext() {
        final MockBulkWriterContext mockBulkWriterContext = this;
        return new TransportContext.DirectDataBulkWriterContext(){

            public DirectDataTransferApi dataTransferApi() {
                return new DirectDataTransferApi(){

                    public DirectDataTransferApi.RemoteCommitResult commitSSTables(CassandraInstance instance, String migrationId, List<String> uuids) {
                        MockBulkWriterContext.this.commits.compute(instance, (ignored, commitList) -> {
                            if (commitList == null) {
                                commitList = new ArrayList<String>();
                            }
                            commitList.add(migrationId);
                            return commitList;
                        });
                        return (DirectDataTransferApi.RemoteCommitResult)MockBulkWriterContext.this.crSupplier.apply(MockBulkWriterContext.this.buildCompleteBatchIds(uuids), instance.datacenter());
                    }

                    public void cleanUploadSession(CassandraInstance instance, String sessionID, String jobID) throws SidecarApiCallException {
                        MockBulkWriterContext.this.cleanCalledForInstance.add(instance);
                        if (MockBulkWriterContext.this.cleanShouldThrow) {
                            throw new SidecarApiCallException("Clean was called but was set to throw");
                        }
                    }

                    public void uploadSSTableComponent(Path componentFile, int ssTableIdx, CassandraInstance instance, String sessionID, Digest digest) throws SidecarApiCallException {
                        boolean uploadSucceeded = MockBulkWriterContext.this.uploadRequestConsumer.test(instance);
                        MockBulkWriterContext.this.uploads.compute(instance, (k, pathList) -> {
                            if (pathList == null) {
                                pathList = new ArrayList<UploadRequest>();
                            }
                            pathList.add(new UploadRequest(componentFile, ssTableIdx, instance, sessionID, digest, uploadSucceeded));
                            return pathList;
                        });
                        if (!uploadSucceeded) {
                            throw new SidecarApiCallException("Failed upload");
                        }
                    }
                };
            }

            public StreamSession<?> createStreamSession(BulkWriterContext writerContext, String sessionId, SortedSSTableWriter sstableWriter, Range<BigInteger> range, ReplicaAwareFailureHandler<RingInstance> failureHandler, ExecutorService executorService) {
                return new DirectStreamSession((BulkWriterContext)mockBulkWriterContext, sstableWriter, (TransportContext.DirectDataBulkWriterContext)this, sessionId, range, failureHandler, executorService);
            }
        };
    }

    public CassandraBridge bridge() {
        return this.bridge;
    }

    public QualifiedTableName qualifiedTableName() {
        return new QualifiedTableName("keyspace", "table", false);
    }

    public void startupValidate() {
        StartupValidator.instance().perform();
    }

    public static interface CommitResultSupplier
    extends BiFunction<List<String>, String, DirectDataTransferApi.RemoteCommitResult> {
    }
}

