/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Uninterruptibles;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.Row;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.immutable.Map;

@Tag(value="Sequential")
public class FiltersTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSinglePartitionKeyFilter(CassandraBridge bridge) {
        int numRows = 10;
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withColumn("b", (CqlField.CqlType)bridge.aInt())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                writer.write(new Object[]{row, row + 1});
            }
        }).withFilter("a=1").withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                int a = row.getInt(0);
                Assertions.assertThat((int)a).isEqualTo(1);
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultiplePartitionKeyFilter(CassandraBridge bridge) {
        int numRows = 10;
        int numColumns = 5;
        Set<String> keys = TestUtils.getKeys((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2", (Object)"3"), (Object)ImmutableList.of((Object)"2", (Object)"3", (Object)"4")));
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withPartitionKey("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.aInt())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                for (int column = 0; column < numColumns; ++column) {
                    writer.write(new Object[]{row, row + 1, column});
                }
            }
        }).withFilter("a in (2, 3) and b in (2, 3, 4)").withCheck(dataset -> {
            List rows = dataset.collectAsList();
            Assertions.assertThat((int)rows.size()).isEqualTo(2);
            for (Row row : rows) {
                int a = row.getInt(0);
                int b = row.getInt(1);
                String key = a + ":" + b;
                Assertions.assertThat((boolean)keys.contains(key)).isTrue();
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testFiltersDoNotMatch(CassandraBridge bridge) {
        int numRows = 10;
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withColumn("b", (CqlField.CqlType)bridge.aInt())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                writer.write(new Object[]{row, row + 1});
            }
        }).withFilter("a=11").withCheck(dataset -> Assertions.assertThat((boolean)dataset.collectAsList().isEmpty()).isTrue()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testFilterWithClusteringKey(CassandraBridge bridge) {
        int numRows = 10;
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withClusteringKey("b", (CqlField.CqlType)bridge.text()).withClusteringKey("c", (CqlField.CqlType)bridge.timestamp())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                writer.write(new Object[]{200, row < 3 ? "abc" : "def", new Date(10000L * (long)(row + 1))});
            }
        }).withFilter("a=200 and b='def'").withCheck(dataset -> {
            List rows = dataset.collectAsList();
            Assertions.assertThat((boolean)rows.isEmpty()).isFalse();
            Assertions.assertThat((int)rows.size()).isEqualTo(7);
            for (Row row : rows) {
                Assertions.assertThat((int)row.getInt(0)).isEqualTo(200);
                Assertions.assertThat((String)row.getString(1)).isEqualTo("def");
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testLastModifiedTimestampAddedWithStaticColumn(CassandraBridge bridge) {
        int numRows = 5;
        int numColumns = 5;
        long leastExpectedTimestamp = Timestamp.from(Instant.now()).getTime();
        HashSet observedLMT = new HashSet();
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.aInt()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withStaticColumn("a", (CqlField.CqlType)bridge.text())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                for (int column = 0; column < numColumns; ++column) {
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
                    writer.write(new Object[]{row, column, "text" + column});
                }
            }
        }).withLastModifiedTimestampColumn().withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                Assertions.assertThat((int)row.length()).isEqualTo(4);
                Assertions.assertThat((String)String.valueOf(row.get(2))).isEqualTo("text4");
                long lmt = row.getTimestamp(3).getTime();
                Assertions.assertThat((lmt > leastExpectedTimestamp ? 1 : 0) != 0).isTrue();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)observedLMT.add(Pair.of((Object)row.getInt(1), (Object)lmt))).as("Observed a duplicated LMT", new Object[0])).isTrue();
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testLastModifiedTimestampWithExcludeColumns(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.ascii()).withColumn("d", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.text())).withColumn("e", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.bigint(), (CqlField.CqlType)bridge.text()))).withLastModifiedTimestampColumn().withColumns("pk", "ck", "a", "c", "e", "last_modified_timestamp").withExpectedRowCountPerSSTable(200).withCheck(dataset -> {
            List rows = dataset.collectAsList();
            Assertions.assertThat((boolean)rows.isEmpty()).isFalse();
            for (Row row : rows) {
                Assertions.assertThat((boolean)row.schema().getFieldIndex("pk").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("ck").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("a").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("b").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("c").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("d").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("e").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("last_modified_timestamp").isDefined()).isTrue();
                Assertions.assertThat((int)row.length()).isEqualTo(6);
                Assertions.assertThat((boolean)(row.get(0) instanceof String)).isTrue();
                Assertions.assertThat((boolean)(row.get(1) instanceof Integer)).isTrue();
                Assertions.assertThat((boolean)(row.get(2) instanceof Long)).isTrue();
                Assertions.assertThat((boolean)(row.get(3) instanceof String)).isTrue();
                Assertions.assertThat((boolean)(row.get(4) instanceof Map)).isTrue();
                Assertions.assertThat((boolean)(row.get(5) instanceof Timestamp)).isTrue();
                Assertions.assertThat((((Timestamp)row.get(5)).getTime() > 0L ? 1 : 0) != 0).isTrue();
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testLastModifiedTimestampAddedWithSimpleColumns(CassandraBridge bridge) {
        int numRows = 10;
        long leastExpectedTimestamp = Timestamp.from(Instant.now()).getTime();
        HashSet observedLMT = new HashSet();
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.text()).withColumn("b", (CqlField.CqlType)bridge.aDouble()).withColumn("c", (CqlField.CqlType)bridge.uuid())).withLastModifiedTimestampColumn().dontWriteRandomData().withDelayBetweenSSTablesInSecs(10).withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                writer.write(new Object[]{row, "text" + row, Math.random(), UUID.randomUUID()});
            }
        }).withSSTableWriter(writer -> {
            for (int row = 0; row < numRows; ++row) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
                writer.write(new Object[]{row, "text" + row, Math.random(), UUID.randomUUID()});
            }
        }).withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                Assertions.assertThat((int)row.length()).isEqualTo(5);
                long lmt = row.getTimestamp(4).getTime();
                Assertions.assertThat((lmt > leastExpectedTimestamp + 10L ? 1 : 0) != 0).isTrue();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)observedLMT.add(lmt)).as("Observed a duplicated LMT", new Object[0])).isTrue();
            }
        }).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testLastModifiedTimestampAddedWithComplexColumns(CassandraBridge bridge) {
        long leastExpectedTimestamp = Timestamp.from(Instant.now()).getTime();
        HashSet observedLMT = new HashSet();
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.timeuuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.text()).frozen())).withColumn("b", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.text())).withColumn("c", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.tuple(new CqlField.CqlType[]{bridge.bigint(), bridge.timeuuid()})})).withColumn("d", bridge.frozen((CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.aFloat()))).withColumn("e", (CqlField.CqlType)bridge.udt("keyspace", "udt").withField("field1", (CqlField.CqlType)bridge.varchar()).withField("field2", bridge.frozen((CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.text()))).build())).withLastModifiedTimestampColumn().withNumRandomRows(10).withNumRandomSSTables(2).withWriteListener(row -> Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS)).withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                Assertions.assertThat((int)row.length()).isEqualTo(8);
                long lmt = row.getTimestamp(7).getTime();
                Assertions.assertThat((lmt > leastExpectedTimestamp ? 1 : 0) != 0).isTrue();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)observedLMT.add(lmt)).as("Observed a duplicated LMT", new Object[0])).isTrue();
            }
        }).run(bridge.getVersion());
    }
}

