/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class PartitionKeyTests {
    @Test
    public void testSinglePartitionKey() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            List<CqlField> singlePartitionKey = Collections.singletonList(new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.aInt(), 0));
            CqlTable table = (CqlTable)Mockito.mock(CqlTable.class);
            Mockito.when((Object)table.partitionKeys()).thenReturn(singlePartitionKey);
            ByteBuffer key = ByteBuffer.wrap(new byte[]{0, 0, 0, 1});
            AbstractMap.SimpleEntry actualKey = bridge.getPartitionKey(table, partitioner, (List)ImmutableList.of((Object)"1"));
            Assertions.assertThat((Comparable)((ByteBuffer)actualKey.getKey())).isEqualTo((Object)key);
            Assertions.assertThat((BigInteger)((BigInteger)actualKey.getValue())).isEqualTo((Object)bridge.hash(partitioner, key));
            Assertions.assertThat((Comparable)((ByteBuffer)actualKey.getKey())).isNotEqualTo((Object)bridge.aInt().serialize((Object)2));
        });
    }

    @Test
    public void testMultiplePartitionKey() {
        TestUtils.runTest((partitioner, directory, bridge) -> {
            List<CqlField> multiplePartitionKey = Arrays.asList(new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.aInt(), 0), new CqlField(true, false, false, "b", (CqlField.CqlType)bridge.bigint(), 1), new CqlField(true, false, false, "c", (CqlField.CqlType)bridge.text(), 2));
            CqlTable table = (CqlTable)Mockito.mock(CqlTable.class);
            Mockito.when((Object)table.partitionKeys()).thenReturn(multiplePartitionKey);
            ByteBuffer key = ByteBuffer.wrap(new byte[]{0, 4, 0, 0, 0, 3, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 120, 121, 122, 0});
            AbstractMap.SimpleEntry actualKey = bridge.getPartitionKey(table, partitioner, (List)ImmutableList.of((Object)"3", (Object)"1", (Object)"xyz"));
            Assertions.assertThat((Comparable)((ByteBuffer)actualKey.getKey())).isEqualTo((Object)key);
            Assertions.assertThat((BigInteger)((BigInteger)actualKey.getValue())).isEqualTo((Object)bridge.hash(partitioner, key));
        });
    }
}

