/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.TimeSource;

public class SystemTimeSource
implements TimeSource {
    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public TimeSource sleepUninterruptibly(long sleepFor, TimeUnit unit) {
        Uninterruptibles.sleepUninterruptibly(sleepFor, unit);
        return this;
    }

    @Override
    public TimeSource sleep(long sleepFor, TimeUnit unit) throws InterruptedException {
        TimeUnit.NANOSECONDS.sleep(TimeUnit.NANOSECONDS.convert(sleepFor, unit));
        return this;
    }
}

