/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class MBeanGCMonitor {
    MBeanServerConnection connection;
    private Map<String, CollectorTracker> trackers = new LinkedHashMap<String, CollectorTracker>();

    public MBeanGCMonitor(MBeanServerConnection connection) {
        this.connection = connection;
        this.initTrackers();
    }

    private void initTrackers() {
        try {
            for (ObjectName name : this.connection.queryNames(null, null)) {
                if (!name.getDomain().equals("java.lang") || !"GarbageCollector".equals(name.getKeyProperty("type"))) continue;
                CollectorTracker tracker = new CollectorTracker(this.connection, name);
                this.trackers.put(tracker.name, tracker);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String calculateStats() {
        StringBuilder sb = new StringBuilder();
        for (CollectorTracker ct : this.trackers.values()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(ct.calculateStats());
        }
        return sb.toString();
    }

    public String reportCollection() {
        StringBuilder sb = new StringBuilder();
        for (CollectorTracker ct : this.trackers.values()) {
            String report = ct.reportCollection();
            if (report.length() == 0) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(report);
        }
        return sb.toString();
    }

    private static class CollectorTracker {
        private MBeanServerConnection mserv;
        private ObjectName mbean;
        private String name;
        private long initialCount;
        private long initialTime;
        private long prevTimestamp = 0L;
        private long lastCount;

        public CollectorTracker(MBeanServerConnection mserv, ObjectName gcbean) {
            try {
                this.mserv = mserv;
                this.mbean = gcbean;
                this.name = this.getName();
                this.initialCount = this.getCollectionCount();
                this.initialTime = this.getCollectionTime();
                while (this.getCollectionCount() != this.initialCount) {
                    this.initialCount = this.getCollectionCount();
                    this.initialTime = this.getCollectionTime();
                }
                this.lastCount = this.initialCount;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String getName() throws JMException, IOException {
            return (String)this.mserv.getAttribute(this.mbean, "Name");
        }

        private long getCollectionCount() throws JMException, IOException {
            return (Long)this.mserv.getAttribute(this.mbean, "CollectionCount");
        }

        private long getCollectionTime() throws JMException, IOException {
            return (Long)this.mserv.getAttribute(this.mbean, "CollectionTime");
        }

        private CompositeData getLastGcInfo() throws JMException, IOException {
            return (CompositeData)this.mserv.getAttribute(this.mbean, "LastGcInfo");
        }

        public String reportCollection() {
            try {
                long count = this.getCollectionCount();
                CompositeData lastGC = this.getLastGcInfo();
                while (this.getCollectionCount() != count) {
                    count = this.getCollectionCount();
                    lastGC = this.getLastGcInfo();
                }
                if (count == this.lastCount) {
                    return "";
                }
                this.lastCount = count;
                StringBuilder builder = new StringBuilder();
                int id = ((Number)lastGC.get("id")).intValue();
                long dur = (Long)lastGC.get("duration");
                long startTs = (Long)lastGC.get("startTime");
                builder.append("[GC: ").append(this.name).append("#").append(id).append(" time: ");
                builder.append(dur).append("ms");
                long inter = -1L;
                if (this.prevTimestamp != 0L) {
                    inter = startTs - this.prevTimestamp;
                    builder.append(" interval: ").append(inter).append("ms");
                }
                builder.append(" mem:");
                this.prevTimestamp = startTs;
                Map beforeGC = (Map)lastGC.get("memoryUsageBeforeGc");
                Map afterGC = (Map)lastGC.get("memoryUsageAfterGc");
                for (List memPool : afterGC.keySet()) {
                    String ext;
                    double mspeed;
                    String md;
                    String mm3;
                    String mb;
                    String ma;
                    String poolName = (String)memPool.get(0);
                    if (poolName.contains("Perm") || poolName.contains("Cache")) continue;
                    Object[] poolKey = new Object[]{poolName};
                    CompositeData mbefore = (CompositeData)((TabularData)((Object)beforeGC)).get(poolKey).get("value");
                    CompositeData mafter = (CompositeData)((TabularData)((Object)afterGC)).get(poolKey).get("value");
                    long before = (Long)mbefore.get("used");
                    long after = (Long)mafter.get("used");
                    long max = (Long)mbefore.get("max");
                    if (max > 0x40000000L) {
                        ma = (after >> 20) + "m";
                        mb = (before >> 20) + "m";
                        mm3 = (max >> 20) + "m";
                        md = (after - before) / 0x100000L + "m";
                    } else {
                        ma = (after >> 10) + "k";
                        mb = (before >> 10) + "k";
                        mm3 = (max >> 10) + "k";
                        md = (after - before) / 1024L + "k";
                    }
                    if (!md.startsWith("-")) {
                        md = "+" + md;
                    }
                    String mt = inter > 0L ? ((mspeed = 1000.0 * (double)(after - before) / (double)inter) > 1.6777216E7 ? String.format("%.2fMb/s", mspeed / 1048576.0) : String.format("%.2fkb/s", mspeed / 1024.0)) : "";
                    String string = ext = max > 0L ? "max:" + mm3 : "";
                    if (mt.length() > 0) {
                        if (ext.length() > 0) {
                            ext = ext + ",";
                        }
                        ext = ext + "rate:" + mt;
                    }
                    if (ext.length() > 0) {
                        ext = "[" + ext + "]";
                    }
                    builder.append(" ").append(poolName).append(": ").append(mb).append(md).append("->").append(ma).append(ext);
                }
                builder.append("]");
                return builder.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String calculateStats() {
            try {
                long count = this.getCollectionCount();
                long time = this.getCollectionTime();
                while (this.getCollectionCount() != count) {
                    count = this.getCollectionCount();
                    time = this.getCollectionTime();
                }
                double avg = (double)(time - this.initialTime) / (double)(count - this.initialCount);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("%s[ collections: %d | avg: %.4f secs | total: %.1f secs ]", this.name, count - this.initialCount, avg / 1000.0, (double)(time - this.initialTime) / 1000.0));
                return builder.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

