/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarInvoker;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public class Proxy {
    private static final String HOME = System.getProperty("user.home");
    private static boolean sameArg = true;
    private boolean pause = false;
    private boolean verbose = true;
    private boolean leakVerbose = false;
    private boolean fukksor = false;
    private boolean useReflection = false;
    private PrintStream out = System.out;
    private String ourPid;
    private Sigar sigar;
    private SigarProxy proxy;
    private long lastChange = 0L;
    private long startSize = 0L;
    private long currentSize = 0L;
    private PidList pids;
    private NetifList netif;
    private FsList fs;
    private DirList dirs;
    private FileList files;

    public Proxy(Sigar sigar, SigarProxy proxy) {
        this.sigar = sigar;
        this.proxy = proxy;
        this.pids = new PidList(sigar);
        this.netif = new NetifList(sigar);
        this.fs = new FsList(sigar);
        this.dirs = new DirList(HOME);
        this.files = new FileList(HOME);
    }

    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setLeakVerbose(boolean value) {
        this.leakVerbose = value;
    }

    private void output() {
        this.out.println();
    }

    private void output(String s2) {
        String name = Thread.currentThread().getName();
        this.out.println("[" + name + "] " + s2);
    }

    private long getSize() throws SigarException {
        return this.sigar.getProcMem(this.ourPid).getResident();
    }

    private boolean memstat(long i) throws SigarException {
        long size = this.getSize();
        String changed = "";
        if (this.currentSize != size) {
            long diff = size - this.currentSize;
            long iters = i - this.lastChange;
            changed = " (change=" + diff + ", iters=" + iters + ")";
            this.output(i + ") size=" + size + changed);
            this.currentSize = size;
            this.lastChange = i;
            return true;
        }
        return false;
    }

    private void trace(String msg) {
        if (this.verbose) {
            this.output(msg);
        }
    }

    private boolean isNonStringArg(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length >= 1 && paramTypes[0] != String.class;
    }

    private String argsToString(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(').append(args[0].toString());
        for (int i = 1; i < args.length; ++i) {
            sb.append(',').append(args[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }

    private void runall(int iter2) throws SigarException, IllegalAccessException, InvocationTargetException {
        Method[] types = SigarProxy.class.getMethods();
        for (int i = 0; i < types.length; ++i) {
            String arg = null;
            Method method = types[i];
            Class<?>[] parms = method.getParameterTypes();
            String type = method.getName().substring(3);
            Class<?> attrClass = method.getReturnType();
            if (this.isNonStringArg(method)) continue;
            Object[] objArgs = new Object[]{};
            if (attrClass.isArray() || !attrClass.getName().startsWith("org.hyperic.sigar")) {
                if (parms.length > 0) {
                    if (type.startsWith("Proc")) {
                        arg = this.pids.getName(iter2);
                        switch (parms.length) {
                            case 1: {
                                objArgs = new Object[]{arg};
                                break;
                            }
                            case 2: {
                                if (type.equals("ProcEnv")) {
                                    objArgs = new Object[]{arg, "SHELL"};
                                    break;
                                }
                                if (!type.equals("ProcPort")) break;
                                objArgs = new Object[]{"tcp", "80"};
                            }
                        }
                    } else {
                        this.trace("SKIPPING: " + type);
                        continue;
                    }
                }
                Object obj = this.useReflection ? method.invoke((Object)this.sigar, objArgs) : this.invoke(new SigarInvoker(this.proxy, type), objArgs, null);
                if (iter2 > 0 && this.memstat(iter2)) {
                    this.out.print(type);
                    if (arg != null) {
                        this.out.print(" " + arg);
                    }
                    this.output();
                }
                String value = obj instanceof Object[] ? this.argsToString((Object[])obj) : String.valueOf(obj);
                this.trace(type + this.argsToString(objArgs) + "=" + value);
                continue;
            }
            Method[] attrs = attrClass.getMethods();
            for (int j = 0; j < attrs.length; ++j) {
                Object obj;
                String attrName;
                Method getter = attrs[j];
                if (getter.getDeclaringClass() != attrClass || !(attrName = getter.getName()).startsWith("get")) continue;
                attrName = attrName.substring(3);
                objArgs = new Object[]{};
                if (parms.length > 0) {
                    if (type.startsWith("Proc")) {
                        arg = this.pids.getName(iter2);
                    } else if (type.startsWith("Net")) {
                        arg = this.netif.getName(iter2);
                    } else if (type.startsWith("MultiProc")) {
                        arg = "State.Name.eq=java";
                    } else if (type.equals("FileSystemUsage") || type.equals("MountedFileSystemUsage")) {
                        arg = this.fs.getName(iter2);
                    } else if (type.equals("FileInfo") || type.equals("LinkInfo")) {
                        arg = this.files.getName(iter2);
                    } else if (type.equals("DirStat")) {
                        arg = this.dirs.getName(iter2);
                    } else {
                        this.trace("SKIPPING: " + type);
                        continue;
                    }
                    objArgs = new Object[]{arg};
                }
                if (this.isNonStringArg(method)) continue;
                if (this.useReflection) {
                    Object typeObject = method.invoke((Object)this.sigar, objArgs);
                    obj = getter.invoke(typeObject, new Object[0]);
                } else {
                    obj = this.invoke(new SigarInvoker(this.proxy, type), objArgs, attrName);
                }
                if (iter2 > 0 && this.memstat(iter2)) {
                    this.out.print(type);
                    if (arg != null) {
                        this.out.print(" " + arg);
                    }
                    this.output();
                }
                this.trace(type + this.argsToString(objArgs) + "." + attrName + "=" + obj);
                if (!this.pause) continue;
                this.pause();
            }
        }
    }

    private void pause() {
        this.output("hit enter to continue");
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object invoke(SigarInvoker invoker, Object[] args, String attr) {
        String type = invoker.getType();
        if (this.fukksor && args.length != 0 && args[0] instanceof String) {
            args[0] = type.startsWith("Proc") ? new String("666666") : new String("bogus");
        }
        if (args.length == 0) {
            args = null;
        }
        try {
            return invoker.invoke(args, attr);
        }
        catch (SigarException e) {
            String msg = type + " failed: " + e.getMessage();
            System.err.println(msg);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        int expire = 30000;
        Sigar sigar = new Sigar();
        SigarProxy proxy = SigarProxyCache.newInstance(sigar, expire);
        new Proxy(sigar, proxy).run(args);
    }

    public void run(String[] args) throws SigarException {
        this.ourPid = String.valueOf(this.sigar.getPid());
        this.output("ourPid=" + this.ourPid);
        if (args.length >= 2) {
            String type = args[0];
            String attr = args[args.length - 1];
            if (type.equals("leaktest")) {
                int num = Integer.parseInt(args[1]);
                this.verbose = this.leakVerbose;
                this.startSize = this.currentSize = this.getSize();
                long startTime = System.currentTimeMillis();
                for (int i = 0; i < num; ++i) {
                    Sigar s2 = new Sigar();
                    try {
                        this.runall(i);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new SigarException(e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        throw new SigarException(e.getMessage());
                    }
                    finally {
                        s2.close();
                    }
                }
                long totalTime = System.currentTimeMillis() - startTime;
                this.proxy = null;
                this.output("Running garbage collector..");
                System.gc();
                this.memstat(this.lastChange + 1L);
                this.output(num + " iterations took " + totalTime + "ms");
                this.output("startSize=" + this.startSize + ", endSize=" + this.currentSize + ", diff=" + (this.currentSize - this.startSize));
            } else {
                Object obj = this.invoke(new SigarInvoker(this.proxy, type), null, attr);
                this.output(obj.toString());
            }
        } else {
            try {
                this.runall(0);
            }
            catch (IllegalAccessException e) {
                throw new SigarException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new SigarException(e.getMessage());
            }
        }
    }

    private static class FsList
    extends ArgList {
        public FsList(Sigar sigar) {
            try {
                FileSystem[] fs = sigar.getFileSystemList();
                this.values = new String[fs.length];
                for (int i = 0; i < fs.length; ++i) {
                    this.values[i] = fs[i].getDirName();
                }
            }
            catch (SigarException e) {
                e.printStackTrace();
            }
        }
    }

    private static class FileList
    extends ArgList {
        public FileList(String dir) {
            File[] files = new File(dir).listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return !f.isDirectory();
                }
            });
            this.values = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                this.values[i] = files[i].getAbsolutePath();
            }
        }
    }

    private static class DirList
    extends ArgList {
        public DirList(String dir) {
            File[] dirs = new File(dir).listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }
            });
            this.values = new String[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                this.values[i] = dirs[i].getAbsolutePath();
            }
        }
    }

    private static class NetifList
    extends ArgList {
        public NetifList(Sigar sigar) {
            try {
                this.values = sigar.getNetInterfaceList();
            }
            catch (SigarException e) {
                e.printStackTrace();
            }
        }
    }

    private static class PidList
    extends ArgList {
        public PidList(Sigar sigar) {
            try {
                long[] pids = sigar.getProcList();
                this.values = new String[pids.length + 1];
                this.values[0] = String.valueOf(sigar.getPid());
                for (int i = 0; i < pids.length; ++i) {
                    this.values[i + 1] = String.valueOf(pids[i]);
                }
            }
            catch (SigarException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static abstract class ArgList {
        String[] values;
        int ix = 0;

        private ArgList() {
        }

        public String get() {
            if (this.ix == this.values.length) {
                this.ix = 0;
            }
            return this.values[this.ix++];
        }

        public String getName(int iter2) {
            if (iter2 == 0 || sameArg) {
                return this.values[0];
            }
            return this.get();
        }
    }
}

