/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.clients;

import o.a.c.sidecar.client.shaded.client.HttpClientConfig;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarClientConfig;
import o.a.c.sidecar.client.shaded.client.SidecarClientConfigImpl;
import o.a.c.sidecar.client.shaded.client.SidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.VertxOptions;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.utils.BuildInfo;
import org.apache.cassandra.spark.validation.BulkWriterKeyStoreValidation;
import org.apache.cassandra.spark.validation.BulkWriterTrustStoreValidation;
import org.apache.cassandra.spark.validation.SslValidation;
import org.apache.cassandra.spark.validation.StartupValidation;
import org.apache.cassandra.spark.validation.StartupValidator;

public class AnalyticsSidecarClient {
    private AnalyticsSidecarClient() {
    }

    public static SidecarClient from(SidecarInstancesProvider sidecarInstancesProvider, BulkSparkConf conf) {
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setUseDaemonThread(Boolean.valueOf(true)).setWorkerPoolSize(conf.getMaxHttpConnections()));
        String userAgent = AnalyticsSidecarClient.transportModeBasedWriterUserAgent(conf.getTransportInfo().getTransport());
        HttpClientConfig httpClientConfig = new HttpClientConfig.Builder().timeoutMillis((long)conf.getHttpResponseTimeoutMs()).idleTimeoutMillis(conf.getHttpConnectionTimeoutMs()).userAgent(userAgent).keyStoreInputStream(conf.getKeyStore()).keyStorePassword(conf.getKeyStorePassword()).keyStoreType(conf.getKeyStoreTypeOrDefault()).trustStoreInputStream(conf.getTrustStore()).trustStorePassword(conf.getTrustStorePasswordOrDefault()).trustStoreType(conf.getTrustStoreTypeOrDefault()).ssl(conf.hasKeystoreAndKeystorePassword()).cassandraRole(conf.getCassandraRole()).build();
        StartupValidator.instance().register((StartupValidation)new SslValidation(conf));
        StartupValidator.instance().register((StartupValidation)new BulkWriterKeyStoreValidation(conf));
        StartupValidator.instance().register((StartupValidation)new BulkWriterTrustStoreValidation(conf));
        SidecarClientConfig sidecarConfig = SidecarClientConfigImpl.builder().maxRetries(conf.getSidecarRequestRetries()).retryDelayMillis(conf.getSidecarRequestRetryDelayMillis()).maxRetryDelayMillis(conf.getSidecarRequestMaxRetryDelayMillis()).build();
        return Sidecar.buildClient((SidecarClientConfig)sidecarConfig, (Vertx)vertx, (HttpClientConfig)httpClientConfig, (SidecarInstancesProvider)sidecarInstancesProvider);
    }

    static String transportModeBasedWriterUserAgent(DataTransport transport) {
        switch (transport) {
            case S3_COMPAT: {
                return BuildInfo.WRITER_S3_USER_AGENT;
            }
        }
        return BuildInfo.WRITER_USER_AGENT;
    }
}

