/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;

public interface ConsistencyLevel {
    public boolean isLocal();

    public boolean canBeSatisfied(Collection<? extends CassandraInstance> var1, Collection<? extends CassandraInstance> var2, ReplicationFactor var3, String var4);

    default public void ensureNetworkTopologyStrategy(ReplicationFactor replicationFactor, CL cl) {
        Preconditions.checkArgument((replicationFactor.getReplicationStrategy() == ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy ? 1 : 0) != 0, (Object)(cl.name() + " only make sense for NetworkTopologyStrategy keyspaces"));
    }

    public static enum CL implements ConsistencyLevel
    {
        ALL{

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                int blockedFor = replicationFactor.getTotalReplicationFactor() + pendingInstances.size();
                return succeededInstances.size() >= blockedFor;
            }
        }
        ,
        EACH_QUORUM{

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                this.ensureNetworkTopologyStrategy(replicationFactor, EACH_QUORUM);
                for (String datacenter : replicationFactor.getOptions().keySet()) {
                    int blockedFor;
                    int rf = (Integer)replicationFactor.getOptions().get(datacenter);
                    int pendingCountOfDc = CL.countInDc(pendingInstances, datacenter);
                    int succeededCountOfDc = CL.countInDc(succeededInstances, datacenter);
                    if (succeededCountOfDc >= (blockedFor = CL.quorum(rf) + pendingCountOfDc)) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        QUORUM{

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                int rf = replicationFactor.getTotalReplicationFactor();
                int blockedFor = CL.quorum(rf) + pendingInstances.size();
                return succeededInstances.size() >= blockedFor;
            }
        }
        ,
        LOCAL_QUORUM{

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                this.ensureNetworkTopologyStrategy(replicationFactor, LOCAL_QUORUM);
                Objects.requireNonNull(localDC, "localDC cannot be null");
                int rf = (Integer)replicationFactor.getOptions().get(localDC);
                int pendingCountInDc = CL.countInDc(pendingInstances, localDC);
                int succeededCountInDc = CL.countInDc(succeededInstances, localDC);
                int blockFor = CL.quorum(rf) + pendingCountInDc;
                return succeededCountInDc >= blockFor;
            }
        }
        ,
        ONE{

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                int blockFor = 1 + pendingInstances.size();
                return succeededInstances.size() >= blockFor;
            }
        }
        ,
        TWO{

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                int blockFor = 2 + pendingInstances.size();
                return succeededInstances.size() >= blockFor;
            }
        }
        ,
        LOCAL_ONE{

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public boolean canBeSatisfied(Collection<? extends CassandraInstance> succeededInstances, Collection<? extends CassandraInstance> pendingInstances, ReplicationFactor replicationFactor, String localDC) {
                this.ensureNetworkTopologyStrategy(replicationFactor, LOCAL_ONE);
                Objects.requireNonNull(localDC, "localDC cannot be null");
                int pendingCountInDc = CL.countInDc(pendingInstances, localDC);
                int succeededCountInDc = CL.countInDc(succeededInstances, localDC);
                int blockFor = pendingCountInDc + 1;
                return succeededCountInDc >= blockFor;
            }
        };


        private static int quorum(int replicaSetSize) {
            return replicaSetSize / 2 + 1;
        }

        private static int countInDc(Collection<? extends CassandraInstance> instances, String localDC) {
            return (int)instances.stream().filter(i -> i.datacenter().equalsIgnoreCase(localDC)).count();
        }
    }
}

