/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.Objects;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.spark.data.model.TokenOwner;

public class CassandraInstance
implements TokenOwner,
Serializable {
    public static final Serializer SERIALIZER = new Serializer();
    private static final long serialVersionUID = 6767636627576239773L;
    private final String token;
    private final String node;
    private final String dataCenter;

    public CassandraInstance(String token, String node, String dataCenter) {
        this.token = token;
        this.node = node;
        this.dataCenter = dataCenter;
    }

    @Override
    public String token() {
        return this.token;
    }

    public String nodeName() {
        return this.node;
    }

    public String dataCenter() {
        return this.dataCenter;
    }

    public Marker zeroMarker() {
        return this.markerAt(0L, 0);
    }

    public Marker markerAt(long section, int position) {
        return new Marker(this, section, position);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CassandraInstance that = (CassandraInstance)other;
        return Objects.equals(this.token, that.token) && Objects.equals(this.node, that.node) && Objects.equals(this.dataCenter, that.dataCenter);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.node, this.dataCenter);
    }

    public String toString() {
        return String.format("{\"token\"=\"%s\", \"node\"=\"%s\", \"dc\"=\"%s\"}", this.token, this.node, this.dataCenter);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CassandraInstance> {
        public CassandraInstance read(Kryo kryo, Input in, Class type) {
            return new CassandraInstance(in.readString(), in.readString(), in.readString());
        }

        public void write(Kryo kryo, Output out, CassandraInstance instance) {
            out.writeString(instance.token());
            out.writeString(instance.nodeName());
            out.writeString(instance.dataCenter());
        }
    }
}

