/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.util.Objects;
import org.apache.cassandra.spark.utils.Preconditions;

public class TableIdentifier {
    private final String keyspace;
    private final String table;

    public TableIdentifier(String keyspace, String table) {
        Preconditions.checkArgument(!Preconditions.isNullOrEmpty(keyspace), "Keyspace cannot be empty", new Object[0]);
        Preconditions.checkArgument(!Preconditions.isNullOrEmpty(table), "Table cannot be empty", new Object[0]);
        this.keyspace = keyspace;
        this.table = table;
    }

    public static TableIdentifier of(String keyspace, String table) {
        return new TableIdentifier(keyspace, table);
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String table() {
        return this.table;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TableIdentifier that = (TableIdentifier)other;
        return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.table);
    }

    public String toString() {
        return String.format("TableIdentifier{keyspace='%s', table='%s'}", this.keyspace, this.table);
    }
}

