/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.network.sasl.SecretRegistry;

public class SecretRegistryImpl
implements SecretRegistry {
    private static final SecretRegistryImpl INSTANCE = new SecretRegistryImpl();
    private final ConcurrentHashMap<String, String> secrets = new ConcurrentHashMap();

    public static SecretRegistryImpl getInstance() {
        return INSTANCE;
    }

    public void register(String appId, String secret) {
        this.secrets.put(appId, secret);
    }

    public void unregister(String appId) {
        this.secrets.remove(appId);
    }

    @Override
    public boolean isRegistered(String appId) {
        return this.secrets.containsKey(appId);
    }

    @Override
    public String getSecretKey(String appId) {
        return this.secrets.get(appId);
    }
}

